/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.rules;

import java.io.IOException;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import weka.classifiers.rules.Item;
import weka.classifiers.rules.Transaction;

public class RuleL3 {
    private int Rule_ID;
    private int Class_ID;
    private int Length;
    private int Absolute_Support;
    private float Confidence;
    private Item[] Items;
    private int Correct;
    private int Incorrect;
    private int Level;

    public RuleL3() {
    }

    public RuleL3(String rule, int id) throws IOException {
        this.Rule_ID = id;
        String regex = "->";
        String compact_rule = rule.split(regex)[1];
        ArrayList<Double> list = new ArrayList<Double>();
        StringReader str = new StringReader(compact_rule);
        StreamTokenizer stok = new StreamTokenizer(str);
        stok.parseNumbers();
        stok.nextToken();
        while (stok.ttype != -1) {
            if (stok.ttype == -2) {
                list.add(new Double(stok.nval));
            }
            stok.nextToken();
        }
        this.Class_ID = (int)((Double)list.get(0)).doubleValue();
        this.Length = (int)((Double)list.get(3)).doubleValue();
        this.Absolute_Support = (int)((Double)list.get(1)).doubleValue();
        this.Confidence = (float)((Double)list.get(2)).doubleValue();
        this.Items = new Item[this.Length];
        for (int i = 0; i < this.Length; ++i) {
            this.Items[i] = new Item((int)((Double)list.get(4 + i)).doubleValue());
        }
        Arrays.sort(this.Items);
        this.Correct = 0;
        this.Incorrect = 0;
        this.Level = 0;
    }

    public int getRule_ID() {
        return this.Rule_ID;
    }

    public int getClass_ID() {
        return this.Class_ID;
    }

    public int getLength() {
        return this.Length;
    }

    public int getAbsolute_Support() {
        return this.Absolute_Support;
    }

    public float getConfidence() {
        return this.Confidence;
    }

    public Item[] getItems() {
        return this.Items;
    }

    public int getCorrect() {
        return this.Correct;
    }

    public int getIncorrect() {
        return this.Incorrect;
    }

    public int getLevel() {
        return this.Level;
    }

    public void classifyTrans(Transaction trans) {
        boolean matches = true;
        int j = 0;
        for (int i = 0; matches && i < this.Items.length; ++i) {
            matches = false;
            for (j = 0; !matches && j < trans.getItems().length; ++j) {
                if (this.Items[i].getValue() != trans.getItems()[j].getValue()) continue;
                matches = true;
            }
        }
        if (matches) {
            trans.setLast_Rule(this.Rule_ID);
            if (this.Class_ID == trans.getClass_ID()) {
                ++this.Correct;
            } else {
                ++this.Incorrect;
            }
        }
    }

    public void setLevel() {
        if (this.Correct > 0) {
            this.Level = 1;
        } else if (this.Correct == 0 && this.Incorrect == 0) {
            this.Level = 2;
        }
    }
}

