/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.rules;

import java.io.Serializable;
import java.util.Enumeration;
import weka.classifiers.AbstractClassifier;
import weka.core.Attribute;
import weka.core.Capabilities;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.RevisionHandler;
import weka.core.RevisionUtils;
import weka.core.TechnicalInformation;
import weka.core.TechnicalInformationHandler;
import weka.core.Utils;

public class Prism
extends AbstractClassifier
implements TechnicalInformationHandler {
    static final long serialVersionUID = 1310258880025902106L;
    private PrismRule m_rules;

    public String globalInfo() {
        return "Class for building and using a PRISM rule set for classification. Can only deal with nominal attributes. Can't deal with missing values. Doesn't do any pruning.\n\nFor more information, see \n\n" + this.getTechnicalInformation().toString();
    }

    @Override
    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation result = new TechnicalInformation(TechnicalInformation.Type.ARTICLE);
        result.setValue(TechnicalInformation.Field.AUTHOR, "J. Cendrowska");
        result.setValue(TechnicalInformation.Field.YEAR, "1987");
        result.setValue(TechnicalInformation.Field.TITLE, "PRISM: An algorithm for inducing modular rules");
        result.setValue(TechnicalInformation.Field.JOURNAL, "International Journal of Man-Machine Studies");
        result.setValue(TechnicalInformation.Field.VOLUME, "27");
        result.setValue(TechnicalInformation.Field.NUMBER, "4");
        result.setValue(TechnicalInformation.Field.PAGES, "349-370");
        return result;
    }

    @Override
    public double classifyInstance(Instance inst) {
        int result = this.m_rules.resultRules(inst);
        if (result == -1) {
            return Utils.missingValue();
        }
        return result;
    }

    @Override
    public Capabilities getCapabilities() {
        Capabilities result = super.getCapabilities();
        result.disableAll();
        result.enable(Capabilities.Capability.NOMINAL_ATTRIBUTES);
        result.enable(Capabilities.Capability.NOMINAL_CLASS);
        result.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        return result;
    }

    @Override
    public void buildClassifier(Instances data) throws Exception {
        PrismRule rule = null;
        Test test = null;
        Test oldTest = null;
        this.getCapabilities().testWithFail(data);
        data = new Instances(data);
        data.deleteWithMissingClass();
        for (int cl = 0; cl < data.numClasses(); ++cl) {
            Instances E = data;
            while (Prism.contains(E, cl)) {
                rule = this.addRule(rule, new PrismRule(E, cl));
                Instances ruleE = E;
                while (rule.m_errors != 0) {
                    test = new Test();
                    int attUsed = 0;
                    int bestCovers = 0;
                    int bestCorrect = 0;
                    Enumeration enumAtt = ruleE.enumerateAttributes();
                    while (enumAtt.hasMoreElements()) {
                        Attribute attr = (Attribute)enumAtt.nextElement();
                        if (Prism.isMentionedIn(attr, rule.m_test)) {
                            ++attUsed;
                            continue;
                        }
                        int M = attr.numValues();
                        int[] covers = new int[M];
                        int[] correct = new int[M];
                        for (int j = 0; j < M; ++j) {
                            correct[j] = 0;
                            covers[j] = 0;
                        }
                        Enumeration enu = ruleE.enumerateInstances();
                        while (enu.hasMoreElements()) {
                            Instance i = (Instance)enu.nextElement();
                            int n = (int)i.value(attr);
                            covers[n] = covers[n] + 1;
                            if ((int)i.classValue() != cl) continue;
                            int n2 = (int)i.value(attr);
                            correct[n2] = correct[n2] + 1;
                        }
                        for (int val = 0; val < M; ++val) {
                            int diff = correct[val] * bestCovers - bestCorrect * covers[val];
                            if (test.m_attr != -1 && diff <= 0 && (diff != 0 || correct[val] <= bestCorrect)) continue;
                            bestCorrect = correct[val];
                            bestCovers = covers[val];
                            test.m_attr = attr.index();
                            test.m_val = val;
                            rule.m_errors = bestCovers - bestCorrect;
                        }
                    }
                    if (test.m_attr == -1) break;
                    oldTest = this.addTest(rule, oldTest, test);
                    ruleE = rule.coveredBy(ruleE);
                    if (attUsed != data.numAttributes() - 1) continue;
                }
                E = rule.notCoveredBy(E);
            }
        }
    }

    private PrismRule addRule(PrismRule lastRule, PrismRule newRule) {
        if (lastRule == null) {
            this.m_rules = newRule;
        } else {
            lastRule.m_next = newRule;
        }
        return newRule;
    }

    private Test addTest(PrismRule rule, Test lastTest, Test newTest) {
        if (rule.m_test == null) {
            rule.m_test = newTest;
        } else {
            lastTest.m_next = newTest;
        }
        return newTest;
    }

    private static boolean contains(Instances E, int C) throws Exception {
        Enumeration enu = E.enumerateInstances();
        while (enu.hasMoreElements()) {
            if ((int)((Instance)enu.nextElement()).classValue() != C) continue;
            return true;
        }
        return false;
    }

    private static boolean isMentionedIn(Attribute attr, Test t) {
        if (t == null) {
            return false;
        }
        if (t.m_attr == attr.index()) {
            return true;
        }
        return Prism.isMentionedIn(attr, t.m_next);
    }

    public String toString() {
        if (this.m_rules == null) {
            return "Prism: No model built yet.";
        }
        return "Prism rules\n----------\n" + this.m_rules.toString();
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 5529 $");
    }

    public static void main(String[] args) {
        Prism.runClassifier(new Prism(), args);
    }

    private class Test
    implements Serializable,
    RevisionHandler {
        static final long serialVersionUID = -8925333011350280799L;
        private int m_attr = -1;
        private int m_val;
        private Test m_next = null;

        private Test() {
        }

        private boolean satisfies(Instance inst) {
            if ((int)inst.value(this.m_attr) == this.m_val) {
                if (this.m_next == null) {
                    return true;
                }
                return this.m_next.satisfies(inst);
            }
            return false;
        }

        @Override
        public String getRevision() {
            return RevisionUtils.extract("$Revision: 5529 $");
        }
    }

    private class PrismRule
    implements Serializable,
    RevisionHandler {
        static final long serialVersionUID = 4248784350656508583L;
        private int m_classification;
        private Instances m_instances;
        private Test m_test;
        private int m_errors;
        private PrismRule m_next;

        public PrismRule(Instances data, int cl) throws Exception {
            this.m_instances = data;
            this.m_classification = cl;
            this.m_test = null;
            this.m_next = null;
            this.m_errors = 0;
            Enumeration enu = data.enumerateInstances();
            while (enu.hasMoreElements()) {
                if ((int)((Instance)enu.nextElement()).classValue() == cl) continue;
                ++this.m_errors;
            }
            this.m_instances = new Instances(this.m_instances, 0);
        }

        public int resultRule(Instance inst) {
            if (this.m_test == null || this.m_test.satisfies(inst)) {
                return this.m_classification;
            }
            return -1;
        }

        public int resultRules(Instance inst) {
            if (this.resultRule(inst) != -1) {
                return this.m_classification;
            }
            if (this.m_next != null) {
                return this.m_next.resultRules(inst);
            }
            return -1;
        }

        public Instances coveredBy(Instances data) {
            Instances r = new Instances(data, data.numInstances());
            Enumeration enu = data.enumerateInstances();
            while (enu.hasMoreElements()) {
                Instance i = (Instance)enu.nextElement();
                if (this.resultRule(i) == -1) continue;
                r.add(i);
            }
            r.compactify();
            return r;
        }

        public Instances notCoveredBy(Instances data) {
            Instances r = new Instances(data, data.numInstances());
            Enumeration enu = data.enumerateInstances();
            while (enu.hasMoreElements()) {
                Instance i = (Instance)enu.nextElement();
                if (this.resultRule(i) != -1) continue;
                r.add(i);
            }
            r.compactify();
            return r;
        }

        public String toString() {
            try {
                StringBuffer text = new StringBuffer();
                if (this.m_test != null) {
                    text.append("If ");
                    Test t = this.m_test;
                    while (t != null) {
                        if (t.m_attr == -1) {
                            text.append("?");
                        } else {
                            text.append(this.m_instances.attribute(t.m_attr).name() + " = " + this.m_instances.attribute(t.m_attr).value(t.m_val));
                        }
                        if (t.m_next != null) {
                            text.append("\n   and ");
                        }
                        t = t.m_next;
                    }
                    text.append(" then ");
                }
                text.append(this.m_instances.classAttribute().value(this.m_classification) + "\n");
                if (this.m_next != null) {
                    text.append(this.m_next.toString());
                }
                return text.toString();
            }
            catch (Exception e) {
                return "Can't print Prism classifier!";
            }
        }

        @Override
        public String getRevision() {
            return RevisionUtils.extract("$Revision: 5529 $");
        }
    }
}

