/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.rules;

import java.io.IOException;
import java.io.RandomAccessFile;

public class BinaryFile {
    public static final short BIG_ENDIAN = 1;
    public static final short LITTLE_ENDIAN = 2;
    protected RandomAccessFile _file;
    protected short _endian;
    protected boolean _signed;

    public BinaryFile(RandomAccessFile f) {
        this._file = f;
        this._endian = (short)2;
        this._signed = false;
    }

    public void setEndian(short i) throws Exception {
        if (i != 1 && i != 2) {
            throw new Exception("Must be BinaryFile.LITTLE_ENDIAN or BinaryFile.BIG_ENDIAN");
        }
        this._endian = i;
    }

    public int getEndian() {
        return this._endian;
    }

    public void setSigned(boolean b) {
        this._signed = b;
    }

    public boolean getSigned() {
        return this._signed;
    }

    public String readFixedString(int length) throws IOException {
        String rtn = "";
        for (int i = 0; i < length; ++i) {
            rtn = rtn + (char)this._file.readByte();
        }
        return rtn;
    }

    public void writeFixedString(String str, int length) throws IOException {
        int i;
        if (str.length() > length) {
            str = str.substring(0, length);
        }
        for (i = 0; i < str.length(); ++i) {
            this._file.write(str.charAt(i));
        }
        i = length - str.length();
        while (i-- > 0) {
            this._file.write(0);
        }
    }

    public String readLengthPrefixString() throws IOException {
        short len = this.readUnsignedByte();
        return this.readFixedString(len);
    }

    public void writeLengthPrefixString(String str) throws IOException {
        this.writeByte((byte)str.length());
        for (int i = 0; i < str.length(); ++i) {
            this._file.write(str.charAt(i));
        }
    }

    public String readFixedZeroString(int length) throws IOException {
        String rtn = this.readFixedString(length);
        int i = rtn.indexOf(0);
        if (i != -1) {
            rtn = rtn.substring(0, i);
        }
        return rtn;
    }

    public void writeFixedZeroString(String str, int length) throws IOException {
        this.writeFixedString(str, length);
    }

    public String readZeroString() throws IOException {
        char ch;
        String rtn = "";
        do {
            if ((ch = (char)this._file.read()) == '\u0000') continue;
            rtn = rtn + ch;
        } while (ch != '\u0000');
        return rtn;
    }

    public void writeZeroString(String str) throws IOException {
        for (int i = 0; i < str.length(); ++i) {
            this._file.write(str.charAt(i));
        }
        this.writeByte((short)0);
    }

    protected short readUnsignedByte() throws IOException {
        return (short)(this._file.readByte() & 0xFF);
    }

    public short readByte() throws IOException {
        if (this._signed) {
            return this._file.readByte();
        }
        return (short)this._file.readUnsignedByte();
    }

    public void writeByte(short b) throws IOException {
        this._file.write(b & 0xFF);
    }

    public int readWord() throws IOException {
        short a = this.readUnsignedByte();
        short b = this.readUnsignedByte();
        int result = this._endian == 1 ? a << 8 | b : a | b << 8;
        if (this._signed && (result & 0x8000) == 32768) {
            result = -(65536 - result);
        }
        return result;
    }

    public void writeWord(int w) throws IOException {
        if (this._endian == 1) {
            this._file.write((w & 0xFF00) >> 8);
            this._file.write(w & 0xFF);
        } else {
            this._file.write(w & 0xFF);
            this._file.write((w & 0xFF00) >> 8);
        }
    }

    public long readDWord() throws IOException {
        short a = this.readUnsignedByte();
        short b = this.readUnsignedByte();
        short c = this.readUnsignedByte();
        short d = this.readUnsignedByte();
        long result = this._endian == 1 ? (long)(a << 24 | b << 16 | c << 8 | d) : (long)(a | b << 8 | c << 16 | d << 24);
        if (this._signed && (result & 0x80000000L) == 0x80000000L) {
            result = -(0x100000000L - result);
        }
        return result;
    }

    public void writeDWord(long d) throws IOException {
        if (this._endian == 1) {
            this._file.write((int)(d & 0xFFFFFFFFFF000000L) >> 24);
            this._file.write((int)(d & 0xFF0000L) >> 16);
            this._file.write((int)(d & 0xFF00L) >> 8);
            this._file.write((int)(d & 0xFFL));
        } else {
            this._file.write((int)(d & 0xFFL));
            this._file.write((int)(d & 0xFF00L) >> 8);
            this._file.write((int)(d & 0xFF0000L) >> 16);
            this._file.write((int)(d & 0xFFFFFFFFFF000000L) >> 24);
        }
    }

    public void align(int a) throws IOException {
        if (this._file.getFilePointer() % (long)a > 0L) {
            long pos = this._file.getFilePointer() / (long)a;
            this._file.seek((pos + 1L) * (long)a);
        }
    }
}

