/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.meta.timeseriesensembles.depreciated;

import development.DataSets;
import fileIO.InFile;
import fileIO.OutFile;
import java.io.File;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;
import timeseriesweka.classifiers.ensembles.SaveableEnsemble;
import utilities.ClassifierTools;
import utilities.SaveParameterInfo;
import vector_classifiers.TunedRandomForest;
import weka.classifiers.AbstractClassifier;
import weka.classifiers.Classifier;
import weka.classifiers.Evaluation;
import weka.classifiers.bayes.BayesNet;
import weka.classifiers.bayes.NaiveBayes;
import weka.classifiers.functions.SMO;
import weka.classifiers.functions.supportVector.PolyKernel;
import weka.classifiers.lazy.kNN;
import weka.classifiers.meta.RotationForest;
import weka.classifiers.rules.ZeroR;
import weka.classifiers.trees.J48;
import weka.classifiers.trees.RandomForest;
import weka.core.EuclideanDistance;
import weka.core.Instance;
import weka.core.Instances;

public class HESCA_05_10_16
extends AbstractClassifier
implements SaveParameterInfo,
SaveableEnsemble {
    protected Instances train;
    protected Classifier[] c;
    protected ArrayList<String> classifierNames;
    protected double[] cvAccs;
    double[] weights;
    boolean loadCVWeights = false;
    String cvFile = "";
    public static int MAX_NOS_FOLDS = 100;
    Random r = new Random();
    protected boolean setSeed = false;
    protected int seed;
    boolean saveTrain = false;
    boolean saveTest = false;
    String trainDataResultsPath;
    OutFile testData;
    boolean memoryClean = true;
    WeightType w = WeightType.PROPORTIONAL;
    protected double[] predictions;

    @Override
    public void saveResults(String tr, String te) {
        this.setCVPath(tr);
        this.saveTestPreds(te);
    }

    public HESCA_05_10_16() {
        this.classifierNames = new ArrayList();
        this.c = this.setDefaultClassifiers(this.classifierNames);
        this.weights = new double[this.c.length];
        this.cvAccs = new double[this.c.length];
    }

    public HESCA_05_10_16(Classifier[] cl, ArrayList<String> names) {
        this.setClassifiers(cl, names);
        this.weights = new double[this.c.length];
        this.cvAccs = new double[this.c.length];
    }

    public void loadCVWeights(String file) {
        this.loadCVWeights = true;
        this.cvFile = file;
        this.w = WeightType.FIXED;
    }

    public void setRandSeed(int s) {
        this.r = new Random(s);
        this.setSeed = true;
        this.seed = s;
    }

    public void setWeightType(WeightType a) {
        this.w = a;
    }

    public void setWeightType(String s) {
        String str;
        switch (str = s.toUpperCase()) {
            case "EQUAL": 
            case "EQ": 
            case "E": {
                this.w = WeightType.EQUAL;
                break;
            }
            case "BEST": 
            case "B": {
                this.w = WeightType.BEST;
                break;
            }
            case "PROPORTIONAL": 
            case "PROP": 
            case "P": {
                this.w = WeightType.PROPORTIONAL;
                break;
            }
            default: {
                throw new UnsupportedOperationException("Weighting method " + str + " not supported yet.");
            }
        }
    }

    public void setCVPath(String s) {
        this.saveTrain = true;
        this.trainDataResultsPath = s;
    }

    @Override
    public String getParameters() {
        String p = "";
        p = p + "NosClassifiers," + this.c.length + ",type," + (Object)((Object)this.w);
        return p;
    }

    public void saveTestPreds(String s) {
        this.saveTest = true;
        this.testData = new OutFile(s);
    }

    public final Classifier[] setDefaultClassifiers(ArrayList<String> names) {
        ArrayList<AbstractClassifier> classifiers = new ArrayList<AbstractClassifier>();
        kNN k = new kNN(100);
        k.setCrossValidate(true);
        k.normalise(false);
        k.setDistanceFunction(new EuclideanDistance());
        classifiers.add(k);
        names.add("NN");
        classifiers.add(new NaiveBayes());
        names.add("NB");
        J48 tree = new J48();
        classifiers.add(tree);
        names.add("C45");
        SMO svm = new SMO();
        PolyKernel kernel = new PolyKernel();
        kernel.setExponent(1.0);
        svm.setKernel(kernel);
        if (this.setSeed) {
            svm.setRandomSeed(this.seed);
        }
        classifiers.add(svm);
        names.add("SVML");
        svm = new SMO();
        kernel = new PolyKernel();
        kernel.setExponent(2.0);
        svm.setKernel(kernel);
        if (this.setSeed) {
            svm.setRandomSeed(this.seed);
        }
        classifiers.add(svm);
        names.add("SVMQ");
        TunedRandomForest r = new TunedRandomForest();
        r.setNumTrees(500);
        if (this.setSeed) {
            ((RandomForest)r).setSeed(this.seed);
        }
        classifiers.add(r);
        names.add("RandF");
        RotationForest rf = new RotationForest();
        rf.setNumIterations(50);
        if (this.setSeed) {
            rf.setSeed(this.seed);
        }
        classifiers.add(rf);
        names.add("RotF");
        BayesNet bn = new BayesNet();
        classifiers.add(bn);
        names.add("bayesNet");
        Classifier[] sc = new Classifier[classifiers.size()];
        for (int i = 0; i < sc.length; ++i) {
            sc[i] = (Classifier)classifiers.get(i);
        }
        return sc;
    }

    public final void setClassifiers(Classifier[] cl, ArrayList<String> names) {
        this.c = cl;
        this.classifierNames = new ArrayList<String>(names);
        this.weights = new double[this.c.length];
        this.cvAccs = new double[this.c.length];
    }

    public final double[] getWeights() {
        return this.weights;
    }

    public final double[] getCVAccs() {
        return this.cvAccs;
    }

    @Override
    public void buildClassifier(Instances data) throws Exception {
        int i;
        this.train = data;
        if (data.numInstances() > 500 || data.numAttributes() > 500) {
            MAX_NOS_FOLDS = 10;
        }
        OutFile of = null;
        if (this.saveTrain) {
            of = new OutFile(this.trainDataResultsPath);
            for (String s : this.classifierNames) {
                of.writeString(s + ",");
            }
            of.writeString("\n");
        }
        if (this.w == WeightType.FIXED) {
            if (!new File(this.cvFile).exists()) {
                System.out.println("ERROR: FILE " + this.cvFile + " DOES NOT EXIST .. its going to crash now ...");
            }
            InFile inf = new InFile(this.cvFile);
            inf.readLine();
            double sum = 0.0;
            for (i = 0; i < this.c.length; ++i) {
                this.cvAccs[i] = inf.readDouble();
                sum += this.cvAccs[i];
            }
            for (i = 0; i < this.c.length; ++i) {
                this.weights[i] = this.cvAccs[i] / sum;
            }
            for (i = 0; i < this.c.length; ++i) {
                this.c[i].buildClassifier(this.train);
            }
        } else if (this.w == WeightType.EQUAL) {
            int i2;
            for (i2 = 0; i2 < this.c.length; ++i2) {
                this.cvAccs[i2] = 1.0;
                this.weights[i2] = 1.0 / (double)this.c.length;
            }
            for (i2 = 0; i2 < this.c.length; ++i2) {
                this.c[i2].buildClassifier(this.train);
            }
        } else {
            double sum = 0.0;
            for (i = 0; i < this.c.length; ++i) {
                if (this.c[i] instanceof TunedRandomForest) {
                    this.c[i].buildClassifier(this.train);
                    this.cvAccs[i] = 1.0 - ((TunedRandomForest)this.c[i]).measureOutOfBagError();
                    sum += this.cvAccs[i];
                    continue;
                }
                Evaluation eval = new Evaluation(this.train);
                int folds = 10;
                try {
                    eval.crossValidateModel(this.c[i], this.train, folds, this.r, new Object[0]);
                    this.cvAccs[i] = 1.0 - eval.errorRate();
                    this.c[i].buildClassifier(this.train);
                }
                catch (Exception e) {
                    System.out.println("Caught illegal argument exception " + e);
                    this.cvAccs[i] = 0.0;
                    this.c[i] = new ZeroR();
                    this.c[i].buildClassifier(this.train);
                }
                sum += this.cvAccs[i];
                if (!this.memoryClean) continue;
                System.gc();
            }
            for (i = 0; i < this.c.length; ++i) {
                this.weights[i] = this.cvAccs[i] / sum;
            }
            if (this.saveTrain) {
                for (i = 0; i < this.c.length; ++i) {
                    of.writeString(this.cvAccs[i] + ",");
                }
                of.writeString("\n");
            }
        }
        if (this.w == WeightType.BEST) {
            int i3;
            int bestPos = 0;
            for (i3 = 1; i3 < this.weights.length; ++i3) {
                if (!(this.weights[i3] > this.weights[bestPos])) continue;
                bestPos = i3;
            }
            for (i3 = 0; i3 < this.weights.length; ++i3) {
                this.weights[i3] = i3 == bestPos ? 1.0 : 0.0;
            }
        }
    }

    public double[] getPredictions() {
        return this.predictions;
    }

    @Override
    public double[] distributionForInstance(Instance ins) throws Exception {
        int i;
        this.predictions = new double[this.c.length];
        double[] preds = new double[ins.numClasses()];
        if (this.saveTest) {
            this.testData.writeString(ins.classValue() + ",");
        }
        for (int i2 = 0; i2 < this.c.length; ++i2) {
            this.predictions[i2] = this.c[i2].classifyInstance(ins);
            if (this.saveTest) {
                this.testData.writeString(this.predictions[i2] + ",");
            }
            int n = (int)this.predictions[i2];
            preds[n] = preds[n] + this.weights[i2];
        }
        double sum = preds[0];
        for (i = 1; i < preds.length; ++i) {
            sum += preds[i];
        }
        i = 0;
        while (i < preds.length) {
            int n = i++;
            preds[n] = preds[n] / sum;
        }
        if (this.saveTest) {
            this.testData.writeString("\n");
        }
        return preds;
    }

    public ArrayList<String> getNames() {
        return this.classifierNames;
    }

    public static void debugTest() {
        double a;
        String problem = "ItalyPowerDemand";
        Instances train = ClassifierTools.loadData(DataSets.dropboxPath + problem + "\\" + problem + "_TRAIN");
        Instances test = ClassifierTools.loadData(DataSets.dropboxPath + problem + "\\" + problem + "_TEST");
        HESCA_05_10_16 we = new HESCA_05_10_16();
        DecimalFormat df = new DecimalFormat("###.###");
        try {
            Classifier[] c = new Classifier[3];
            ArrayList<String> names = new ArrayList<String>();
            kNN k = new kNN(100);
            k.setCrossValidate(true);
            k.normalise(false);
            k.setDistanceFunction(new EuclideanDistance());
            c[0] = k;
            names.add("NN");
            c[1] = new NaiveBayes();
            names.add("NB");
            c[2] = new J48();
            names.add("C45");
            we.setClassifiers(c, names);
            we.setWeightType("EQUAL");
            we.buildClassifier(train);
            a = ClassifierTools.accuracy(test, we);
            System.out.println(" WE accuracy with equal weight=" + a);
            we.setWeightType("Proportional");
            we.buildClassifier(train);
            double[] w = we.getWeights();
            double[] cv = we.getCVAccs();
            for (int i = 0; i < w.length; ++i) {
                System.out.println("Weight =" + df.format(w[i]) + " CV =" + df.format(cv[i]));
            }
            a = ClassifierTools.accuracy(test, we);
            System.out.println(" WE accuracy with prop weight=" + a);
        }
        catch (Exception ex) {
            Logger.getLogger(HESCA_05_10_16.class.getName()).log(Level.SEVERE, null, ex);
        }
        try {
            we = new HESCA_05_10_16();
            we.setWeightType("Proportional");
            we.buildClassifier(train);
            double[] w = we.getWeights();
            double[] cv = we.getCVAccs();
            for (int i = 0; i < w.length; ++i) {
                System.out.println("Weight =" + df.format(w[i]) + " CV =" + df.format(cv[i]));
            }
            a = ClassifierTools.accuracy(test, we);
            System.out.println(" WE accuracy with prop weight=" + a);
        }
        catch (Exception ex) {
            Logger.getLogger(HESCA_05_10_16.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public static void testFileSave() throws Exception {
        Instances train = ClassifierTools.loadData("C:\\Users\\ajb\\Dropbox\\TSC Problems\\ItalyPowerDemand\\ItalyPowerDemand_TRAIN");
        Instances test = ClassifierTools.loadData("C:\\Users\\ajb\\Dropbox\\TSC Problems\\ItalyPowerDemand\\ItalyPowerDemand_TEST");
        HESCA_05_10_16 we = new HESCA_05_10_16();
        we.saveTestPreds("C:\\Users\\ajb\\Dropbox\\TSC Problems\\ItalyPowerDemand\\TestPreds.csv");
        we.setCVPath("C:\\Users\\ajb\\Dropbox\\TSC Problems\\ItalyPowerDemand\\TrainCV.csv");
        we.buildClassifier(train);
        for (Instance ins : test) {
            we.classifyInstance(ins);
        }
    }

    public static void main(String[] args) throws Exception {
        HESCA_05_10_16.testFileSave();
    }

    public static enum WeightType {
        EQUAL,
        BEST,
        PROPORTIONAL,
        FIXED,
        SIGNIFICANT_BINOMIAL,
        SIGNIFICANT_MCNEMAR;

    }
}

