/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.meta;

import java.util.Random;
import weka.classifiers.AbstractClassifier;
import weka.classifiers.Classifier;
import weka.classifiers.functions.LinearRegression;
import weka.classifiers.meta.Stacking;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.OptionHandler;
import weka.core.RevisionUtils;
import weka.core.SelectedTag;
import weka.core.TechnicalInformation;
import weka.core.TechnicalInformationHandler;
import weka.core.Utils;
import weka.filters.Filter;
import weka.filters.unsupervised.attribute.MakeIndicator;
import weka.filters.unsupervised.attribute.Remove;

public class StackingC
extends Stacking
implements OptionHandler,
TechnicalInformationHandler {
    static final long serialVersionUID = -6717545616603725198L;
    protected Classifier[] m_MetaClassifiers = null;
    protected Remove m_attrFilter = null;
    protected MakeIndicator m_makeIndicatorFilter = null;

    public StackingC() {
        this.m_MetaClassifier = new LinearRegression();
        ((LinearRegression)this.getMetaClassifier()).setAttributeSelectionMethod(new SelectedTag(1, LinearRegression.TAGS_SELECTION));
    }

    @Override
    public String globalInfo() {
        return "Implements StackingC (more efficient version of stacking).\n\nFor more information, see\n\n" + this.getTechnicalInformation().toString() + "\n\nNote: requires meta classifier to be a numeric prediction scheme.";
    }

    @Override
    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation result = new TechnicalInformation(TechnicalInformation.Type.INPROCEEDINGS);
        result.setValue(TechnicalInformation.Field.AUTHOR, "A.K. Seewald");
        result.setValue(TechnicalInformation.Field.TITLE, "How to Make Stacking Better and Faster While Also Taking Care of an Unknown Weakness");
        result.setValue(TechnicalInformation.Field.BOOKTITLE, "Nineteenth International Conference on Machine Learning");
        result.setValue(TechnicalInformation.Field.EDITOR, "C. Sammut and A. Hoffmann");
        result.setValue(TechnicalInformation.Field.YEAR, "2002");
        result.setValue(TechnicalInformation.Field.PAGES, "554-561");
        result.setValue(TechnicalInformation.Field.PUBLISHER, "Morgan Kaufmann Publishers");
        return result;
    }

    @Override
    protected String metaOption() {
        return "\tFull name of meta classifier, followed by options.\n\tMust be a numeric prediction scheme. Default: Linear Regression.";
    }

    @Override
    protected void processMetaOptions(String[] options) throws Exception {
        String classifierString = Utils.getOption('M', options);
        String[] classifierSpec = Utils.splitOptions(classifierString);
        if (classifierSpec.length != 0) {
            String classifierName = classifierSpec[0];
            classifierSpec[0] = "";
            this.setMetaClassifier(AbstractClassifier.forName(classifierName, classifierSpec));
        } else {
            ((LinearRegression)this.getMetaClassifier()).setAttributeSelectionMethod(new SelectedTag(1, LinearRegression.TAGS_SELECTION));
        }
    }

    @Override
    protected void generateMetaLevel(Instances newData, Random random) throws Exception {
        Instances metaData = this.metaFormat(newData);
        this.m_MetaFormat = new Instances(metaData, 0);
        for (int j = 0; j < this.m_NumFolds; ++j) {
            Instances train = newData.trainCV(this.m_NumFolds, j, random);
            for (int i = 0; i < this.m_Classifiers.length; ++i) {
                this.getClassifier(i).buildClassifier(train);
            }
            Instances test = newData.testCV(this.m_NumFolds, j);
            for (int i = 0; i < test.numInstances(); ++i) {
                metaData.add(this.metaInstance(test.instance(i)));
            }
        }
        this.m_MetaClassifiers = AbstractClassifier.makeCopies(this.m_MetaClassifier, this.m_BaseFormat.numClasses());
        int[] arrIdc = new int[this.m_Classifiers.length + 1];
        arrIdc[this.m_Classifiers.length] = metaData.numAttributes() - 1;
        for (int i = 0; i < this.m_MetaClassifiers.length; ++i) {
            for (int j = 0; j < this.m_Classifiers.length; ++j) {
                arrIdc[j] = this.m_BaseFormat.numClasses() * j + i;
            }
            this.m_makeIndicatorFilter = new MakeIndicator();
            this.m_makeIndicatorFilter.setAttributeIndex("" + (metaData.classIndex() + 1));
            this.m_makeIndicatorFilter.setNumeric(true);
            this.m_makeIndicatorFilter.setValueIndex(i);
            this.m_makeIndicatorFilter.setInputFormat(metaData);
            Instances newInsts = Filter.useFilter(metaData, this.m_makeIndicatorFilter);
            this.m_attrFilter = new Remove();
            this.m_attrFilter.setInvertSelection(true);
            this.m_attrFilter.setAttributeIndicesArray(arrIdc);
            this.m_attrFilter.setInputFormat(this.m_makeIndicatorFilter.getOutputFormat());
            newInsts = Filter.useFilter(newInsts, this.m_attrFilter);
            newInsts.setClassIndex(newInsts.numAttributes() - 1);
            this.m_MetaClassifiers[i].buildClassifier(newInsts);
        }
    }

    @Override
    public double[] distributionForInstance(Instance instance) throws Exception {
        int[] arrIdc = new int[this.m_Classifiers.length + 1];
        arrIdc[this.m_Classifiers.length] = this.m_MetaFormat.numAttributes() - 1;
        double[] classProbs = new double[this.m_BaseFormat.numClasses()];
        double sum = 0.0;
        for (int i = 0; i < this.m_MetaClassifiers.length; ++i) {
            for (int j = 0; j < this.m_Classifiers.length; ++j) {
                arrIdc[j] = this.m_BaseFormat.numClasses() * j + i;
            }
            this.m_makeIndicatorFilter.setAttributeIndex("" + (this.m_MetaFormat.classIndex() + 1));
            this.m_makeIndicatorFilter.setNumeric(true);
            this.m_makeIndicatorFilter.setValueIndex(i);
            this.m_makeIndicatorFilter.setInputFormat(this.m_MetaFormat);
            this.m_makeIndicatorFilter.input(this.metaInstance(instance));
            this.m_makeIndicatorFilter.batchFinished();
            Instance newInst = this.m_makeIndicatorFilter.output();
            this.m_attrFilter.setAttributeIndicesArray(arrIdc);
            this.m_attrFilter.setInvertSelection(true);
            this.m_attrFilter.setInputFormat(this.m_makeIndicatorFilter.getOutputFormat());
            this.m_attrFilter.input(newInst);
            this.m_attrFilter.batchFinished();
            newInst = this.m_attrFilter.output();
            classProbs[i] = this.m_MetaClassifiers[i].classifyInstance(newInst);
            if (classProbs[i] > 1.0) {
                classProbs[i] = 1.0;
            }
            if (classProbs[i] < 0.0) {
                classProbs[i] = 0.0;
            }
            sum += classProbs[i];
        }
        if (sum != 0.0) {
            Utils.normalize(classProbs, sum);
        }
        return classProbs;
    }

    @Override
    public String toString() {
        int i;
        if (this.m_MetaFormat == null) {
            return "StackingC: No model built yet.";
        }
        String result = "StackingC\n\nBase classifiers\n\n";
        for (i = 0; i < this.m_Classifiers.length; ++i) {
            result = result + this.getClassifier(i).toString() + "\n\n";
        }
        result = result + "\n\nMeta classifiers (one for each class)\n\n";
        for (i = 0; i < this.m_MetaClassifiers.length; ++i) {
            result = result + this.m_MetaClassifiers[i].toString() + "\n\n";
        }
        return result;
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 1.15 $");
    }

    public static void main(String[] argv) {
        StackingC.runClassifier(new StackingC(), argv);
    }
}

