/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.meta;

import java.util.ArrayList;
import java.util.Random;
import weka.classifiers.AbstractClassifier;
import weka.classifiers.Classifier;
import weka.classifiers.Evaluation;
import weka.core.Instance;
import weka.core.Instances;

public class HeterogeneousEnsemble
extends AbstractClassifier {
    ArrayList<Classifier> ensemble;
    Instances train;
    double[] weights;
    double weightsSD = 0.0;
    WeightType w;
    private static final double THRESHOLD1 = 100.0;

    private HeterogeneousEnsemble() {
    }

    public HeterogeneousEnsemble(ArrayList<Classifier> cl) {
        this.ensemble = new ArrayList<Classifier>(cl);
        this.weights = new double[this.ensemble.size()];
        this.w = WeightType.EQUAL;
    }

    public HeterogeneousEnsemble(Classifier[] cl) {
        this.ensemble = new ArrayList();
        for (Classifier c : cl) {
            this.ensemble.add(c);
        }
        this.weights = new double[this.ensemble.size()];
        this.w = WeightType.EQUAL;
    }

    public void useCVWeighting(boolean c) {
        this.w = c ? WeightType.CV : WeightType.EQUAL;
    }

    @Override
    public void buildClassifier(Instances data) throws Exception {
        this.train = data;
        for (Classifier c : this.ensemble) {
            c.buildClassifier(this.train);
        }
        switch (this.w) {
            case EQUAL: {
                for (int i = 0; i < this.ensemble.size(); ++i) {
                    this.weights[i] = 1.0 / (double)this.ensemble.size();
                }
                break;
            }
            case CV: {
                this.findCVWeights();
                break;
            }
            default: {
                System.out.println("Error: weight method not implemented");
                throw new UnsupportedOperationException();
            }
        }
    }

    @Override
    public double[] distributionForInstance(Instance ins) {
        int i;
        double[] dist = new double[ins.numClasses()];
        for (int i2 = 0; i2 < this.ensemble.size(); ++i2) {
            try {
                Classifier c = this.ensemble.get(i2);
                double[] temp = c.distributionForInstance(ins);
                for (int j = 0; j < dist.length; ++j) {
                    int n = j;
                    dist[n] = dist[n] + this.weights[i2] * temp[j];
                }
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
                System.out.println("Error classifying instance with classifier ");
                System.exit(0);
            }
        }
        double x = dist[0];
        for (i = 1; i < dist.length; ++i) {
            x += dist[i];
        }
        i = 0;
        while (i < dist.length) {
            int n = i++;
            dist[n] = dist[n] / x;
        }
        return dist;
    }

    public void findCVWeights() throws Exception {
        int i;
        this.weights = new double[this.ensemble.size()];
        double sum = 0.0;
        double sumSq = 0.0;
        int folds = this.train.numInstances();
        if ((double)folds > 100.0) {
            folds = 10;
        }
        System.out.print("\n Finding CV Accuracy WITHIN ensemble: ");
        for (i = 0; i < this.ensemble.size(); ++i) {
            Evaluation evaluation = new Evaluation(this.train);
            evaluation.crossValidateModel(this.ensemble.get(i), this.train, folds, new Random(), new Object[0]);
            this.weights[i] = 1.0 - evaluation.errorRate();
            sum += this.weights[i];
            sumSq += this.weights[i] * this.weights[i];
            System.out.print("," + this.weights[i]);
        }
        System.out.print("\n");
        i = 0;
        while (i < this.weights.length) {
            int n = i++;
            this.weights[n] = this.weights[n] / sum;
        }
        this.weightsSD = (sumSq - sum * sum / (double)this.weights.length) / (double)(this.weights.length - 1);
        this.weightsSD = Math.sqrt(this.weightsSD);
    }

    @Override
    public String getRevision() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public double[] getWeights() {
        return this.weights;
    }

    public double getWeightsSD() {
        return this.weightsSD;
    }

    public static enum WeightType {
        EQUAL,
        CV;

    }
}

