/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.functions;

import java.util.Enumeration;
import java.util.Vector;
import weka.classifiers.AbstractClassifier;
import weka.core.Aggregateable;
import weka.core.Capabilities;
import weka.core.ConjugateGradientOptimization;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Optimization;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.RevisionUtils;
import weka.core.TechnicalInformation;
import weka.core.TechnicalInformationHandler;
import weka.core.Utils;
import weka.core.WeightedInstancesHandler;
import weka.filters.Filter;
import weka.filters.unsupervised.attribute.NominalToBinary;
import weka.filters.unsupervised.attribute.RemoveUseless;
import weka.filters.unsupervised.attribute.ReplaceMissingValues;

public class Logistic
extends AbstractClassifier
implements OptionHandler,
WeightedInstancesHandler,
TechnicalInformationHandler,
Aggregateable<Logistic> {
    static final long serialVersionUID = 3932117032546553727L;
    protected double[][] m_Par;
    protected double[][] m_Data;
    protected int m_NumPredictors;
    protected int m_ClassIndex;
    protected int m_NumClasses;
    protected double m_Ridge = 1.0E-8;
    private RemoveUseless m_AttFilter;
    private NominalToBinary m_NominalToBinary;
    private ReplaceMissingValues m_ReplaceMissingValues;
    protected boolean m_Debug;
    protected double m_LL;
    private int m_MaxIts = -1;
    private boolean m_useConjugateGradientDescent = false;
    private Instances m_structure;
    protected int m_numModels = 0;

    public String globalInfo() {
        return "Class for building and using a multinomial logistic regression model with a ridge estimator.\n\nThere are some modifications, however, compared to the paper of leCessie and van Houwelingen(1992): \n\nIf there are k classes for n instances with m attributes, the parameter matrix B to be calculated will be an m*(k-1) matrix.\n\nThe probability for class j with the exception of the last class is\n\nPj(Xi) = exp(XiBj)/((sum[j=1..(k-1)]exp(Xi*Bj))+1) \n\nThe last class has probability\n\n1-(sum[j=1..(k-1)]Pj(Xi)) \n\t= 1/((sum[j=1..(k-1)]exp(Xi*Bj))+1)\n\nThe (negative) multinomial log-likelihood is thus: \n\nL = -sum[i=1..n]{\n\tsum[j=1..(k-1)](Yij * ln(Pj(Xi)))\n\t+(1 - (sum[j=1..(k-1)]Yij)) \n\t* ln(1 - sum[j=1..(k-1)]Pj(Xi))\n\t} + ridge * (B^2)\n\nIn order to find the matrix B for which L is minimised, a Quasi-Newton Method is used to search for the optimized values of the m*(k-1) variables.  Note that before we use the optimization procedure, we 'squeeze' the matrix B into a m*(k-1) vector.  For details of the optimization procedure, please check weka.core.Optimization class.\n\nAlthough original Logistic Regression does not deal with instance weights, we modify the algorithm a little bit to handle the instance weights.\n\nFor more information see:\n\n" + this.getTechnicalInformation().toString() + "\n\nNote: Missing values are replaced using a ReplaceMissingValuesFilter, and nominal attributes are transformed into numeric attributes using a NominalToBinaryFilter.";
    }

    @Override
    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation result = new TechnicalInformation(TechnicalInformation.Type.ARTICLE);
        result.setValue(TechnicalInformation.Field.AUTHOR, "le Cessie, S. and van Houwelingen, J.C.");
        result.setValue(TechnicalInformation.Field.YEAR, "1992");
        result.setValue(TechnicalInformation.Field.TITLE, "Ridge Estimators in Logistic Regression");
        result.setValue(TechnicalInformation.Field.JOURNAL, "Applied Statistics");
        result.setValue(TechnicalInformation.Field.VOLUME, "41");
        result.setValue(TechnicalInformation.Field.NUMBER, "1");
        result.setValue(TechnicalInformation.Field.PAGES, "191-201");
        return result;
    }

    @Override
    public Enumeration listOptions() {
        Vector<Option> newVector = new Vector<Option>(4);
        newVector.addElement(new Option("\tTurn on debugging output.", "D", 0, "-D"));
        newVector.addElement(new Option("\tUse conjugate gradient descent rather than BFGS updates.", "C", 0, "-C"));
        newVector.addElement(new Option("\tSet the ridge in the log-likelihood.", "R", 1, "-R <ridge>"));
        newVector.addElement(new Option("\tSet the maximum number of iterations (default -1, until convergence).", "M", 1, "-M <number>"));
        return newVector.elements();
    }

    @Override
    public void setOptions(String[] options) throws Exception {
        this.setDebug(Utils.getFlag('D', options));
        this.setUseConjugateGradientDescent(Utils.getFlag('C', options));
        String ridgeString = Utils.getOption('R', options);
        this.m_Ridge = ridgeString.length() != 0 ? Double.parseDouble(ridgeString) : 1.0E-8;
        String maxItsString = Utils.getOption('M', options);
        this.m_MaxIts = maxItsString.length() != 0 ? Integer.parseInt(maxItsString) : -1;
    }

    @Override
    public String[] getOptions() {
        String[] options = new String[6];
        int current = 0;
        if (this.getDebug()) {
            options[current++] = "-D";
        }
        if (this.getUseConjugateGradientDescent()) {
            options[current++] = "-C";
        }
        options[current++] = "-R";
        options[current++] = "" + this.m_Ridge;
        options[current++] = "-M";
        options[current++] = "" + this.m_MaxIts;
        while (current < options.length) {
            options[current++] = "";
        }
        return options;
    }

    @Override
    public String debugTipText() {
        return "Output debug information to the console.";
    }

    @Override
    public void setDebug(boolean debug) {
        this.m_Debug = debug;
    }

    @Override
    public boolean getDebug() {
        return this.m_Debug;
    }

    public String useConjugateGradientDescentTipText() {
        return "Use conjugate gradient descent rather than BFGS updates; faster for problems with many parameters.";
    }

    public void setUseConjugateGradientDescent(boolean useConjugateGradientDescent) {
        this.m_useConjugateGradientDescent = useConjugateGradientDescent;
    }

    public boolean getUseConjugateGradientDescent() {
        return this.m_useConjugateGradientDescent;
    }

    public String ridgeTipText() {
        return "Set the Ridge value in the log-likelihood.";
    }

    public void setRidge(double ridge) {
        this.m_Ridge = ridge;
    }

    public double getRidge() {
        return this.m_Ridge;
    }

    public String maxItsTipText() {
        return "Maximum number of iterations to perform.";
    }

    public int getMaxIts() {
        return this.m_MaxIts;
    }

    public void setMaxIts(int newMaxIts) {
        this.m_MaxIts = newMaxIts;
    }

    @Override
    public Capabilities getCapabilities() {
        Capabilities result = super.getCapabilities();
        result.disableAll();
        result.enable(Capabilities.Capability.NOMINAL_ATTRIBUTES);
        result.enable(Capabilities.Capability.NUMERIC_ATTRIBUTES);
        result.enable(Capabilities.Capability.DATE_ATTRIBUTES);
        result.enable(Capabilities.Capability.MISSING_VALUES);
        result.enable(Capabilities.Capability.NOMINAL_CLASS);
        result.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        return result;
    }

    @Override
    public void buildClassifier(Instances train) throws Exception {
        int j;
        int i;
        this.getCapabilities().testWithFail(train);
        train = new Instances(train);
        train.deleteWithMissingClass();
        this.m_ReplaceMissingValues = new ReplaceMissingValues();
        this.m_ReplaceMissingValues.setInputFormat(train);
        train = Filter.useFilter(train, this.m_ReplaceMissingValues);
        this.m_AttFilter = new RemoveUseless();
        this.m_AttFilter.setInputFormat(train);
        train = Filter.useFilter(train, this.m_AttFilter);
        this.m_NominalToBinary = new NominalToBinary();
        this.m_NominalToBinary.setInputFormat(train);
        train = Filter.useFilter(train, this.m_NominalToBinary);
        this.m_structure = new Instances(train, 0);
        this.m_ClassIndex = train.classIndex();
        this.m_NumClasses = train.numClasses();
        int nK = this.m_NumClasses - 1;
        int nR = this.m_NumPredictors = train.numAttributes() - 1;
        int nC = train.numInstances();
        this.m_Data = new double[nC][nR + 1];
        int[] Y = new int[nC];
        double[] xMean = new double[nR + 1];
        double[] xSD = new double[nR + 1];
        double[] sY = new double[nK + 1];
        double[] weights = new double[nC];
        double totWeights = 0.0;
        this.m_Par = new double[nR + 1][nK];
        if (this.m_Debug) {
            System.out.println("Extracting data...");
        }
        for (i = 0; i < nC; ++i) {
            Instance current = train.instance(i);
            Y[i] = (int)current.classValue();
            weights[i] = current.weight();
            totWeights += weights[i];
            this.m_Data[i][0] = 1.0;
            int j2 = 1;
            for (int k = 0; k <= nR; ++k) {
                double x;
                if (k == this.m_ClassIndex) continue;
                this.m_Data[i][j2] = x = current.value(k);
                int n = j2;
                xMean[n] = xMean[n] + weights[i] * x;
                int n2 = j2++;
                xSD[n2] = xSD[n2] + weights[i] * x * x;
            }
            int n = Y[i];
            sY[n] = sY[n] + 1.0;
        }
        if (totWeights <= 1.0 && nC > 1) {
            throw new Exception("Sum of weights of instances less than 1, please reweight!");
        }
        xMean[0] = 0.0;
        xSD[0] = 1.0;
        for (j = 1; j <= nR; ++j) {
            xMean[j] = xMean[j] / totWeights;
            xSD[j] = totWeights > 1.0 ? Math.sqrt(Math.abs(xSD[j] - totWeights * xMean[j] * xMean[j]) / (totWeights - 1.0)) : 0.0;
        }
        if (this.m_Debug) {
            System.out.println("Descriptives...");
            for (int m = 0; m <= nK; ++m) {
                System.out.println(sY[m] + " cases have class " + m);
            }
            System.out.println("\n Variable     Avg       SD    ");
            for (j = 1; j <= nR; ++j) {
                System.out.println(Utils.doubleToString(j, 8, 4) + Utils.doubleToString(xMean[j], 10, 4) + Utils.doubleToString(xSD[j], 10, 4));
            }
        }
        for (i = 0; i < nC; ++i) {
            for (int j3 = 0; j3 <= nR; ++j3) {
                if (xSD[j3] == 0.0) continue;
                this.m_Data[i][j3] = (this.m_Data[i][j3] - xMean[j3]) / xSD[j3];
            }
        }
        if (this.m_Debug) {
            System.out.println("\nIteration History...");
        }
        double[] x = new double[(nR + 1) * nK];
        double[][] b = new double[2][x.length];
        for (int p = 0; p < nK; ++p) {
            int offset = p * (nR + 1);
            x[offset] = Math.log(sY[p] + 1.0) - Math.log(sY[nK] + 1.0);
            b[0][offset] = Double.NaN;
            b[1][offset] = Double.NaN;
            for (int q = 1; q <= nR; ++q) {
                x[offset + q] = 0.0;
                b[0][offset + q] = Double.NaN;
                b[1][offset + q] = Double.NaN;
            }
        }
        OptObject oO = new OptObject();
        oO.setWeights(weights);
        oO.setClassLabels(Y);
        Optimization opt = null;
        opt = this.m_useConjugateGradientDescent ? new OptEngCG(oO) : new OptEng(oO);
        opt.setDebug(this.m_Debug);
        if (this.m_MaxIts == -1) {
            x = opt.findArgmin(x, b);
            while (x == null) {
                x = opt.getVarbValues();
                if (this.m_Debug) {
                    System.out.println("First set of iterations finished, not enough!");
                }
                x = opt.findArgmin(x, b);
            }
            if (this.m_Debug) {
                System.out.println(" -------------<Converged>--------------");
            }
        } else {
            opt.setMaxIteration(this.m_MaxIts);
            x = opt.findArgmin(x, b);
            if (x == null) {
                x = opt.getVarbValues();
            }
        }
        this.m_LL = -opt.getMinFunction();
        this.m_Data = null;
        for (int i2 = 0; i2 < nK; ++i2) {
            this.m_Par[0][i2] = x[i2 * (nR + 1)];
            for (int j4 = 1; j4 <= nR; ++j4) {
                this.m_Par[j4][i2] = x[i2 * (nR + 1) + j4];
                if (xSD[j4] == 0.0) continue;
                double[] dArray = this.m_Par[j4];
                int n = i2;
                dArray[n] = dArray[n] / xSD[j4];
                double[] dArray2 = this.m_Par[0];
                int n3 = i2;
                dArray2[n3] = dArray2[n3] - this.m_Par[j4][i2] * xMean[j4];
            }
        }
    }

    @Override
    public double[] distributionForInstance(Instance instance) throws Exception {
        this.m_ReplaceMissingValues.input(instance);
        instance = this.m_ReplaceMissingValues.output();
        this.m_AttFilter.input(instance);
        instance = this.m_AttFilter.output();
        this.m_NominalToBinary.input(instance);
        instance = this.m_NominalToBinary.output();
        double[] instDat = new double[this.m_NumPredictors + 1];
        int j = 1;
        instDat[0] = 1.0;
        for (int k = 0; k <= this.m_NumPredictors; ++k) {
            if (k == this.m_ClassIndex) continue;
            instDat[j++] = instance.value(k);
        }
        double[] distribution = this.evaluateProbability(instDat);
        return distribution;
    }

    private double[] evaluateProbability(double[] data) {
        double[] prob = new double[this.m_NumClasses];
        double[] v = new double[this.m_NumClasses];
        for (int j = 0; j < this.m_NumClasses - 1; ++j) {
            for (int k = 0; k <= this.m_NumPredictors; ++k) {
                int n = j;
                v[n] = v[n] + this.m_Par[k][j] * data[k];
            }
        }
        v[this.m_NumClasses - 1] = 0.0;
        for (int m = 0; m < this.m_NumClasses; ++m) {
            double sum = 0.0;
            for (int n = 0; n < this.m_NumClasses - 1; ++n) {
                sum += Math.exp(v[n] - v[m]);
            }
            prob[m] = 1.0 / (sum + Math.exp(-v[m]));
        }
        return prob;
    }

    public double[][] coefficients() {
        return this.m_Par;
    }

    public String toString() {
        int i;
        int i2;
        StringBuffer temp = new StringBuffer();
        String result = "";
        temp.append("Logistic Regression with ridge parameter of " + this.m_Ridge);
        if (this.m_Par == null) {
            return result + ": No model built yet.";
        }
        int attLength = 0;
        for (int i3 = 0; i3 < this.m_structure.numAttributes(); ++i3) {
            if (i3 == this.m_structure.classIndex() || this.m_structure.attribute(i3).name().length() <= attLength) continue;
            attLength = this.m_structure.attribute(i3).name().length();
        }
        if ("Intercept".length() > attLength) {
            attLength = "Intercept".length();
        }
        if ("Variable".length() > attLength) {
            attLength = "Variable".length();
        }
        attLength += 2;
        int colWidth = 0;
        for (i2 = 0; i2 < this.m_structure.classAttribute().numValues() - 1; ++i2) {
            if (this.m_structure.classAttribute().value(i2).length() <= colWidth) continue;
            colWidth = this.m_structure.classAttribute().value(i2).length();
        }
        for (int j = 1; j <= this.m_NumPredictors; ++j) {
            for (int k = 0; k < this.m_NumClasses - 1; ++k) {
                if (Utils.doubleToString(this.m_Par[j][k], 12, 4).trim().length() > colWidth) {
                    colWidth = Utils.doubleToString(this.m_Par[j][k], 12, 4).trim().length();
                }
                double ORc = Math.exp(this.m_Par[j][k]);
                String t = " " + (ORc > 1.0E10 ? "" + ORc : Utils.doubleToString(ORc, 12, 4));
                if (t.trim().length() <= colWidth) continue;
                colWidth = t.trim().length();
            }
        }
        if ("Class".length() > colWidth) {
            colWidth = "Class".length();
        }
        temp.append("\nCoefficients...\n");
        temp.append(Utils.padLeft(" ", attLength) + Utils.padLeft("Class", colWidth += 2) + "\n");
        temp.append(Utils.padRight("Variable", attLength));
        for (i2 = 0; i2 < this.m_NumClasses - 1; ++i2) {
            String className = this.m_structure.classAttribute().value(i2);
            temp.append(Utils.padLeft(className, colWidth));
        }
        temp.append("\n");
        int separatorL = attLength + (this.m_NumClasses - 1) * colWidth;
        for (int i4 = 0; i4 < separatorL; ++i4) {
            temp.append("=");
        }
        temp.append("\n");
        int j = 1;
        for (i = 0; i < this.m_structure.numAttributes(); ++i) {
            if (i == this.m_structure.classIndex()) continue;
            temp.append(Utils.padRight(this.m_structure.attribute(i).name(), attLength));
            for (int k = 0; k < this.m_NumClasses - 1; ++k) {
                temp.append(Utils.padLeft(Utils.doubleToString(this.m_Par[j][k], 12, 4).trim(), colWidth));
            }
            temp.append("\n");
            ++j;
        }
        temp.append(Utils.padRight("Intercept", attLength));
        for (int k = 0; k < this.m_NumClasses - 1; ++k) {
            temp.append(Utils.padLeft(Utils.doubleToString(this.m_Par[0][k], 10, 4).trim(), colWidth));
        }
        temp.append("\n");
        temp.append("\n\nOdds Ratios...\n");
        temp.append(Utils.padLeft(" ", attLength) + Utils.padLeft("Class", colWidth) + "\n");
        temp.append(Utils.padRight("Variable", attLength));
        for (i = 0; i < this.m_NumClasses - 1; ++i) {
            String className = this.m_structure.classAttribute().value(i);
            temp.append(Utils.padLeft(className, colWidth));
        }
        temp.append("\n");
        for (i = 0; i < separatorL; ++i) {
            temp.append("=");
        }
        temp.append("\n");
        j = 1;
        for (i = 0; i < this.m_structure.numAttributes(); ++i) {
            if (i == this.m_structure.classIndex()) continue;
            temp.append(Utils.padRight(this.m_structure.attribute(i).name(), attLength));
            for (int k = 0; k < this.m_NumClasses - 1; ++k) {
                double ORc = Math.exp(this.m_Par[j][k]);
                String ORs = " " + (ORc > 1.0E10 ? "" + ORc : Utils.doubleToString(ORc, 12, 4));
                temp.append(Utils.padLeft(ORs.trim(), colWidth));
            }
            temp.append("\n");
            ++j;
        }
        return temp.toString();
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 9785 $");
    }

    @Override
    public Logistic aggregate(Logistic toAggregate) throws Exception {
        if (this.m_numModels == Integer.MIN_VALUE) {
            throw new Exception("Can't aggregate further - model has already been aggregated and finalized");
        }
        if (this.m_Par == null) {
            throw new Exception("No model built yet, can't aggregate");
        }
        if (!this.m_structure.equalHeaders(toAggregate.m_structure)) {
            throw new Exception("Can't aggregate - data headers dont match: " + this.m_structure.equalHeadersMsg(toAggregate.m_structure));
        }
        for (int i = 0; i < this.m_Par.length; ++i) {
            for (int j = 0; j < this.m_Par[i].length; ++j) {
                double[] dArray = this.m_Par[i];
                int n = j;
                dArray[n] = dArray[n] + toAggregate.m_Par[i][j];
            }
        }
        ++this.m_numModels;
        return this;
    }

    @Override
    public void finalizeAggregation() throws Exception {
        if (this.m_numModels == Integer.MIN_VALUE) {
            throw new Exception("Aggregation has already been finalized");
        }
        if (this.m_numModels == 0) {
            throw new Exception("Unable to finalize aggregation - haven't seen any models to aggregate");
        }
        for (int i = 0; i < this.m_Par.length; ++i) {
            int j = 0;
            while (j < this.m_Par[i].length) {
                double[] dArray = this.m_Par[i];
                int n = j++;
                dArray[n] = dArray[n] / (double)(this.m_numModels + 1);
            }
        }
        this.m_numModels = Integer.MIN_VALUE;
    }

    public static void main(String[] argv) {
        Logistic.runClassifier(new Logistic(), argv);
    }

    private class OptObject {
        private double[] weights;
        private int[] cls;

        private OptObject() {
        }

        public void setWeights(double[] w) {
            this.weights = w;
        }

        public void setClassLabels(int[] c) {
            this.cls = c;
        }

        protected double objectiveFunction(double[] x) {
            double nll = 0.0;
            int dim = Logistic.this.m_NumPredictors + 1;
            for (int i = 0; i < this.cls.length; ++i) {
                double[] exp = new double[Logistic.this.m_NumClasses - 1];
                for (int offset = 0; offset < Logistic.this.m_NumClasses - 1; ++offset) {
                    int index = offset * dim;
                    for (int j = 0; j < dim; ++j) {
                        int n = offset;
                        exp[n] = exp[n] + Logistic.this.m_Data[i][j] * x[index + j];
                    }
                }
                double max = exp[Utils.maxIndex(exp)];
                double denom = Math.exp(-max);
                double num = this.cls[i] == Logistic.this.m_NumClasses - 1 ? -max : exp[this.cls[i]] - max;
                for (int offset = 0; offset < Logistic.this.m_NumClasses - 1; ++offset) {
                    denom += Math.exp(exp[offset] - max);
                }
                nll -= this.weights[i] * (num - Math.log(denom));
            }
            for (int offset = 0; offset < Logistic.this.m_NumClasses - 1; ++offset) {
                for (int r = 1; r < dim; ++r) {
                    nll += Logistic.this.m_Ridge * x[offset * dim + r] * x[offset * dim + r];
                }
            }
            return nll;
        }

        protected double[] evaluateGradient(double[] x) {
            double[] grad = new double[x.length];
            int dim = Logistic.this.m_NumPredictors + 1;
            for (int i = 0; i < this.cls.length; ++i) {
                int index;
                double[] num = new double[Logistic.this.m_NumClasses - 1];
                for (int offset = 0; offset < Logistic.this.m_NumClasses - 1; ++offset) {
                    double exp = 0.0;
                    index = offset * dim;
                    for (int j = 0; j < dim; ++j) {
                        exp += Logistic.this.m_Data[i][j] * x[index + j];
                    }
                    num[offset] = exp;
                }
                double max = num[Utils.maxIndex(num)];
                double denom = Math.exp(-max);
                for (int offset = 0; offset < Logistic.this.m_NumClasses - 1; ++offset) {
                    num[offset] = Math.exp(num[offset] - max);
                    denom += num[offset];
                }
                Utils.normalize(num, denom);
                for (int offset = 0; offset < Logistic.this.m_NumClasses - 1; ++offset) {
                    index = offset * dim;
                    double firstTerm = this.weights[i] * num[offset];
                    for (int q = 0; q < dim; ++q) {
                        int n = index + q;
                        grad[n] = grad[n] + firstTerm * Logistic.this.m_Data[i][q];
                    }
                }
                if (this.cls[i] == Logistic.this.m_NumClasses - 1) continue;
                for (int p = 0; p < dim; ++p) {
                    int n = this.cls[i] * dim + p;
                    grad[n] = grad[n] - this.weights[i] * Logistic.this.m_Data[i][p];
                }
            }
            for (int offset = 0; offset < Logistic.this.m_NumClasses - 1; ++offset) {
                for (int r = 1; r < dim; ++r) {
                    int n = offset * dim + r;
                    grad[n] = grad[n] + 2.0 * Logistic.this.m_Ridge * x[offset * dim + r];
                }
            }
            return grad;
        }
    }

    private class OptEngCG
    extends ConjugateGradientOptimization {
        OptObject m_oO = null;

        private OptEngCG(OptObject oO) {
            this.m_oO = oO;
        }

        @Override
        protected double objectiveFunction(double[] x) {
            return this.m_oO.objectiveFunction(x);
        }

        @Override
        protected double[] evaluateGradient(double[] x) {
            return this.m_oO.evaluateGradient(x);
        }

        @Override
        public String getRevision() {
            return RevisionUtils.extract("$Revision: 9785 $");
        }
    }

    private class OptEng
    extends Optimization {
        OptObject m_oO = null;

        private OptEng(OptObject oO) {
            this.m_oO = oO;
        }

        @Override
        protected double objectiveFunction(double[] x) {
            return this.m_oO.objectiveFunction(x);
        }

        @Override
        protected double[] evaluateGradient(double[] x) {
            return this.m_oO.evaluateGradient(x);
        }

        @Override
        public String getRevision() {
            return RevisionUtils.extract("$Revision: 9785 $");
        }
    }
}

