/*
 * Decompiled with CFR 0.152.
 */
package vector_classifiers;

import development.CollateResults;
import fileIO.OutFile;
import java.io.File;
import java.io.FileNotFoundException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;
import timeseriesweka.classifiers.ParameterSplittable;
import utilities.ClassifierResults;
import utilities.ClassifierTools;
import utilities.CrossValidator;
import utilities.InstanceTools;
import utilities.SaveParameterInfo;
import utilities.TrainAccuracyEstimate;
import vector_classifiers.SaveEachParameter;
import weka.classifiers.functions.SMO;
import weka.classifiers.functions.supportVector.PolyKernel;
import weka.classifiers.functions.supportVector.RBFKernel;
import weka.core.Instance;
import weka.core.Instances;

public class TunedSVM
extends SMO
implements SaveParameterInfo,
TrainAccuracyEstimate,
SaveEachParameter,
ParameterSplittable {
    boolean setSeed = false;
    int seed;
    int minC = -16;
    int maxC = 16;
    int minExponent = 1;
    int maxExponent = 6;
    int minB = 0;
    int maxB = 5;
    double IncrementB = 1.0;
    double[] paraSpace1;
    double[] paraSpace2;
    double[] paraSpace3;
    private static int MAX_FOLDS = 10;
    private double[] paras;
    String trainPath = "";
    boolean debug = false;
    protected boolean findTrainAcc = true;
    Random rng;
    ArrayList<Double> accuracy;
    private boolean kernelOptimise = false;
    private boolean tuneParameters = true;
    private ClassifierResults res = new ClassifierResults();
    private long combinedBuildTime;
    private boolean buildFromFile = false;
    protected String resultsPath;
    protected boolean saveEachParaAcc = false;
    KernelType kernel = KernelType.RBF;

    @Override
    public void setPathToSaveParameters(String r) {
        this.resultsPath = r;
        this.setSaveEachParaAcc(true);
    }

    @Override
    public void setSaveEachParaAcc(boolean b) {
        this.saveEachParaAcc = b;
    }

    public TunedSVM() {
        this.setKernel(new RBFKernel());
        this.rng = new Random();
        this.accuracy = new ArrayList();
        this.setBuildLogisticModels(true);
    }

    public void estimateAccFromTrain(boolean b) {
        this.findTrainAcc = b;
    }

    public void setSeed(int s) {
        this.setSeed = true;
        this.seed = s;
        this.rng = new Random();
        this.rng.setSeed(this.seed);
    }

    @Override
    public void writeCVTrainToFile(String train) {
        this.trainPath = train;
    }

    @Override
    public ClassifierResults getTrainResults() {
        return this.res;
    }

    @Override
    public String getParameters() {
        String result = "BuildTime," + this.res.buildTime + ",CVAcc," + this.res.acc;
        result = result + ",C," + this.paras[0];
        if (this.paras.length > 1) {
            if (this.kernel == KernelType.RBF) {
                result = result + ",Gamma," + this.paras[1];
            } else if (this.paras.length > 2 && this.kernel == KernelType.POLYNOMIAL) {
                result = result + ",Power," + this.paras[1] + ",b," + this.paras[2];
            }
        }
        for (double d : this.accuracy) {
            result = result + "," + d;
        }
        return result;
    }

    @Override
    public void setParamSearch(boolean b) {
        this.tuneParameters = b;
    }

    @Override
    public void setParametersFromIndex(int x) {
        this.kernelOptimise = false;
        this.tuneParameters = false;
        int numCParas = this.maxC - this.minC + 1;
        if (this.kernel == KernelType.LINEAR || this.kernel == KernelType.QUADRATIC) {
            if (x < 1 || x > numCParas) {
                throw new UnsupportedOperationException("ERROR parameter index " + x + " out of range " + this.minC + " to max");
            }
            this.paras = new double[1];
            this.paras[0] = Math.pow(2.0, this.minC + (x - 1));
            this.setC(this.paras[0]);
        } else if (this.kernel == KernelType.RBF) {
            if (x < 1 || x > numCParas * numCParas) {
                throw new UnsupportedOperationException("ERROR parameter index " + x + " out of range " + this.minC + " to max");
            }
            this.paras = new double[2];
            int temp = this.minC + (x - 1) / numCParas;
            this.paras[0] = Math.pow(2.0, temp);
            temp = this.minC + (x - 1) % numCParas;
            this.paras[1] = Math.pow(2.0, temp);
            this.setC(this.paras[0]);
            ((RBFKernel)this.m_kernel).setGamma(this.paras[1]);
            System.out.println("");
        } else if (this.kernel == KernelType.POLYNOMIAL) {
            this.paras = new double[3];
            int numExpParas = this.maxExponent - this.minExponent + 1;
            int numBParas = this.maxB - this.minB + 1;
            if (x < 1 || x > numCParas * numExpParas * numBParas) {
                throw new UnsupportedOperationException("ERROR parameter index " + x + " out of range for PolyNomialKernel");
            }
            int cPara = this.minC + (x - 1) % numCParas;
            int expPara = this.minExponent + (x - 1) / (numBParas * numCParas);
            int bPara = this.minB + (x - 1) / numCParas % numBParas;
            this.paras[0] = Math.pow(2.0, cPara);
            this.paras[1] = expPara;
            this.paras[2] = bPara;
            PolynomialKernel kern = new PolynomialKernel();
            kern.setExponent(this.paras[1]);
            kern.setB(this.paras[2]);
            this.setKernel(kern);
            this.setC(this.paras[0]);
            System.out.println("Index " + x + " maps to " + cPara + "," + expPara + "," + bPara);
        }
    }

    @Override
    public String getParas() {
        return this.getParameters();
    }

    @Override
    public double getAcc() {
        return this.res.acc;
    }

    public void debug(boolean b) {
        this.debug = b;
    }

    public void setKernelType(KernelType type) {
        this.kernel = type;
        switch (type) {
            case LINEAR: {
                PolynomialKernel p = new PolynomialKernel();
                p.setExponent(1.0);
                this.setKernel(p);
                break;
            }
            case QUADRATIC: {
                PolynomialKernel p2 = new PolynomialKernel();
                p2.setExponent(2.0);
                this.setKernel(p2);
                break;
            }
            case POLYNOMIAL: {
                PolynomialKernel p3 = new PolynomialKernel();
                p3.setExponent(1.0);
                this.setKernel(p3);
                break;
            }
            case RBF: {
                RBFKernel kernel2 = new RBFKernel();
                this.setKernel(kernel2);
            }
        }
    }

    public void setParaSpace(double[] p) {
        this.paraSpace1 = p;
    }

    public void setStandardParaSearchSpace() {
        block5: {
            int i;
            block4: {
                this.paraSpace1 = new double[this.maxC - this.minC + 1];
                for (i = this.minC; i <= this.maxC; ++i) {
                    this.paraSpace1[i - this.minC] = Math.pow(2.0, i);
                }
                if (this.kernel != KernelType.RBF) break block4;
                this.paraSpace2 = new double[this.maxC - this.minC + 1];
                for (i = this.minC; i <= this.maxC; ++i) {
                    this.paraSpace2[i - this.minC] = Math.pow(2.0, i);
                }
                break block5;
            }
            if (this.kernel != KernelType.POLYNOMIAL) break block5;
            this.paraSpace2 = new double[this.maxExponent - this.minExponent + 1];
            this.paraSpace3 = new double[this.maxB - this.minB + 1];
            for (i = this.minExponent; i <= this.maxExponent; ++i) {
                this.paraSpace2[i - this.minExponent] = i;
            }
            for (i = this.minB; i <= this.maxB; ++i) {
                this.paraSpace3[i - this.minB] = i;
            }
        }
    }

    public void setLargePolynomialParameterSpace(int n) {
        this.paraSpace1 = new double[n];
        double interval = (this.maxC - this.minC) / (n - 1);
        double exp = this.minC;
        for (int i = 0; i < n; ++i) {
            this.paraSpace1[i] = Math.pow(2.0, exp);
            exp += interval;
        }
    }

    public void optimiseKernel(boolean b) {
        this.kernelOptimise = b;
    }

    public boolean getOptimiseKernel() {
        return this.kernelOptimise;
    }

    public void optimiseParas(boolean b) {
        this.tuneParameters = b;
    }

    public void tuneRBF(Instances train) throws Exception {
        ClassifierResults tempResults;
        this.paras = new double[2];
        int folds = MAX_FOLDS;
        if (folds > train.numInstances()) {
            folds = train.numInstances();
        }
        double minErr = 1.0;
        this.setSeed(this.rng.nextInt());
        Instances trainCopy = new Instances(train);
        CrossValidator cv = new CrossValidator();
        if (this.setSeed) {
            cv.setSeed(this.seed);
        }
        cv.setNumFolds(folds);
        cv.buildFolds(trainCopy);
        ArrayList<ResultsHolder> ties = new ArrayList<ResultsHolder>();
        int count = 0;
        OutFile temp = null;
        for (double p1 : this.paraSpace1) {
            for (double p2 : this.paraSpace2) {
                File f;
                if (this.saveEachParaAcc && (f = new File(this.resultsPath + ++count + ".csv")).exists()) {
                    if (f.length() != 0L) continue;
                    f.delete();
                }
                SMO model = new SMO();
                RBFKernel kern = new RBFKernel();
                kern.setGamma(p2);
                model.setKernel(kern);
                model.setC(p1);
                model.setBuildLogisticModels(true);
                tempResults = cv.crossValidateWithStats(model, trainCopy);
                tempResults.setName("TunedSVM" + (Object)((Object)this.kernel));
                tempResults.setParas("C," + p1 + ",Gamma," + p2);
                double e = 1.0 - tempResults.acc;
                this.accuracy.add(tempResults.acc);
                if (this.debug) {
                    System.out.println(" C= " + p1 + " Gamma = " + p2 + " Acc = " + (1.0 - e));
                }
                if (this.saveEachParaAcc) {
                    temp = new OutFile(this.resultsPath + count + ".csv");
                    temp.writeLine(tempResults.writeResultsFileToString());
                    temp.closeFile();
                    File f2 = new File(this.resultsPath + count + ".csv");
                    if (!f2.exists()) continue;
                    f2.setWritable(true, false);
                    continue;
                }
                if (e < minErr) {
                    minErr = e;
                    ties = new ArrayList();
                    ties.add(new ResultsHolder(p1, p2, tempResults));
                    continue;
                }
                if (e != minErr) continue;
                ties.add(new ResultsHolder(p1, p2, tempResults));
            }
        }
        minErr = 1.0;
        if (this.saveEachParaAcc) {
            int missing = 0;
            for (double p1 : this.paraSpace1) {
                for (double p2 : this.paraSpace1) {
                    File f = new File(this.resultsPath + count + ".csv");
                    if (f.exists() && f.length() > 0L) continue;
                    ++missing;
                }
            }
            if (missing == 0) {
                this.combinedBuildTime = 0L;
                count = 0;
                for (double p1 : this.paraSpace1) {
                    for (double p2 : this.paraSpace1) {
                        tempResults = new ClassifierResults();
                        tempResults.loadFromFile(this.resultsPath + ++count + ".csv");
                        this.combinedBuildTime += tempResults.buildTime;
                        double e = 1.0 - tempResults.acc;
                        if (e < minErr) {
                            minErr = e;
                            ties = new ArrayList();
                            ties.add(new ResultsHolder(p1, p2, tempResults));
                        } else if (e == minErr) {
                            ties.add(new ResultsHolder(p1, p2, tempResults));
                        }
                        File f = new File(this.resultsPath + count + ".csv");
                        if (f.delete()) continue;
                        System.out.println("DELETE FAILED " + this.resultsPath + count + ".csv");
                    }
                }
                ResultsHolder best = (ResultsHolder)ties.get(this.rng.nextInt(ties.size()));
                double bestC = best.x;
                double bestSigma = best.y;
                this.paras[0] = bestC;
                this.setC(bestC);
                ((RBFKernel)this.m_kernel).setGamma(bestSigma);
                this.paras[1] = bestSigma;
                this.res = best.res;
                if (this.debug) {
                    System.out.println("Best C =" + bestC + " best Gamma = " + bestSigma + " best train acc = " + this.res.acc);
                }
            } else {
                System.out.println(this.resultsPath + " error: missing  =" + missing + " parameter values");
            }
        } else {
            ResultsHolder best = (ResultsHolder)ties.get(this.rng.nextInt(ties.size()));
            double bestC = best.x;
            double bestSigma = best.y;
            this.paras[0] = bestC;
            this.setC(bestC);
            ((RBFKernel)this.m_kernel).setGamma(bestSigma);
            this.paras[1] = bestSigma;
            this.res = best.res;
        }
    }

    public void tunePolynomial(Instances train) throws Exception {
        ClassifierResults tempResults;
        this.paras = new double[3];
        int folds = MAX_FOLDS;
        if (folds > train.numInstances()) {
            folds = train.numInstances();
        }
        double minErr = 1.0;
        this.setSeed(this.rng.nextInt());
        Instances trainCopy = new Instances(train);
        CrossValidator cv = new CrossValidator();
        if (this.setSeed) {
            cv.setSeed(this.seed);
        }
        cv.setNumFolds(folds);
        cv.buildFolds(trainCopy);
        ArrayList<ResultsHolder> ties = new ArrayList<ResultsHolder>();
        int count = 0;
        OutFile temp = null;
        for (double p1 : this.paraSpace1) {
            for (double p2 : this.paraSpace2) {
                for (double p3 : this.paraSpace3) {
                    File f;
                    if (this.saveEachParaAcc && (f = new File(this.resultsPath + ++count + ".csv")).exists()) {
                        if (CollateResults.validateSingleFoldFile(this.resultsPath + count + ".csv")) continue;
                        System.out.println("Deleting file " + this.resultsPath + count + ".csv because incomplete, size =" + f.length());
                    }
                    SMO model = new SMO();
                    PolynomialKernel kern = new PolynomialKernel();
                    kern.setExponent(p2);
                    kern.setB(p3);
                    model.setKernel(kern);
                    model.setC(p1);
                    model.setBuildLogisticModels(true);
                    tempResults = cv.crossValidateWithStats(model, trainCopy);
                    double e = 1.0 - tempResults.acc;
                    this.accuracy.add(tempResults.acc);
                    if (this.debug) {
                        System.out.println("C=" + p1 + ",Exp=" + p2 + ",B=" + p3 + ", Acc = " + (1.0 - e));
                    }
                    if (this.saveEachParaAcc) {
                        temp = new OutFile(this.resultsPath + count + ".csv");
                        temp.writeLine(tempResults.writeResultsFileToString());
                        temp.closeFile();
                        continue;
                    }
                    if (e < minErr) {
                        minErr = e;
                        ties = new ArrayList();
                        ties.add(new ResultsHolder(p1, p2, p3, tempResults));
                        continue;
                    }
                    if (e != minErr) continue;
                    ties.add(new ResultsHolder(p1, p2, p3, tempResults));
                }
            }
        }
        minErr = 1.0;
        if (this.saveEachParaAcc) {
            int missing = 0;
            for (double p1 : this.paraSpace1) {
                double[] dArray = this.paraSpace2;
                int n = dArray.length;
                for (int i = 0; i < n; ++i) {
                    double p2 = dArray[i];
                    for (double p3 : this.paraSpace3) {
                        File f = new File(this.resultsPath + count + ".csv");
                        if (f.exists() && f.length() > 0L) continue;
                        ++missing;
                    }
                }
            }
            if (missing == 0) {
                this.combinedBuildTime = 0L;
                count = 0;
                for (double p1 : this.paraSpace1) {
                    for (double p2 : this.paraSpace2) {
                        for (double p3 : this.paraSpace3) {
                            tempResults = new ClassifierResults();
                            tempResults.loadFromFile(this.resultsPath + ++count + ".csv");
                            this.combinedBuildTime += tempResults.buildTime;
                            double e = 1.0 - tempResults.acc;
                            if (e < minErr) {
                                minErr = e;
                                ties = new ArrayList();
                                ties.add(new ResultsHolder(p1, p2, p3, tempResults));
                            } else if (e == minErr) {
                                ties.add(new ResultsHolder(p1, p2, p3, tempResults));
                            }
                            File f = new File(this.resultsPath + count + ".csv");
                            if (f.delete()) continue;
                            System.out.println("DELETE FAILED " + this.resultsPath + count + ".csv");
                        }
                    }
                }
                ResultsHolder best = (ResultsHolder)ties.get(this.rng.nextInt(ties.size()));
                double bestC = best.x;
                double bestExponent = best.y;
                double bestB = best.z;
                this.paras[0] = bestC;
                this.paras[1] = bestExponent;
                this.paras[2] = bestB;
                PolynomialKernel kern = new PolynomialKernel();
                kern.setExponent(bestExponent);
                kern.setB(bestB);
                this.setKernel(kern);
                this.setC(bestC);
                this.res = best.res;
                if (this.debug) {
                    System.out.println("Best C =" + bestC + " best Gamma = " + bestExponent + " best train acc = " + this.res.acc);
                }
            } else {
                System.out.println(this.resultsPath + " error: missing  =" + missing + " parameter values");
            }
        } else {
            ResultsHolder best = (ResultsHolder)ties.get(this.rng.nextInt(ties.size()));
            double bestC = best.x;
            double bestExponent = best.y;
            double bestB = best.z;
            this.paras[0] = bestC;
            this.paras[1] = bestExponent;
            this.paras[2] = bestB;
            PolynomialKernel kern = new PolynomialKernel();
            kern.setExponent(bestExponent);
            kern.setB(bestB);
            this.setKernel(kern);
            this.setC(bestC);
            this.res = best.res;
        }
    }

    public void tuneCForFixedPolynomial(Instances train) throws Exception {
        ClassifierResults tempResults;
        this.paras = new double[1];
        int folds = MAX_FOLDS;
        if (folds > train.numInstances()) {
            folds = train.numInstances();
        }
        double minErr = 1.0;
        this.setSeed(this.rng.nextInt());
        Instances trainCopy = new Instances(train);
        CrossValidator cv = new CrossValidator();
        if (this.setSeed) {
            cv.setSeed(this.seed);
        }
        cv.setNumFolds(folds);
        cv.buildFolds(trainCopy);
        ArrayList<ResultsHolder> ties = new ArrayList<ResultsHolder>();
        int count = 0;
        OutFile temp = null;
        for (double d : this.paraSpace1) {
            ++count;
            if (this.saveEachParaAcc) {
                File f = new File(this.resultsPath + count + ".csv");
                if (f.exists() && f.length() > 0L) continue;
                if (this.debug) {
                    System.out.println("PARA COUNT =" + count);
                }
            }
            SMO model = new SMO();
            model.setKernel(this.m_kernel);
            model.setC(d);
            model.setBuildLogisticModels(true);
            tempResults = cv.crossValidateWithStats(model, trainCopy);
            double e = 1.0 - tempResults.acc;
            this.accuracy.add(tempResults.acc);
            if (this.saveEachParaAcc) {
                temp = new OutFile(this.resultsPath + count + ".csv");
                temp.writeLine(tempResults.writeResultsFileToString());
                temp.closeFile();
            }
            if (e < minErr) {
                minErr = e;
                ties = new ArrayList();
                ties.add(new ResultsHolder(d, 0.0, tempResults));
                continue;
            }
            if (e != minErr) continue;
            ties.add(new ResultsHolder(d, 0.0, tempResults));
        }
        if (this.saveEachParaAcc) {
            int missing = 0;
            for (double p1 : this.paraSpace1) {
                File f = new File(this.resultsPath + count + ".csv");
                if (f.exists() && f.length() > 0L) continue;
                ++missing;
            }
            if (missing == 0) {
                this.combinedBuildTime = 0L;
                count = 0;
                for (double p1 : this.paraSpace1) {
                    tempResults = new ClassifierResults();
                    tempResults.loadFromFile(this.resultsPath + ++count + ".csv");
                    this.combinedBuildTime += tempResults.buildTime;
                    double e = 1.0 - tempResults.acc;
                    if (e < minErr) {
                        minErr = e;
                        ties = new ArrayList();
                        ties.add(new ResultsHolder(p1, 0.0, tempResults));
                    } else if (e == minErr) {
                        ties.add(new ResultsHolder(p1, 0.0, tempResults));
                    }
                    File f = new File(this.resultsPath + count + ".csv");
                    if (f.delete()) continue;
                    System.out.println("DELETE FAILED " + this.resultsPath + count + ".csv");
                }
                ResultsHolder best = (ResultsHolder)ties.get(this.rng.nextInt(ties.size()));
                this.setC(best.x);
                this.res = best.res;
                this.paras[0] = best.x;
            } else {
                System.out.println(this.resultsPath + " error: missing  =" + missing + " parameter values");
            }
        } else {
            ResultsHolder best = (ResultsHolder)ties.get(this.rng.nextInt(ties.size()));
            this.setC(best.x);
            this.res = best.res;
            this.paras[0] = best.x;
        }
    }

    public void selectKernel(Instances train) throws Exception {
        PolyKernel p;
        KernelType[] ker = KernelType.values();
        double[] rbfParas = new double[2];
        double rbfCVAcc = 0.0;
        double linearBestC = 0.0;
        double linearCVAcc = 0.0;
        double quadraticBestC = 0.0;
        double quadraticCVAcc = 0.0;
        block5: for (KernelType k : ker) {
            TunedSVM temp = new TunedSVM();
            switch (k) {
                case LINEAR: {
                    PolyKernel p2 = new PolyKernel();
                    p2.setExponent(1.0);
                    temp.setKernel(p2);
                    temp.setStandardParaSearchSpace();
                    temp.tuneCForFixedPolynomial(train);
                    linearCVAcc = temp.res.acc;
                    linearBestC = temp.getC();
                    continue block5;
                }
                case QUADRATIC: {
                    PolyKernel p2 = new PolyKernel();
                    p2.setExponent(2.0);
                    temp.setKernel(p2);
                    temp.setStandardParaSearchSpace();
                    temp.tuneCForFixedPolynomial(train);
                    quadraticCVAcc = temp.res.acc;
                    quadraticBestC = temp.getC();
                    continue block5;
                }
                case RBF: {
                    RBFKernel kernel2 = new RBFKernel();
                    temp.setKernel(kernel2);
                    temp.setStandardParaSearchSpace();
                    temp.tuneRBF(train);
                    rbfCVAcc = temp.res.acc;
                    rbfParas[0] = temp.getC();
                    rbfParas[1] = ((RBFKernel)temp.m_kernel).getGamma();
                }
            }
        }
        if (linearCVAcc > rbfCVAcc && linearCVAcc > quadraticCVAcc) {
            p = new PolyKernel();
            p.setExponent(1.0);
            this.setKernel(p);
            this.setC(linearBestC);
            this.paras = new double[1];
            this.paras[0] = linearBestC;
            this.res.acc = linearCVAcc;
        } else if (quadraticCVAcc > linearCVAcc && quadraticCVAcc > rbfCVAcc) {
            p = new PolyKernel();
            p.setExponent(2.0);
            this.setKernel(p);
            this.setC(quadraticBestC);
            this.paras = new double[1];
            this.paras[0] = quadraticBestC;
            this.res.acc = quadraticCVAcc;
        } else {
            RBFKernel kernel = new RBFKernel();
            kernel.setGamma(rbfParas[1]);
            this.setKernel(kernel);
            this.setC(rbfParas[0]);
            this.paras = rbfParas;
            this.res.acc = rbfCVAcc;
        }
    }

    public void buildFromFile() throws FileNotFoundException {
        this.combinedBuildTime = 0L;
        int count = 0;
        ArrayList<ResultsHolder> ties = new ArrayList<ResultsHolder>();
        double minErr = 1.0;
        if (this.kernel == KernelType.LINEAR || this.kernel == KernelType.QUADRATIC) {
            for (double p1 : this.paraSpace1) {
                ClassifierResults tempResults = new ClassifierResults();
                File f = new File(this.resultsPath + ++count + ".csv");
                if (!f.exists() || f.length() <= 0L) continue;
                tempResults.loadFromFile(this.resultsPath + count + ".csv");
                this.combinedBuildTime += tempResults.buildTime;
                double e = 1.0 - tempResults.acc;
                if (e < minErr) {
                    minErr = e;
                    ties = new ArrayList();
                    ties.add(new ResultsHolder(p1, 0.0, tempResults));
                    continue;
                }
                if (e != minErr) continue;
                ties.add(new ResultsHolder(p1, 0.0, tempResults));
            }
        } else if (this.kernel == KernelType.RBF) {
            for (double p1 : this.paraSpace1) {
                for (double p2 : this.paraSpace2) {
                    ClassifierResults tempResults = new ClassifierResults();
                    File f = new File(this.resultsPath + ++count + ".csv");
                    if (!f.exists() || f.length() <= 0L) continue;
                    tempResults.loadFromFile(this.resultsPath + count + ".csv");
                    this.combinedBuildTime += tempResults.buildTime;
                    double e = 1.0 - tempResults.acc;
                    if (e < minErr) {
                        minErr = e;
                        ties = new ArrayList();
                        ties.add(new ResultsHolder(p1, p2, tempResults));
                        continue;
                    }
                    if (e != minErr) continue;
                    ties.add(new ResultsHolder(p1, p2, tempResults));
                }
            }
        } else if (this.kernel == KernelType.POLYNOMIAL) {
            for (double p1 : this.paraSpace1) {
                for (double p2 : this.paraSpace2) {
                    for (double p3 : this.paraSpace3) {
                        ClassifierResults tempResults = new ClassifierResults();
                        File f = new File(this.resultsPath + ++count + ".csv");
                        if (!f.exists() || f.length() <= 0L) continue;
                        tempResults.loadFromFile(this.resultsPath + count + ".csv");
                        this.combinedBuildTime += tempResults.buildTime;
                        double e = 1.0 - tempResults.acc;
                        if (e < minErr) {
                            minErr = e;
                            ties = new ArrayList();
                            ties.add(new ResultsHolder(p1, p2, p3, tempResults));
                            continue;
                        }
                        if (e != minErr) continue;
                        ties.add(new ResultsHolder(p1, p2, p3, tempResults));
                    }
                }
            }
        }
        ResultsHolder best = (ResultsHolder)ties.get(this.rng.nextInt(ties.size()));
        this.setC(best.x);
        this.res = best.res;
        this.paras[0] = best.x;
        if (this.kernel == KernelType.RBF) {
            this.paras[1] = best.y;
        } else if (this.kernel == KernelType.POLYNOMIAL) {
            this.paras[1] = best.y;
            this.paras[2] = best.z;
        }
    }

    @Override
    public void buildClassifier(Instances train) throws Exception {
        this.res = new ClassifierResults();
        long t = System.currentTimeMillis();
        if (this.tuneParameters) {
            if (this.paraSpace1 == null) {
                this.setStandardParaSearchSpace();
            }
            if (this.buildFromFile) {
                throw new Exception("Build from file in TunedSVM Not implemented yet");
            }
            if (this.kernel == KernelType.RBF) {
                this.tuneRBF(train);
            } else if (this.kernel == KernelType.LINEAR || this.kernel == KernelType.QUADRATIC) {
                this.tuneCForFixedPolynomial(train);
            } else if (this.kernel == KernelType.POLYNOMIAL) {
                this.tunePolynomial(train);
            }
        } else if (this.findTrainAcc) {
            int folds = 10;
            if (folds > train.numInstances()) {
                folds = train.numInstances();
            }
            SMO model = new SMO();
            model.setKernel(this.m_kernel);
            model.setC(this.getC());
            model.setBuildLogisticModels(true);
            model.setRandomSeed(this.seed);
            CrossValidator cv = new CrossValidator();
            cv.setSeed(this.seed);
            cv.setNumFolds(folds);
            cv.buildFolds(train);
            this.res = cv.crossValidateWithStats(model, train);
        }
        super.buildClassifier(train);
        this.res.buildTime = this.saveEachParaAcc ? this.combinedBuildTime : System.currentTimeMillis() - t;
        if (this.trainPath != null && this.trainPath != "") {
            OutFile f = new OutFile(this.trainPath);
            f.writeLine(train.relationName() + ",TunedSVM" + (Object)((Object)this.kernel) + ",Train");
            f.writeLine(this.getParameters());
            f.writeLine(this.res.acc + "");
            f.writeLine(this.res.writeInstancePredictions());
            f.closeFile();
            File x = new File(this.trainPath);
            x.setWritable(true, false);
        }
    }

    public static void jamesltest() {
        try {
            String dset = "zoo";
            Instances all = ClassifierTools.loadData("C:/UCI Problems/" + dset + "/" + dset);
            for (int fold = 0; fold < 30; ++fold) {
                Instances[] split = InstanceTools.resampleInstances(all, fold, 0.5);
                Instances train = split[0];
                Instances test = split[1];
                TunedSVM svml = new TunedSVM();
                svml.optimiseParas(true);
                svml.optimiseKernel(false);
                svml.setBuildLogisticModels(true);
                svml.setSeed(fold);
                svml.setKernelType(KernelType.LINEAR);
                System.out.println("\n\nTSVM_L:");
                svml.buildClassifier(train);
                System.out.println("C =" + svml.getC());
                System.out.println("Train: " + svml.res.acc + " " + svml.res.stddev);
                double accL = ClassifierTools.accuracy(test, svml);
                System.out.println("Test: " + accL);
            }
        }
        catch (Exception e) {
            System.out.println("ffsjava");
            System.out.println(e);
            e.printStackTrace();
        }
    }

    public static void testKernel() throws Exception {
        TunedSVM svm = new TunedSVM();
        svm.setKernelType(KernelType.POLYNOMIAL);
        svm.setParamSearch(false);
        svm.setBuildLogisticModels(true);
        String dset = "balloons";
        svm.setSeed(0);
        Instances all = ClassifierTools.loadData("C:\\Users\\ajb\\Dropbox\\UCI Problems\\" + dset + "\\" + dset);
        Instances[] split = InstanceTools.resampleInstances(all, 1L, 0.5);
        svm.buildClassifier(split[0]);
    }

    public static void main(String[] args) {
        try {
            TunedSVM.testKernel();
        }
        catch (Exception ex) {
            Logger.getLogger(TunedSVM.class.getName()).log(Level.SEVERE, null, ex);
        }
        System.exit(0);
        int min = -16;
        int max = 16;
        int numParas = max - min;
        if (max * min < 0) {
            ++numParas;
        }
        for (int x = 1; x <= 1089; ++x) {
            int temp = min + (x - 1) / numParas;
            double c = Math.pow(2.0, temp);
            int temp2 = min + (x - 1) % numParas;
            double gamma = Math.pow(2.0, temp2);
            System.out.println("c count =" + temp + " gamma count = " + temp2 + " c=" + c + "  gamma =" + gamma);
        }
        System.exit(0);
        String sourcePath = "C:\\Users\\ajb\\Dropbox\\TSC Problems\\";
        String problemFile = "ItalyPowerDemand";
        DecimalFormat df = new DecimalFormat("###.###");
        Instances all = ClassifierTools.loadData(sourcePath + problemFile + "/" + problemFile + "_TRAIN");
        Instances[] split = InstanceTools.resampleInstances(all, 0L, 0.5);
        Instances train = split[0];
        Instances test = split[1];
        try {
            TunedSVM svml = new TunedSVM();
            svml.setPathToSaveParameters("C:\\Temp\\fold1_");
            svml.optimiseParas(true);
            svml.optimiseKernel(false);
            svml.setBuildLogisticModels(true);
            svml.setSeed(0);
            svml.setKernelType(KernelType.RBF);
            svml.debug = true;
            svml.buildClassifier(train);
            System.out.println("BUILT LINEAR = " + svml);
            System.out.println(" Optimal C =" + svml.getC());
            double accL = ClassifierTools.accuracy(test, svml);
            System.out.println("ACC on " + problemFile + ": Linear = " + df.format(accL));
        }
        catch (Exception e) {
            System.out.println(" Exception building a classifier = " + e);
            e.printStackTrace();
            System.exit(0);
        }
    }

    protected static class PolynomialKernel
    extends PolyKernel {
        double b = 0.0;

        protected PolynomialKernel() {
        }

        public void setB(double x) {
            this.b = x;
        }

        protected void setConstantTerm(double x) {
            this.b = x;
        }

        @Override
        protected double evaluate(int id1, int id2, Instance inst1) throws Exception {
            double result = id1 == id2 ? this.dotProd(inst1, inst1) : this.dotProd(inst1, this.m_data.instance(id2));
            result += this.b;
            if (this.m_exponent != 1.0) {
                result = Math.pow(result, this.m_exponent);
            }
            return result;
        }
    }

    static class ResultsHolder {
        double x;
        double y;
        double z;
        ClassifierResults res;

        ResultsHolder(double a, double b, ClassifierResults r) {
            this.x = a;
            this.y = b;
            this.z = 0.0;
            this.res = r;
        }

        ResultsHolder(double a, double b, double c, ClassifierResults r) {
            this.x = a;
            this.y = b;
            this.z = c;
            this.res = r;
        }
    }

    public static enum KernelType {
        LINEAR,
        QUADRATIC,
        POLYNOMIAL,
        RBF;

    }
}

