/*
 * Decompiled with CFR 0.152.
 */
package vector_classifiers;

import utilities.GenericTools;
import weka.classifiers.functions.PLSClassifier;
import weka.core.Attribute;
import weka.core.DenseInstance;
import weka.core.FastVector;
import weka.core.Instance;
import weka.core.Instances;

public class PLSNominalClassifier
extends PLSClassifier {
    protected Attribute classAttribute;
    protected int classind;
    protected int numClasses;

    public int getNumComponents() {
        return this.m_Filter.getNumComponents();
    }

    public void setNumComponents(int value) {
        this.m_Filter.setNumComponents(value);
    }

    @Override
    public void buildClassifier(Instances data) throws Exception {
        Instances train = new Instances(data);
        this.numClasses = train.numClasses();
        this.classind = train.classIndex();
        this.classAttribute = train.classAttribute();
        FastVector<Attribute> atts = new FastVector<Attribute>(train.numAttributes());
        for (int i = 0; i < train.numAttributes(); ++i) {
            if (i != this.classind) {
                atts.add(train.attribute(i));
                continue;
            }
            Attribute numericClassAtt = new Attribute(train.attribute(i).name());
            atts.add(numericClassAtt);
        }
        Instances temp = new Instances(train.relationName(), atts, train.numInstances());
        temp.setClassIndex(this.classind);
        for (int i = 0; i < train.numInstances(); ++i) {
            temp.add(new DenseInstance(1.0, train.instance(i).toDoubleArray()));
            temp.instance(i).setClassValue(train.instance(i).classValue());
        }
        train = temp;
        super.buildClassifier(train);
    }

    protected double convertNominalToNumeric(String strClassVal) {
        return Double.parseDouble(strClassVal.replaceAll("[A-Za-z ]", ""));
    }

    public double regressInstance(Instance instance) throws Exception {
        return super.classifyInstance(instance);
    }

    @Override
    public double classifyInstance(Instance instance) throws Exception {
        return GenericTools.indexOfMax(this.distributionForInstance(instance));
    }

    @Override
    public double[] distributionForInstance(Instance instance) throws Exception {
        double regpred = this.regressInstance(instance);
        double[] dist = new double[this.numClasses];
        if (regpred <= 0.0) {
            dist[0] = 1.0;
        } else if (regpred >= (double)(this.numClasses - 1)) {
            dist[this.numClasses - 1] = 1.0;
        } else {
            for (int i = 1; i < this.numClasses; ++i) {
                double t;
                if (!(regpred < (double)i)) continue;
                dist[i] = t = regpred % 1.0;
                dist[i - 1] = 1.0 - t;
                break;
            }
        }
        return dist;
    }
}

