/*
 * Decompiled with CFR 0.152.
 */
package utilities;

import java.math.BigDecimal;
import java.math.MathContext;
import java.util.Arrays;
import java.util.Random;

public class StatisticalUtilities {
    private static final BigDecimal TWO = BigDecimal.valueOf(2L);

    public static double mean(double[] values, boolean classVal) {
        double sum = 0.0;
        int offset = classVal ? 1 : 0;
        for (int i = 0; i < values.length - offset; ++i) {
            sum += values[i];
        }
        return sum / (double)values.length - (double)offset;
    }

    public static double median(double[] values) {
        double[] copy = Arrays.copyOf(values, values.length);
        Arrays.sort(copy);
        if (copy.length % 2 == 1) {
            return copy[copy.length / 2 + 1];
        }
        return (copy[copy.length / 2] + copy[copy.length / 2 + 1]) / 2.0;
    }

    public static double standardDeviation(double[] values, boolean classVal, double mean) {
        double sumSquaresDiffs = 0.0;
        int offset = classVal ? 1 : 0;
        for (int i = 0; i < values.length - offset; ++i) {
            double diff = values[i] - mean;
            sumSquaresDiffs += diff * diff;
        }
        return Math.sqrt(sumSquaresDiffs / (double)(values.length - 1 - offset));
    }

    public static double[] normalize(double[] vector, boolean classVal) {
        double mean = StatisticalUtilities.mean(vector, classVal);
        double std = StatisticalUtilities.standardDeviation(vector, classVal, mean);
        double[] normalizedVector = new double[vector.length];
        for (int i = 0; i < vector.length; ++i) {
            if (std == 0.0) continue;
            normalizedVector[i] = (vector[i] - mean) / std;
        }
        return normalizedVector;
    }

    public static double[] normalize(double[] vector) {
        return StatisticalUtilities.normalize(vector, false);
    }

    public static void normalize2D(double[][] data, boolean classVal) {
        int offset = classVal ? 1 : 0;
        for (double[] series : data) {
            double mean = StatisticalUtilities.mean(series, classVal);
            double std = StatisticalUtilities.standardDeviation(series, classVal, mean);
            for (int j = 0; j < series.length - offset; ++j) {
                if (std == 0.0) continue;
                series[j] = (series[j] - mean) / std;
            }
        }
    }

    public static double exp(double val) {
        long tmp = (long)(1512775.0 * val + 1.072632447E9);
        return Double.longBitsToDouble(tmp << 32);
    }

    public static double sumOfSquares(double[] v1, double[] v2) {
        double ss = 0.0;
        int N = v1.length;
        double err = 0.0;
        for (int i = 0; i < N; ++i) {
            err = v1[i] - v2[i];
            ss += err * err;
        }
        return ss;
    }

    public static double calculateSigmoid(double x) {
        return 1.0 / (1.0 + Math.exp(-x));
    }

    public static BigDecimal sqrt(BigDecimal x, MathContext mc) {
        BigDecimal g = x.divide(TWO, mc);
        boolean done = false;
        int maxIterations = mc.getPrecision() + 1;
        for (int i = 0; !done && i < maxIterations; ++i) {
            BigDecimal r = x.divide(g, mc);
            r = r.add(g);
            r = r.divide(TWO, mc);
            done = r.equals(g);
            g = r;
        }
        return g;
    }

    public static int[] findCumulativeCounts(int[] counts) {
        int[] c = new int[counts.length];
        c[0] = counts[0];
        for (int i = 1; i < counts.length; ++i) {
            c[i] = c[i - 1] + counts[i];
        }
        return c;
    }

    public static int sampleCounts(int[] cumulativeCounts, Random rand) {
        int c = rand.nextInt(cumulativeCounts[cumulativeCounts.length - 1]);
        int pos = 0;
        while (cumulativeCounts[pos] < c) {
            ++pos;
        }
        return pos;
    }
}

