/*
 * Decompiled with CFR 0.152.
 */
package transformations;

import fileIO.OutFile;
import statistics.tests.ResidualTests;
import transformations.BoxCox;
import transformations.LinearModel;
import weka.core.Instance;
import weka.core.Instances;

public class YeoJohnson
extends BoxCox {
    public YeoJohnson(double r) {
        this.bestLambda = r;
    }

    @Override
    public Instances invert(Instances data) {
        int responsePos = data.numAttributes() - 1;
        double[] response = data.attributeToDoubleArray(responsePos);
        double[] newVals = YeoJohnson.invert(this.bestLambda, response);
        for (int i = 0; i < data.numInstances(); ++i) {
            Instance inst = data.instance(i);
            inst.setValue(responsePos, newVals[i]);
        }
        return data;
    }

    @Override
    public double[] invertPredictedResponse(double[] d) {
        return YeoJohnson.invert(this.bestLambda, d);
    }

    public static Instances invertResponse(Instances data, double lambda) {
        int responsePos = data.classIndex();
        double[] response = data.attributeToDoubleArray(responsePos);
        for (int i = 0; i < response.length; ++i) {
            Instance inst = data.instance(i);
            double v = response[i] < 0.0 ? (lambda != 2.0 ? -(Math.pow(1.0 - response[i], 2.0 - lambda) - 1.0) / (2.0 - lambda) : -Math.log(1.0 - response[i])) : (lambda == 0.0 ? Math.log(1.0 + response[i]) : (Math.pow(response[i] + 1.0, lambda) - 1.0) / lambda);
            inst.setValue(responsePos, v);
        }
        return data;
    }

    public static Instances transformResponse(Instances data, double lambda) {
        YeoJohnson.transformResponse(data, lambda, data.attributeToDoubleArray(data.classIndex()));
        return data;
    }

    public static double[] invert(double lambda, double[] response) {
        double[] data = new double[response.length];
        for (int i = 0; i < response.length; ++i) {
            data[i] = response[i] < 0.0 ? (lambda != 2.0 ? 1.0 - Math.pow(1.0 - (2.0 - lambda) * response[i], 1.0 / (2.0 - lambda)) : 1.0 - Math.exp(-response[i])) : (lambda == 0.0 ? Math.exp(response[i]) - 1.0 : (lambda * response[i] + 1.0 > 1.0E-6 ? Math.pow(lambda * response[i] + 1.0, 1.0 / lambda) - 1.0 : (i == 0 ? Math.pow(1.0E-6, 1.0 / lambda) - 1.0 : 1.05 * data[i - 1])));
            if (data[i] != Double.NaN) continue;
            System.out.println("NAN in invert: Response = " + response[i] + " lambda = " + lambda);
            System.exit(0);
        }
        return data;
    }

    public static double[] transform(double lambda, double[] response) {
        double[] data = new double[response.length];
        for (int i = 0; i < response.length; ++i) {
            data[i] = response[i] < 0.0 ? (lambda != 2.0 ? -(Math.pow(1.0 - response[i], 2.0 - lambda) - 1.0) / (2.0 - lambda) : -Math.log(1.0 - response[i])) : (lambda == 0.0 ? Math.log(1.0 + response[i]) : (Math.pow(response[i] + 1.0, lambda) - 1.0) / lambda);
            if (data[i] != Double.NaN) continue;
            System.out.println("NAN in transform: Response = " + response[i] + " lambda = " + lambda);
            System.exit(0);
        }
        return data;
    }

    public static Instances transformInstances(Instances data, double lambda) {
        YeoJohnson.transformResponse(data, lambda, data.attributeToDoubleArray(data.classIndex()));
        return data;
    }

    public static void transformResponse(Instances data, double lambda, double[] response) {
        int responsePos = data.classIndex();
        double[] newData = YeoJohnson.transform(lambda, response);
        for (int i = 0; i < response.length; ++i) {
            Instance inst = data.instance(i);
            inst.setValue(responsePos, newData[i]);
        }
    }

    public static double findBestTransform(double[][] data, double[] res) {
        double bestLambda = MIN;
        double minError = Double.MAX_VALUE;
        for (double lambda = MIN; lambda <= MAX; lambda += INTERVAL) {
            double[] response = YeoJohnson.transform(lambda, res);
            LinearModel lm = new LinearModel(data, response);
            lm.fitModel();
            double e = lm.findStats();
            double error = lm.findInverseStats(lambda, res);
            if (!(error < minError)) continue;
            bestLambda = lambda;
            minError = error;
        }
        return bestLambda;
    }

    public static double findBestTransform(Instances data, int pos, double[] power) {
        int responsePos = data.classIndex();
        double[] temp = data.attributeToDoubleArray(responsePos);
        double[] response = new double[temp.length];
        System.arraycopy(temp, 0, response, 0, temp.length);
        double[] predictions = new double[response.length];
        double bestLambda = MIN;
        double minError = Double.MAX_VALUE;
        for (double lambda = MIN; lambda <= MAX; lambda += INTERVAL) {
            YeoJohnson.transformResponse(data, lambda, response);
            LinearModel lm = new LinearModel(data);
            lm.fitModel();
            lm.formTrainPredictions();
            lm.findTrainStatistics();
            double error = ResidualTests.kolmogorovSmirnoff(lm.stdResidual);
            double correlation = ResidualTests.testHeteroscadisity(lm.y, lm.predicted);
            if (!(error < minError)) continue;
            bestLambda = lambda;
            minError = error;
        }
        power[pos] = bestLambda;
        return minError;
    }

    @Override
    public Instances transform(Instances data) {
        System.out.println(" Doesnt do anything! ");
        int responsePos = data.numAttributes() - 1;
        double[] response = data.attributeToDoubleArray(responsePos);
        double[] preds = new double[response.length];
        return data;
    }

    public static void main(String[] args) {
        int size = 100;
        double[] d = new double[size];
        for (int i = 0; i < size; ++i) {
            d[i] = -5.0 + 0.1 * (double)i;
        }
        OutFile f = new OutFile("TestYeoJohnson.csv");
        f.writeLine("Data,Lambda-3,Lambda-1,Lambda-0.5,Lambda0,Lambda0.5,Lambda1,Lambda2,Lambda3, InvLambda-3,InvLambda-1,InvLambda-0.5,InvLambda0,InvLambda0.5,InvLambda1,InvLambda2,InvLambda3");
        double[][] d2 = new double[8][];
        double[][] inv = new double[8][];
        d2[0] = YeoJohnson.transform(-3.0, d);
        d2[1] = YeoJohnson.transform(-1.0, d);
        d2[2] = YeoJohnson.transform(-0.5, d);
        d2[3] = YeoJohnson.transform(0.0, d);
        d2[4] = YeoJohnson.transform(0.5, d);
        d2[5] = YeoJohnson.transform(1.0, d);
        d2[6] = YeoJohnson.transform(2.0, d);
        d2[7] = YeoJohnson.transform(3.0, d);
        inv[0] = YeoJohnson.invert(-3.0, d2[0]);
        inv[1] = YeoJohnson.invert(-1.0, d2[1]);
        inv[2] = YeoJohnson.invert(-0.5, d2[2]);
        inv[3] = YeoJohnson.invert(0.0, d2[3]);
        inv[4] = YeoJohnson.invert(0.5, d2[4]);
        inv[5] = YeoJohnson.invert(1.0, d2[5]);
        inv[6] = YeoJohnson.invert(2.0, d2[6]);
        inv[7] = YeoJohnson.invert(3.0, d2[7]);
        for (int i = 0; i < size; ++i) {
            int j;
            f.writeString(d[i] + ",");
            for (j = 0; j < 8; ++j) {
                f.writeString(d2[j][i] + ",");
            }
            for (j = 0; j < 8; ++j) {
                f.writeString(inv[j][i] + ",");
            }
            f.writeString("\n");
        }
    }
}

