/*
 * Decompiled with CFR 0.152.
 */
package transformations;

import fileIO.InFile;
import fileIO.OutFile;
import statistics.tests.ResidualTests;
import transformations.LinearModel;
import transformations.PowerSearch;
import transformations.YeoJohnson;

public class VarianceStabalisingStepwiseRegression {
    static int m;
    static int n;
    static double[][] X;
    static double[][] transformedX;
    static double[][] workingX;
    static double[] Y;
    static double[] transformedY;
    static double[] powers;
    static boolean[] included;
    static boolean[] transformIncluded;
    static int[] positions;
    static int size;
    static int[] transformedPositions;
    static int transSize;
    static final double CRITICAL = 7.0;
    static int count;

    public static void main(String[] args) {
        OutFile f = new OutFile("C:/Research/Data/Gavin Competition/Results/StepwiseTransformationPowerResults.csv");
        f.writeLine("Synthetic,MSE,AP,KS,RT,RQ");
        int choice = 2;
        VarianceStabalisingStepwiseRegression.Synthetic();
        if (choice == 0) {
            VarianceStabalisingStepwiseRegression.fullModel(f);
        } else if (choice == 1) {
            VarianceStabalisingStepwiseRegression.stepwiseLinear(f);
        } else {
            VarianceStabalisingStepwiseRegression.forwardSelectTransform(f);
        }
        System.out.println(" Starting Temp Reduced ...");
        f.writeLine("Temp Reduced");
        VarianceStabalisingStepwiseRegression.TemperatureReduced();
        if (choice == 0) {
            VarianceStabalisingStepwiseRegression.fullModel(f);
        } else if (choice == 1) {
            VarianceStabalisingStepwiseRegression.stepwiseLinear(f);
        } else {
            VarianceStabalisingStepwiseRegression.forwardSelectTransform(f);
        }
        System.out.println(" Starting SO2 ...");
        f.writeLine("SO2");
        VarianceStabalisingStepwiseRegression.SO2();
        if (choice == 0) {
            VarianceStabalisingStepwiseRegression.fullModel(f);
        } else if (choice == 1) {
            VarianceStabalisingStepwiseRegression.stepwiseLinear(f);
        } else {
            VarianceStabalisingStepwiseRegression.forwardSelectTransform(f);
        }
        System.out.println(" Starting SO2 Reduced...");
        f.writeLine("SO2 Reduced");
        VarianceStabalisingStepwiseRegression.SO2Reduced();
        if (choice == 0) {
            VarianceStabalisingStepwiseRegression.fullModel(f);
        } else if (choice == 1) {
            VarianceStabalisingStepwiseRegression.stepwiseLinear(f);
        } else {
            VarianceStabalisingStepwiseRegression.forwardSelectTransform(f);
        }
        f.writeLine("Precip Reduced");
        VarianceStabalisingStepwiseRegression.PrecipReduced();
        if (choice == 0) {
            VarianceStabalisingStepwiseRegression.fullModel(f);
        } else if (choice == 1) {
            VarianceStabalisingStepwiseRegression.stepwiseLinear(f);
        } else {
            VarianceStabalisingStepwiseRegression.forwardSelectTransform(f);
        }
    }

    public static void Synthetic() {
        int i;
        m = 1;
        n = 256;
        int n2 = 128;
        int synthScale = 5;
        String path = "C:/Research/Data/Gavin Competition/Synthetic/";
        String p1 = "Synthetic Train.csv";
        String p2 = "Synthetic Validate.csv";
        boolean finished = false;
        boolean attCount = false;
        double minVar = Double.MAX_VALUE;
        X = new double[m + 1][n];
        Y = new double[n];
        transformedY = new double[n];
        InFile f = new InFile(path + p1);
        for (i = 0; i < n; ++i) {
            VarianceStabalisingStepwiseRegression.X[0][i] = 1.0;
        }
        for (i = 0; i < n; ++i) {
            for (int j = 1; j <= m; ++j) {
                VarianceStabalisingStepwiseRegression.X[j][i] = f.readDouble() + (double)synthScale;
            }
            VarianceStabalisingStepwiseRegression.Y[i] = f.readDouble();
        }
    }

    public static void TemperatureReduced() {
        int i;
        m = 20;
        n = 7117;
        double tempScale = 10.0;
        String path = "C:/Research/Data/Gavin Competition/Temperature/TempTransformed Train.csv";
        int[] collinear = new int[]{1, 3, 4, 5, 6, 7, 20, 34, 35, 36, 47, 48, 72, 82};
        boolean finished = false;
        boolean attCount = false;
        double minVar = Double.MAX_VALUE;
        X = new double[m + 1][n];
        Y = new double[n];
        transformedY = new double[n];
        InFile f = new InFile(path);
        for (i = 0; i < n; ++i) {
            VarianceStabalisingStepwiseRegression.X[0][i] = 1.0;
        }
        for (i = 0; i < n; ++i) {
            for (int j = 1; j <= m; ++j) {
                VarianceStabalisingStepwiseRegression.X[j][i] = f.readDouble() + tempScale;
            }
            VarianceStabalisingStepwiseRegression.Y[i] = f.readDouble();
        }
        boolean c1 = false;
        boolean c2 = false;
    }

    public static void Temperature() {
        int i;
        m = 106;
        n = 7117;
        double tempScale = 10.0;
        String path = "C:/Research/Data/Gavin Competition/Temperature/TempTraining.csv";
        int[] collinear = new int[]{1, 3, 4, 5, 6, 7, 20, 34, 35, 36, 47, 48, 72, 82};
        boolean finished = false;
        boolean attCount = false;
        double minVar = Double.MAX_VALUE;
        X = new double[m + 1][n];
        Y = new double[n];
        transformedY = new double[n];
        InFile f = new InFile(path);
        for (i = 0; i < n; ++i) {
            VarianceStabalisingStepwiseRegression.X[0][i] = 1.0;
        }
        for (i = 0; i < n; ++i) {
            for (int j = 1; j <= m; ++j) {
                VarianceStabalisingStepwiseRegression.X[j][i] = f.readDouble() + tempScale;
            }
            VarianceStabalisingStepwiseRegression.Y[i] = f.readDouble();
        }
        int c1 = 0;
        int c2 = 0;
        double[][] reducedX = new double[m + 1 - collinear.length][];
        for (int i2 = 0; i2 <= m; ++i2) {
            if (c1 >= collinear.length || i2 != collinear[c1]) {
                reducedX[c2] = X[i2];
                ++c2;
                continue;
            }
            ++c1;
        }
        X = reducedX;
        m = reducedX.length - 1;
    }

    public static void SO2() {
        int i;
        m = 26;
        n = 15304;
        int so2Scale = 10;
        String path = "C:/Research/Data/Gavin Competition/SO2/";
        String p1 = "SO2Train.csv";
        boolean finished = false;
        boolean attCount = false;
        double minVar = Double.MAX_VALUE;
        X = new double[m + 1][n];
        Y = new double[n];
        transformedY = new double[n];
        InFile f = new InFile(path + p1);
        for (i = 0; i < n; ++i) {
            VarianceStabalisingStepwiseRegression.X[0][i] = 1.0;
        }
        for (i = 0; i < n; ++i) {
            for (int j = 1; j <= m; ++j) {
                VarianceStabalisingStepwiseRegression.X[j][i] = f.readDouble() + (double)so2Scale;
            }
            VarianceStabalisingStepwiseRegression.Y[i] = f.readDouble();
        }
    }

    public static void SO2Reduced() {
        int i;
        m = 19;
        n = 15304;
        int so2Scale = 10;
        String path = "C:/Research/Data/Gavin Competition/SO2/";
        String p1 = "SO2TrainReduced.csv";
        boolean finished = false;
        boolean attCount = false;
        double minVar = Double.MAX_VALUE;
        X = new double[m + 1][n];
        Y = new double[n];
        transformedY = new double[n];
        InFile f = new InFile(path + p1);
        for (i = 0; i < n; ++i) {
            VarianceStabalisingStepwiseRegression.X[0][i] = 1.0;
        }
        for (i = 0; i < n; ++i) {
            for (int j = 1; j <= m; ++j) {
                VarianceStabalisingStepwiseRegression.X[j][i] = f.readDouble() + (double)so2Scale;
            }
            VarianceStabalisingStepwiseRegression.Y[i] = f.readDouble();
        }
    }

    public static void Precip() {
        int i;
        m = 106;
        n = 7031;
        int precipScale = 6;
        String path = "C:/Research/Data/Gavin Competition/Precipitation/";
        String p1 = "PrecipitationTrain.csv";
        boolean finished = false;
        boolean attCount = false;
        double minVar = Double.MAX_VALUE;
        X = new double[m + 1][n];
        Y = new double[n];
        transformedY = new double[n];
        InFile f = new InFile(path + p1);
        for (i = 0; i < n; ++i) {
            VarianceStabalisingStepwiseRegression.X[0][i] = 1.0;
        }
        for (i = 0; i < n; ++i) {
            for (int j = 1; j <= m; ++j) {
                VarianceStabalisingStepwiseRegression.X[j][i] = f.readDouble() + (double)precipScale;
            }
            VarianceStabalisingStepwiseRegression.Y[i] = f.readDouble();
        }
    }

    public static void PrecipReduced() {
        int i;
        m = 20;
        n = 7031;
        int precipScale = 6;
        String path = "C:/Research/Data/Gavin Competition/Precipitation/";
        String p1 = "PrecipTrainReduced.csv";
        boolean finished = false;
        boolean attCount = false;
        double minVar = Double.MAX_VALUE;
        X = new double[m + 1][n];
        Y = new double[n];
        transformedY = new double[n];
        InFile f = new InFile(path + p1);
        for (i = 0; i < n; ++i) {
            VarianceStabalisingStepwiseRegression.X[0][i] = 1.0;
        }
        for (i = 0; i < n; ++i) {
            for (int j = 1; j <= m; ++j) {
                VarianceStabalisingStepwiseRegression.X[j][i] = f.readDouble() + (double)precipScale;
            }
            VarianceStabalisingStepwiseRegression.Y[i] = f.readDouble();
        }
    }

    public static void findStats(OutFile f2, LinearModel lm) {
        double s = lm.findStats();
        double[] resids = lm.getResiduals();
        double[] pred = lm.getPredicted();
        double ap = ResidualTests.anscombeProcedure(pred, resids);
        double ks = ResidualTests.kolmogorovSmirnoff(resids);
        double rt = ResidualTests.runsTest(pred, resids);
        double gq = ResidualTests.goldfeldQuandt(X, Y, 1);
        System.out.println("YJ, s^2 = " + s + ", AP = " + ap + ", KS = " + ks + ", RT = " + rt + ", GQ = " + gq);
        f2.writeLine("FullReg," + s + "," + ap + "," + ks + "," + rt + "," + gq);
    }

    public static void fullModel(OutFile f2) {
        LinearModel lm = new LinearModel(X, Y);
        lm.fitModel();
        VarianceStabalisingStepwiseRegression.findStats(f2, lm);
        double best = YeoJohnson.findBestTransform(X, Y);
        System.out.println(" Best Transform = " + best);
        double[] newY = YeoJohnson.transform(best, Y);
        lm = new LinearModel(X, newY);
        lm.fitModel();
        f2.writeLine("YJ Transform");
        VarianceStabalisingStepwiseRegression.findStats(f2, lm);
    }

    public static void stepwiseLinear(OutFile f2) {
        boolean finished = false;
        included = new boolean[m + 1];
        int attCount = 0;
        VarianceStabalisingStepwiseRegression.included[0] = true;
        for (int i = 1; i <= m; ++i) {
            VarianceStabalisingStepwiseRegression.included[i] = false;
        }
        positions = new int[m + 1];
        while (!finished) {
            int worst;
            attCount = VarianceStabalisingStepwiseRegression.formatRegressors();
            LinearModel lm = new LinearModel(workingX, Y);
            lm.fitModel();
            double var = lm.findStats();
            double oldSSR = lm.getSSR();
            int bestPos = VarianceStabalisingStepwiseRegression.findBestAddition(attCount);
            ++attCount;
            lm = new LinearModel(workingX, Y);
            lm.fitModel();
            double newVar = lm.findStats();
            double newSSR = lm.getSSR();
            System.out.println(" Verification: New Var = " + newVar);
            if ((newSSR - oldSSR) / var > 7.0) {
                System.out.println("ADDING = " + bestPos);
                VarianceStabalisingStepwiseRegression.included[bestPos] = true;
                VarianceStabalisingStepwiseRegression.positions[attCount - 1] = bestPos;
                size = attCount;
            } else {
                System.out.println("NOT ADDING = " + bestPos);
                VarianceStabalisingStepwiseRegression.included[bestPos] = false;
                finished = true;
            }
            if (attCount == m + 1) {
                finished = true;
            }
            if (attCount <= 3 || (worst = VarianceStabalisingStepwiseRegression.tryRemovals(X[bestPos], newVar, newSSR)) == -1) continue;
            System.out.println(" Removing Element > " + worst);
            VarianceStabalisingStepwiseRegression.included[worst] = false;
            for (int x = 0; x < attCount; ++x) {
                if (positions[x] != worst) continue;
                while (x < attCount - 1) {
                    VarianceStabalisingStepwiseRegression.positions[x] = positions[x + 1];
                    ++x;
                }
            }
            --attCount;
            attCount = VarianceStabalisingStepwiseRegression.formatRegressors();
        }
        attCount = VarianceStabalisingStepwiseRegression.formatRegressors();
        LinearModel lm = new LinearModel(workingX, Y);
        lm.fitModel();
        VarianceStabalisingStepwiseRegression.findStats(f2, lm);
    }

    public static void forwardSelectTransform(OutFile f2) {
        double temp;
        LinearModel lm;
        boolean finished = false;
        boolean useYJ = false;
        double bestLambda = 1.0;
        included = new boolean[m + 1];
        int attCount = 0;
        VarianceStabalisingStepwiseRegression.included[0] = true;
        for (int i = 1; i <= m; ++i) {
            VarianceStabalisingStepwiseRegression.included[i] = false;
        }
        positions = new int[m + 1];
        powers = new double[m + 1];
        while (!finished) {
            attCount = VarianceStabalisingStepwiseRegression.formatRegressors();
            lm = new LinearModel(workingX, Y);
            lm.fitModel();
            double var = lm.findStats();
            double oldSSR = lm.getSSR();
            int bestPos = VarianceStabalisingStepwiseRegression.findBestAdditionTransformed(attCount);
            ++attCount;
            lm = new LinearModel(workingX, Y);
            lm.fitModel();
            double newVar = lm.findStats();
            double newSSR = lm.getSSR();
            System.out.println(" Verification: New Var = " + newVar);
            if ((newSSR - oldSSR) / var > 7.0) {
                System.out.println("ADDING = " + bestPos);
                VarianceStabalisingStepwiseRegression.included[bestPos] = true;
                VarianceStabalisingStepwiseRegression.positions[attCount - 1] = bestPos;
                size = attCount;
            } else {
                System.out.println("NOT ADDING = " + bestPos);
                VarianceStabalisingStepwiseRegression.included[bestPos] = false;
                finished = true;
            }
            if (attCount == m + 1) {
                finished = true;
            }
            attCount = VarianceStabalisingStepwiseRegression.formatRegressors();
            System.out.println(" TRY YJ: ");
            bestLambda = YeoJohnson.findBestTransform(workingX, Y);
            temp = (double)Math.round(bestLambda * 2.0) / 2.0;
            double alpha = 1.0;
            System.out.println("Best Lambda value =" + bestLambda + " Rounded = " + temp);
            boolean p = false;
            useYJ = false;
            if (temp == 1.0) continue;
            transformedY = YeoJohnson.transform(temp, Y);
            lm = new LinearModel(workingX, transformedY);
            lm.fitModel();
            double s = lm.findInverseStats(temp, Y);
            useYJ = true;
            System.out.println("s = " + s);
        }
        attCount = VarianceStabalisingStepwiseRegression.formatRegressors();
        if (useYJ) {
            temp = (double)Math.round(bestLambda * 2.0) / 2.0;
            transformedY = YeoJohnson.transform(temp, Y);
            lm = new LinearModel(workingX, transformedY);
        } else {
            lm = new LinearModel(workingX, Y);
        }
        lm.fitModel();
        VarianceStabalisingStepwiseRegression.findStats(f2, lm);
        OutFile f3 = new OutFile("TestTrans" + count + ".csv");
        ++count;
        for (int i = 0; i < powers.length; ++i) {
            f3.writeString(powers[i] + ",");
        }
        for (int j = 0; j < X[0].length; ++j) {
            for (int i = 0; i < X.length; ++i) {
                f3.writeString(X[i][j] + ",");
            }
            f3.writeString("\n");
        }
    }

    public static void transformCode() {
    }

    public static int tryRemovals(double[] inData, double var, double fullSSR) {
        int i;
        int worst = 0;
        double worstSSR = Double.MAX_VALUE;
        double[][] temp = new double[size - 1][];
        temp[0] = workingX[0];
        temp[1] = inData;
        double[] out = workingX[1];
        int[] tempPos = new int[size - 1];
        tempPos[0] = 0;
        int tempOutPos = positions[1];
        tempPos[1] = positions[size - 1];
        System.out.println(" size = " + size);
        for (i = 2; i < size - 1; ++i) {
            temp[i] = workingX[i];
            tempPos[i] = positions[i];
        }
        i = 2;
        do {
            LinearModel lm = new LinearModel(temp, Y);
            lm.fitModel();
            double s = lm.findStats();
            double ssr = lm.getSSR();
            if (ssr < worstSSR) {
                worstSSR = ssr;
                worst = i - 1;
            }
            if (i >= size - 1) continue;
            int a = tempOutPos;
            tempOutPos = tempPos[i];
            tempPos[i] = a;
            double[] t = temp[i];
            temp[i] = out;
            out = t;
        } while (++i < size);
        int outPos = positions[worst];
        if ((fullSSR - worstSSR) / var < 7.0) {
            return outPos;
        }
        return -1;
    }

    public static int findBestAdditionTransformed(int a) {
        int best = -1;
        double[][] temp = new double[a + 1][];
        double minSSE = Double.MAX_VALUE;
        double bestPower = 1.0;
        System.arraycopy(workingX, 0, temp, 0, a);
        for (int i = 0; i < included.length; ++i) {
            if (included[i]) continue;
            temp[a] = X[i];
            double power = PowerSearch.transformRegressor(temp, Y, a);
            if (power != 1.0) {
                temp[a] = PowerSearch.transform(X[i], power);
            }
            LinearModel lmTemp = new LinearModel(temp, Y);
            lmTemp.fitModel();
            double s = lmTemp.findStats();
            if (!(s < minSSE)) continue;
            minSSE = s;
            best = i;
            bestPower = power;
        }
        if (best > 0) {
            System.out.println(" BEST to add = " + best + " with power = " + bestPower + " MSE = " + minSSE);
            VarianceStabalisingStepwiseRegression.powers[best] = bestPower;
            temp[a] = PowerSearch.transform(X[best], bestPower);
            VarianceStabalisingStepwiseRegression.X[best] = temp[a];
            workingX = temp;
        }
        return best;
    }

    public static int findBestAddition(int a) {
        int best = -1;
        double[][] temp = new double[a + 1][];
        double minSSE = Double.MAX_VALUE;
        System.arraycopy(workingX, 0, temp, 0, a);
        for (int i = 0; i < included.length; ++i) {
            if (included[i]) continue;
            temp[a] = X[i];
            LinearModel lmTemp = new LinearModel(temp, Y);
            lmTemp.fitModel();
            double s = lmTemp.findStats();
            if (!(s < minSSE)) continue;
            minSSE = s;
            best = i;
        }
        if (best > 0) {
            System.out.println(" BEST to add = " + best + " with MSE = " + minSSE);
            temp[a] = X[best];
            workingX = temp;
        }
        return best;
    }

    public static int formatRegressors() {
        int attCount = 0;
        for (int i = 0; i < included.length; ++i) {
            if (!included[i]) continue;
            ++attCount;
        }
        workingX = new double[attCount][];
        int c = 0;
        for (int i = 0; i < included.length; ++i) {
            if (!included[i]) continue;
            VarianceStabalisingStepwiseRegression.workingX[c] = X[i];
            VarianceStabalisingStepwiseRegression.positions[c] = i;
            ++c;
        }
        return attCount;
    }

    static {
        size = 0;
        transSize = 0;
        count = 0;
    }
}

