/*
 * Decompiled with CFR 0.152.
 */
package transformations;

import fileIO.OutFile;
import java.io.FileReader;
import transformations.LinearModel;
import weka.core.Instances;

public class PowerSearch {
    public static double MIN = -4.0;
    public static double MAX = 4.0;
    public static double INCREMENT = 0.125;

    public static double transformRegressor(double[][] data, double[] response, int pos) {
        double[] originalData = new double[data[pos].length];
        double[] transformedData = new double[originalData.length];
        for (int i = 0; i < originalData.length; ++i) {
            originalData[i] = data[pos][i];
        }
        data[pos] = transformedData;
        double minAlpha = 0.0;
        double minSSE = Double.MAX_VALUE;
        for (double alpha = MIN; alpha <= MAX; alpha += INCREMENT) {
            int j;
            if (alpha == 0.0) {
                for (j = 0; j < originalData.length; ++j) {
                    transformedData[j] = Math.log(originalData[j]);
                }
            } else {
                for (j = 0; j < originalData.length; ++j) {
                    transformedData[j] = Math.pow(originalData[j], alpha);
                }
            }
            LinearModel l = new LinearModel(data, response);
            l.fitModel();
            double s = l.findStats();
            if (!(s < minSSE)) continue;
            minAlpha = alpha;
            minSSE = s;
        }
        if (minAlpha == MIN || minAlpha == MAX) {
            minAlpha = 1.0;
        }
        return minAlpha;
    }

    public static double[] transform(double[] x, double power) {
        double[] newX = new double[x.length];
        for (int i = 0; i < x.length; ++i) {
            newX[i] = Math.pow(x[i], power);
        }
        return newX;
    }

    public static void main(String[] args) {
        Instances data = null;
        try {
            FileReader r = new FileReader("C:/Research/Code/Archive Generator/src/weka/addOns/BoxTidwellTest2.arff");
            data = new Instances(r);
            data.setClassIndex(data.numAttributes() - 1);
        }
        catch (Exception e) {
            System.out.println("Error loading file " + e);
        }
        double[] powers = new double[data.numAttributes() - 1];
        System.out.println(" Final powers =");
        for (int i = 0; i < powers.length; ++i) {
            System.out.println(i + " =" + powers[i]);
        }
        OutFile r = new OutFile("C:/Research/Code/Archive Generator/src/weka/addOns/BoxTidwellResults2.arff");
        r.writeLine(data.toString());
    }
}

