/*
 * Decompiled with CFR 0.152.
 */
package transformations;

import fileIO.OutFile;
import java.io.FileReader;
import transformations.Transformations;
import weka.attributeSelection.PrincipalComponents;
import weka.core.Instance;
import weka.core.Instances;

public class PCA
extends Transformations {
    double varianceCovered = 1.0;
    PrincipalComponents pca = new PrincipalComponents();

    public void setVariance(double v) {
        this.varianceCovered = v;
    }

    @Override
    public Instances transform(Instances data) {
        Instances newData = data;
        try {
            this.pca.setVarianceCovered(this.varianceCovered);
            this.pca.buildEvaluator(data);
            newData = this.pca.transformedData(data);
        }
        catch (Exception e) {
            System.out.println(" Error = " + e);
            System.exit(0);
        }
        return newData;
    }

    @Override
    public Instances invert(Instances data) {
        return data;
    }

    @Override
    public Instances staticTransform(Instances data) {
        Instance inst = null;
        Instances newData = null;
        try {
            newData = this.pca.transformedHeader();
            for (int i = 0; i < data.numInstances(); ++i) {
                inst = this.pca.convertInstance(data.instance(i));
                newData.add(inst);
            }
        }
        catch (Exception e) {
            System.out.println(" Error in convert " + e);
            System.out.println(" instance =" + inst);
            System.exit(0);
        }
        return newData;
    }

    @Override
    public double[] invertPredictedResponse(double[] d) {
        return d;
    }

    public static void main(String[] args) {
        PCA p = new PCA();
        try {
            FileReader r = new FileReader("C:/Research/Data/Gavin Competition/Weka Files/SO2Combined.arff");
            Instances data = new Instances(r);
            data.setClassIndex(data.numAttributes() - 1);
            p.varianceCovered = 0.95;
            data = p.transform(data);
            System.out.println(" New attribute size = " + data.numAttributes());
            OutFile of = new OutFile("C:/Research/Data/Gavin Competition/Weka Files/SO2CombinedTransformed.arff");
            of.writeLine(data.toString());
            r = new FileReader("C:/Research/Data/Gavin Competition/Weka Files/PrecipCombined.arff");
            data = new Instances(r);
            data.setClassIndex(data.numAttributes() - 1);
            p.varianceCovered = 0.95;
            data = p.transform(data);
            System.out.println(" New attribute size = " + data.numAttributes());
            of = new OutFile("C:/Research/Data/Gavin Competition/Weka Files/PrecipCombinedTransformed.csv");
            of.writeLine(data.toString());
        }
        catch (Exception e) {
            System.out.println(" Error in PCA " + e);
        }
    }
}

