/*
 * Decompiled with CFR 0.152.
 */
package timeseriesweka.filters.shapelet_transforms.search_functions;

import java.util.ArrayList;
import timeseriesweka.filters.shapelet_transforms.ShapeletTransformTimingUtilities;
import timeseriesweka.filters.shapelet_transforms.search_functions.ImpRandomSearch;
import timeseriesweka.filters.shapelet_transforms.search_functions.ShapeletSearchOptions;
import utilities.generic_storage.Triple;
import weka.core.Instances;

public class RefinedRandomSearch
extends ImpRandomSearch {
    float shapeletToSeriesRatio;

    protected RefinedRandomSearch(ShapeletSearchOptions ops) {
        super(ops);
        this.shapeletToSeriesRatio = ops.getProportion();
    }

    @Override
    public void init(Instances input) {
        float currentRatio;
        super.init(input);
        int numInstances = input.numInstances();
        int numAttributes = this.seriesLength - 1;
        do {
            long totalShapelets = ShapeletTransformTimingUtilities.calculateNumberOfShapelets(--numInstances, numAttributes, this.minShapeletLength, this.maxShapeletLength);
            currentRatio = (float)this.numShapelets / (float)totalShapelets;
        } while (numInstances != 25 && currentRatio < this.shapeletToSeriesRatio);
        this.inputData = input;
        int numLengths = this.maxShapeletLength - this.minShapeletLength;
        int i = 0;
        while ((long)i < this.numShapelets) {
            int series = this.random.nextInt(numInstances);
            int length = this.random.nextInt(numLengths) + this.minShapeletLength;
            int position = this.random.nextInt(numAttributes - length + 1);
            int dimension = this.random.nextInt(this.numDimensions);
            ArrayList<Triple<Integer, Integer, Integer>> shapeletList = (ArrayList<Triple<Integer, Integer, Integer>>)this.shapeletsToFind.get(series);
            if (shapeletList == null) {
                shapeletList = new ArrayList<Triple<Integer, Integer, Integer>>();
            }
            shapeletList.add(new Triple<Integer, Integer, Integer>(length, position, dimension));
            this.shapeletsToFind.put(series, shapeletList);
            ++i;
        }
    }
}

