/*
 * Decompiled with CFR 0.152.
 */
package timeseriesweka.filters.shapelet_transforms.search_functions;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import timeseriesweka.filters.shapelet_transforms.Shapelet;
import timeseriesweka.filters.shapelet_transforms.search_functions.RandomSearch;
import timeseriesweka.filters.shapelet_transforms.search_functions.ShapeletSearch;
import timeseriesweka.filters.shapelet_transforms.search_functions.ShapeletSearchOptions;
import utilities.generic_storage.Triple;
import weka.core.Instance;
import weka.core.Instances;

public class ImpRandomSearch
extends RandomSearch {
    protected Map<Integer, ArrayList<Triple<Integer, Integer, Integer>>> shapeletsToFind = new HashMap<Integer, ArrayList<Triple<Integer, Integer, Integer>>>();
    int currentSeries = 0;

    public Map<Integer, ArrayList<Triple<Integer, Integer, Integer>>> getShapeletsToFind() {
        return this.shapeletsToFind;
    }

    protected ImpRandomSearch(ShapeletSearchOptions ops) {
        super(ops);
    }

    @Override
    public void init(Instances input) {
        super.init(input);
        int numLengths = this.maxShapeletLength - this.minShapeletLength;
        int i = 0;
        while ((long)i < this.numShapelets) {
            int series = this.random.nextInt(input.numInstances());
            int length = this.random.nextInt(numLengths) + this.minShapeletLength;
            int position = this.random.nextInt(this.seriesLength - length);
            int dimension = this.random.nextInt(this.numDimensions);
            ArrayList<Triple<Integer, Integer, Integer>> shapeletList = this.shapeletsToFind.get(series);
            if (shapeletList == null) {
                shapeletList = new ArrayList();
            }
            shapeletList.add(new Triple<Integer, Integer, Integer>(length, position, dimension));
            this.shapeletsToFind.put(series, shapeletList);
            ++i;
        }
    }

    @Override
    public ArrayList<Shapelet> SearchForShapeletsInSeries(Instance timeSeries, ShapeletSearch.ProcessCandidate checkCandidate) {
        ArrayList<Shapelet> seriesShapelets = new ArrayList<Shapelet>();
        ArrayList<Triple<Integer, Integer, Integer>> shapeletList = this.shapeletsToFind.get(this.currentSeries);
        ++this.currentSeries;
        if (shapeletList == null) {
            return seriesShapelets;
        }
        for (Triple<Integer, Integer, Integer> shapelet : shapeletList) {
            Shapelet shape = checkCandidate.process(this.getTimeSeries(timeSeries, (Integer)shapelet.var3), (Integer)shapelet.var1, (Integer)shapelet.var2, (Integer)shapelet.var3);
            if (shape == null) continue;
            seriesShapelets.add(shape);
        }
        return seriesShapelets;
    }
}

