/*
 * Decompiled with CFR 0.152.
 */
package timeseriesweka.filters.shapelet_transforms.quality_measures;

import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import timeseriesweka.filters.shapelet_transforms.OrderLineObj;
import timeseriesweka.filters.shapelet_transforms.quality_measures.ShapeletQualityMeasure;
import utilities.class_distributions.ClassDistribution;

public class MoodsMedian
implements ShapeletQualityMeasure,
Serializable {
    protected MoodsMedian() {
    }

    @Override
    public double calculateQuality(List<OrderLineObj> orderline, ClassDistribution classDistributions) {
        Collections.sort(orderline);
        int lengthOfOrderline = orderline.size();
        double median = lengthOfOrderline % 2 == 0 ? (orderline.get(lengthOfOrderline / 2 - 1).getDistance() + orderline.get(lengthOfOrderline / 2).getDistance()) / 2.0 : orderline.get(lengthOfOrderline / 2).getDistance();
        int totalCount = orderline.size();
        int countBelow = 0;
        int countAbove = 0;
        int numClasses = classDistributions.size();
        int[] classCountsBelowMedian = new int[numClasses];
        int[] classCountsAboveMedian = new int[numClasses];
        for (OrderLineObj orderline1 : orderline) {
            double distance = orderline1.getDistance();
            double classVal = orderline1.getClassVal();
            if (distance < median) {
                ++countBelow;
                int n = (int)classVal;
                classCountsBelowMedian[n] = classCountsBelowMedian[n] + 1;
                continue;
            }
            ++countAbove;
            int n = (int)classVal;
            classCountsAboveMedian[n] = classCountsAboveMedian[n] + 1;
        }
        double chi = 0.0;
        for (int i = 0; i < numClasses; ++i) {
            double expectedBelow = (double)(countBelow * classDistributions.get((double)i)) / (double)totalCount;
            chi += ((double)classCountsBelowMedian[i] - expectedBelow) * ((double)classCountsBelowMedian[i] - expectedBelow) / expectedBelow;
            double expectedAbove = (double)(countAbove * classDistributions.get((double)i)) / (double)totalCount;
            chi += ((double)classCountsAboveMedian[i] - expectedAbove) * ((double)classCountsAboveMedian[i] - expectedAbove) / expectedAbove;
        }
        if (Double.isNaN(chi)) {
            chi = 0.0;
        }
        return chi;
    }

    @Override
    public double calculateSeperationGap(List<OrderLineObj> orderline) {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

