/*
 * Decompiled with CFR 0.152.
 */
package timeseriesweka.filters.shapelet_transforms.quality_measures;

import java.util.ArrayList;
import java.util.Collections;
import timeseriesweka.filters.shapelet_transforms.OrderLineObj;
import timeseriesweka.filters.shapelet_transforms.quality_measures.ShapeletQualityBound;
import utilities.class_distributions.ClassDistribution;

public class KruskalWallisBound
extends ShapeletQualityBound {
    protected KruskalWallisBound(ClassDistribution classDist, int percentage) {
        this.initParentFields(classDist, percentage);
    }

    @Override
    public void updateOrderLine(OrderLineObj orderLineObj) {
        super.updateOrderLine(orderLineObj);
        --this.numInstances;
    }

    @Override
    protected double calculateBestQuality() {
        int numClasses = this.parentClassDist.size();
        int[] classRankCounts = new int[numClasses];
        double minimumRank = -1.0;
        double maximumRank = -1.0;
        double lastDistance = ((OrderLineObj)this.orderLine.get(0)).getDistance();
        double classVal = ((OrderLineObj)this.orderLine.get(0)).getClassVal();
        int n = (int)classVal;
        classRankCounts[n] = classRankCounts[n] + 1;
        int duplicateCount = 0;
        for (int i = 1; i < this.orderLine.size(); ++i) {
            int j;
            double avgRank;
            double maxRank;
            double minRank;
            double thisDistance = ((OrderLineObj)this.orderLine.get(i)).getDistance();
            if (duplicateCount == 0 && thisDistance != lastDistance) {
                int n2 = (int)((OrderLineObj)this.orderLine.get(i)).getClassVal();
                classRankCounts[n2] = classRankCounts[n2] + (i + 1);
                if (thisDistance > 0.0 && minimumRank == -1.0) {
                    minimumRank = i + 1;
                }
                maximumRank = i + 1;
            } else if (duplicateCount > 0 && thisDistance != lastDistance) {
                minRank = i - duplicateCount;
                maxRank = i;
                avgRank = (minRank + maxRank) / 2.0;
                for (j = i - duplicateCount - 1; j < i; ++j) {
                    int n3 = (int)((OrderLineObj)this.orderLine.get(j)).getClassVal();
                    classRankCounts[n3] = (int)((double)classRankCounts[n3] + avgRank);
                }
                duplicateCount = 0;
                int n4 = (int)((OrderLineObj)this.orderLine.get(i)).getClassVal();
                classRankCounts[n4] = classRankCounts[n4] + (i + 1);
                if (thisDistance > 0.0 && minimumRank == -1.0) {
                    minimumRank = i + 1;
                }
                maximumRank = i + 1;
            } else {
                if (i == this.orderLine.size() - 1) {
                    minRank = i - duplicateCount;
                    maxRank = i + 1;
                    avgRank = (minRank + maxRank) / 2.0;
                    for (j = i - duplicateCount - 1; j <= i; ++j) {
                        int n5 = (int)((OrderLineObj)this.orderLine.get(j)).getClassVal();
                        classRankCounts[n5] = (int)((double)classRankCounts[n5] + avgRank);
                    }
                    if (thisDistance > 0.0 && minimumRank == -1.0) {
                        minimumRank = avgRank;
                    }
                    maximumRank = avgRank;
                }
                ++duplicateCount;
            }
            lastDistance = thisDistance;
        }
        ArrayList<OrderLineObj> meanRankOrderLine = new ArrayList<OrderLineObj>();
        for (int i = 0; i < numClasses; ++i) {
            meanRankOrderLine.add(new OrderLineObj((double)classRankCounts[i] / (double)this.orderLineClassDist.get((double)i), i));
        }
        Collections.sort(meanRankOrderLine);
        OrderLineObj min = new OrderLineObj(-1.0, 0.0);
        for (OrderLineObj meanRankOrderLine1 : meanRankOrderLine) {
            classVal = meanRankOrderLine1.getClassVal();
            int unassignedObjs = this.parentClassDist.get(classVal) - this.orderLineClassDist.get(classVal);
            double observed = classRankCounts[(int)classVal];
            double predicted = minimumRank * (double)unassignedObjs;
            double approximateRank = (observed + predicted) / (double)this.parentClassDist.get(classVal);
            if (min.getDistance() != -1.0 && !(approximateRank < min.getDistance())) continue;
            min.setDistance(approximateRank);
            min.setClassVal(classVal);
        }
        OrderLineObj max = new OrderLineObj(-1.0, 0.0);
        for (OrderLineObj meanRankOrderLine1 : meanRankOrderLine) {
            classVal = meanRankOrderLine1.getClassVal();
            int unassignedObjs = this.parentClassDist.get(classVal) - this.orderLineClassDist.get(classVal);
            double observed = classRankCounts[(int)classVal];
            double predicted = maximumRank * (double)unassignedObjs;
            double approximateRank = (observed + predicted) / (double)this.parentClassDist.get(classVal);
            if (classVal == min.getClassVal() || max.getDistance() != -1.0 && !(approximateRank > max.getDistance())) continue;
            max.setDistance(approximateRank);
            max.setClassVal(classVal);
        }
        double overallMeanRank = (1.0 + (double)this.orderLine.size() + (double)this.numInstances) / 2.0;
        double increment = (max.getDistance() - min.getDistance()) / (double)(numClasses - 1);
        int multiplyer = 1;
        for (OrderLineObj currentObj : meanRankOrderLine) {
            int unassignedObjs = this.parentClassDist.get(currentObj.getClassVal()) - this.orderLineClassDist.get(currentObj.getClassVal());
            if (currentObj.getClassVal() == min.getClassVal()) {
                currentObj.setDistance(min.getDistance());
                continue;
            }
            if (currentObj.getClassVal() == max.getClassVal()) {
                currentObj.setDistance(max.getDistance());
                continue;
            }
            classVal = currentObj.getClassVal();
            double observed = classRankCounts[(int)classVal];
            double predicted = (minimumRank + increment * (double)multiplyer) * (double)unassignedObjs;
            double approximateRank = (observed + predicted) / (double)this.parentClassDist.get(classVal);
            currentObj.setDistance(approximateRank);
            ++multiplyer;
        }
        double s = 0.0;
        for (int i = 0; i < numClasses; ++i) {
            s += (double)this.parentClassDist.get((double)i) * (((OrderLineObj)meanRankOrderLine.get(i)).getDistance() - overallMeanRank) * (((OrderLineObj)meanRankOrderLine.get(i)).getDistance() - overallMeanRank);
        }
        int totalInstances = this.orderLine.size() + this.numInstances;
        double h = 12.0 / (double)(totalInstances * (totalInstances + 1)) * s;
        return h;
    }

    @Override
    public boolean pruneCandidate() {
        if (this.orderLine.size() % this.parentClassDist.size() != 0) {
            return false;
        }
        return super.pruneCandidate();
    }
}

