/*
 * Decompiled with CFR 0.152.
 */
package timeseriesweka.filters.shapelet_transforms.quality_measures;

import java.util.Map;
import java.util.TreeMap;
import timeseriesweka.filters.shapelet_transforms.OrderLineObj;
import timeseriesweka.filters.shapelet_transforms.quality_measures.InformationGain;
import timeseriesweka.filters.shapelet_transforms.quality_measures.ShapeletQualityBound;
import utilities.class_distributions.ClassDistribution;
import utilities.class_distributions.TreeSetClassDistribution;

public class InformationGainBound
extends ShapeletQualityBound {
    private double parentEntropy;
    boolean isExact;

    protected InformationGainBound(ClassDistribution classDist, int percentage, boolean isExact) {
        this.initParentFields(classDist, percentage);
        this.isExact = isExact;
        this.parentEntropy = InformationGain.entropy(this.parentClassDist);
    }

    protected InformationGainBound(ClassDistribution classDist, int percentage) {
        this(classDist, percentage, false);
    }

    @Override
    protected double calculateBestQuality() {
        TreeMap<Double, Boolean> perms = new TreeMap<Double, Boolean>();
        double bsfGain = -1.0;
        if (this.isExact) {
            for (Double key : this.orderLineClassDist.keySet()) {
                perms.put(key, Boolean.TRUE);
            }
            block1: for (int totalCycles = perms.keySet().size(); totalCycles > 1; --totalCycles) {
                for (int cycle = 0; cycle < totalCycles; ++cycle) {
                    int start = 0;
                    int count = 0;
                    for (Double key : perms.keySet()) {
                        Boolean val = Boolean.TRUE;
                        if (cycle == start) {
                            val = Boolean.FALSE;
                            int size = perms.keySet().size();
                            if (totalCycles < size && count < size - totalCycles) {
                                ++count;
                                --start;
                            }
                        }
                        perms.put(key, val);
                        ++start;
                    }
                    double currentGain = this.computeIG(perms);
                    if (currentGain > bsfGain) {
                        bsfGain = currentGain;
                    }
                    if (bsfGain > this.bsfQuality) continue block1;
                }
            }
        } else {
            double currentGain = this.computeIG(null);
            if (currentGain > bsfGain) {
                bsfGain = currentGain;
            }
        }
        return bsfGain;
    }

    private double computeIG(Map<Double, Boolean> perm) {
        TreeSetClassDistribution lessClasses = new TreeSetClassDistribution();
        TreeSetClassDistribution greaterClasses = new TreeSetClassDistribution();
        TreeMap<Double, Boolean> isShifted = new TreeMap<Double, Boolean>();
        int countOfAllClasses = 0;
        int countOfLessClasses = 0;
        int countOfGreaterClasses = 0;
        for (double j : this.parentClassDist.keySet()) {
            int lessVal = 0;
            int greaterVal = this.parentClassDist.get(j);
            if (perm != null) {
                if (perm.get(j) != null && perm.get(j).booleanValue()) {
                    lessVal = this.parentClassDist.get(j) - this.orderLineClassDist.get(j);
                    greaterVal = this.orderLineClassDist.get(j);
                }
                countOfLessClasses += lessClasses.get(j);
            } else {
                isShifted.put(j, Boolean.FALSE);
            }
            lessClasses.put(j, lessVal);
            greaterClasses.put(j, greaterVal);
            countOfGreaterClasses += greaterClasses.get(j);
            countOfAllClasses += this.parentClassDist.get(j);
        }
        double bsfGain = -1.0;
        double lastDist = -1.0;
        for (int i = 0; i < this.orderLine.size() - 1; ++i) {
            double entropyGreater;
            double greaterFrac;
            double entropyLess;
            double lessFrac;
            double gain;
            double thisDist = ((OrderLineObj)this.orderLine.get(i)).getDistance();
            double thisClassVal = ((OrderLineObj)this.orderLine.get(i)).getClassVal();
            int oldCount = lessClasses.get(thisClassVal) + 1;
            lessClasses.put(thisClassVal, oldCount);
            oldCount = greaterClasses.get(thisClassVal) - 1;
            greaterClasses.put(thisClassVal, oldCount);
            ++countOfLessClasses;
            --countOfGreaterClasses;
            if (!this.isExact && !((Boolean)isShifted.get(thisClassVal)).booleanValue()) {
                int greaterCount = greaterClasses.get(thisClassVal) - (this.parentClassDist.get(thisClassVal) - this.orderLineClassDist.get(thisClassVal));
                int lessCount = lessClasses.get(thisClassVal);
                if (lessCount - greaterCount > 0) {
                    greaterClasses.put(thisClassVal, greaterClasses.get(thisClassVal) - (this.parentClassDist.get(thisClassVal) - this.orderLineClassDist.get(thisClassVal)));
                    countOfGreaterClasses -= this.parentClassDist.get(thisClassVal) - this.orderLineClassDist.get(thisClassVal);
                    lessClasses.put(thisClassVal, lessClasses.get(thisClassVal) + (this.parentClassDist.get(thisClassVal) - this.orderLineClassDist.get(thisClassVal)));
                    countOfLessClasses += this.parentClassDist.get(thisClassVal) - this.orderLineClassDist.get(thisClassVal);
                    isShifted.put(thisClassVal, Boolean.TRUE);
                }
            }
            if (thisDist != lastDist && (gain = this.parentEntropy - (lessFrac = (double)countOfLessClasses / (double)countOfAllClasses) * (entropyLess = InformationGain.entropy(lessClasses)) - (greaterFrac = (double)countOfGreaterClasses / (double)countOfAllClasses) * (entropyGreater = InformationGain.entropy(greaterClasses))) > bsfGain) {
                bsfGain = gain;
            }
            lastDist = thisDist;
        }
        return bsfGain;
    }

    @Override
    public boolean pruneCandidate() {
        if (this.orderLine.size() % this.parentClassDist.size() != 0) {
            return false;
        }
        return super.pruneCandidate();
    }
}

