/*
 * Decompiled with CFR 0.152.
 */
package timeseriesweka.filters;

import java.util.Arrays;
import weka.core.Capabilities;
import weka.core.DenseInstance;
import weka.core.Instance;
import weka.core.Instances;
import weka.filters.Filter;
import weka.filters.NormalizeAttribute;
import weka.filters.SimpleBatchFilter;

public class RankOrder
extends SimpleBatchFilter {
    public double[][] ranks;
    public int numAtts = 0;
    private boolean normalise = true;

    public void setNormalise(boolean f) {
        this.normalise = f;
    }

    @Override
    public Instances process(Instances inst) throws Exception {
        Instances result = new Instances(this.determineOutputFormat(inst), 0);
        this.rankOrder(inst);
        for (int i = 0; i < inst.numInstances(); ++i) {
            DenseInstance in = new DenseInstance(inst.instance(i));
            for (int j = 0; j < this.numAtts; ++j) {
                in.setValue(j, this.ranks[i][j]);
            }
            result.add(in);
        }
        if (this.normalise) {
            NormalizeAttribute na = new NormalizeAttribute(result);
            result = na.process(result);
        }
        return result;
    }

    public void rankOrder(Instances inst) {
        int j;
        this.numAtts = inst.numAttributes();
        int c = inst.classIndex();
        if (c > 0) {
            --this.numAtts;
        }
        Pair[][] d = new Pair[this.numAtts][inst.numInstances()];
        for (j = 0; j < inst.numInstances(); ++j) {
            Instance x = inst.instance(j);
            for (int i = 0; i < this.numAtts; ++i) {
                d[i][j] = new Pair(j, x.value(i));
            }
        }
        for (int i = 0; i < this.numAtts; ++i) {
            Arrays.sort(d[i]);
        }
        this.ranks = new double[inst.numInstances()][this.numAtts];
        for (j = 0; j < inst.numInstances(); ++j) {
            for (int i = 0; i < this.numAtts; ++i) {
                this.ranks[d[i][j].pos][i] = j;
            }
        }
    }

    public static void testFilter(Instances data, Filter ct) {
        try {
            data.deleteStringAttributes();
            ct.setInputFormat(data);
            Instances newData = Filter.useFilter(data, ct);
            System.out.print(newData);
        }
        catch (Exception e) {
            StackTraceElement[] str;
            System.err.println("Exception thrown =" + e);
            System.err.println("Stack =");
            for (StackTraceElement s : str = e.getStackTrace()) {
                System.err.println(s);
            }
        }
    }

    @Override
    protected Instances determineOutputFormat(Instances inputFormat) {
        Instances result = new Instances(inputFormat, 0);
        return result;
    }

    @Override
    public String globalInfo() {
        return null;
    }

    @Override
    public Capabilities getCapabilities() {
        Capabilities result = super.getCapabilities();
        result.enableAllAttributes();
        result.enableAllClasses();
        result.enable(Capabilities.Capability.NO_CLASS);
        return result;
    }

    @Override
    public String getRevision() {
        return null;
    }

    public static void main(String[] args) {
    }

    protected class Pair
    implements Comparable {
        int pos;
        double val;

        public Pair(int p, double d) {
            this.pos = p;
            this.val = d;
        }

        public int compareTo(Object c) {
            if (this.val > ((Pair)c).val) {
                return 1;
            }
            if (this.val < ((Pair)c).val) {
                return -1;
            }
            return 0;
        }
    }
}

