/*
 * Decompiled with CFR 0.152.
 */
package timeseriesweka.filters;

import timeseriesweka.filters.ACF;
import weka.core.Attribute;
import weka.core.DenseInstance;
import weka.core.FastVector;
import weka.core.Instances;
import weka.filters.SimpleBatchFilter;

public class PACF
extends SimpleBatchFilter {
    public static int globalMaxLag = 25;
    private double[] autos;
    private double[][] partials;
    public int maxLag = globalMaxLag;

    public void setMaxLag(int a) {
        this.maxLag = a;
    }

    @Override
    protected Instances determineOutputFormat(Instances inputFormat) throws Exception {
        for (int i = 0; i < inputFormat.numAttributes(); ++i) {
            if (inputFormat.classIndex() == i || inputFormat.attribute(i).isNumeric()) continue;
            throw new Exception("Non numeric attribute not allowed in ACF");
        }
        this.maxLag = inputFormat.classIndex() >= 0 ? (inputFormat.numAttributes() - 1 > this.maxLag ? this.maxLag : inputFormat.numAttributes() - 1) : (inputFormat.numAttributes() > this.maxLag ? this.maxLag : inputFormat.numAttributes());
        FastVector<Attribute> atts = new FastVector<Attribute>();
        for (int i = 0; i < this.maxLag; ++i) {
            String name = "PACF_" + i;
            atts.addElement(new Attribute(name));
        }
        if (inputFormat.classIndex() >= 0) {
            Attribute target = inputFormat.attribute(inputFormat.classIndex());
            FastVector<String> vals = new FastVector<String>(target.numValues());
            for (int i = 0; i < target.numValues(); ++i) {
                vals.addElement(target.value(i));
            }
            atts.addElement(new Attribute(inputFormat.attribute(inputFormat.classIndex()).name(), vals));
        }
        Instances result = new Instances("PACF" + inputFormat.relationName(), atts, inputFormat.numInstances());
        if (inputFormat.classIndex() >= 0) {
            result.setClassIndex(result.numAttributes() - 1);
        }
        return result;
    }

    @Override
    public Instances process(Instances inst) throws Exception {
        Instances output = this.determineOutputFormat(inst);
        int seriesLength = inst.numAttributes();
        int acfLength = output.numAttributes();
        if (inst.classIndex() >= 0) {
            --seriesLength;
            --acfLength;
        }
        for (int i = 0; i < inst.numInstances(); ++i) {
            double[] d = inst.instance(i).toDoubleArray();
            int c = inst.classIndex();
            if (c >= 0) {
                double[] temp = new double[d.length - 1];
                int count = 0;
                for (int k = 0; k < d.length; ++k) {
                    if (k == c) continue;
                    temp[count] = d[k];
                    ++count;
                }
                d = temp;
            }
            this.autos = ACF.fitAutoCorrelations(d, this.maxLag);
            this.partials = PACF.formPartials(this.autos);
            double[] pi = new double[this.maxLag];
            for (int k = 0; k < this.maxLag; ++k) {
                pi[k] = Double.isNaN(this.partials[k][k]) || Double.isInfinite(this.partials[k][k]) ? 0.0 : this.partials[k][k];
            }
            DenseInstance in = new DenseInstance(output.numAttributes());
            int cls = output.classIndex();
            if (cls >= 0) {
                in.setValue(cls, inst.instance(i).classValue());
            }
            int count = 0;
            for (int k = 0; k < pi.length; ++k) {
                if (k == cls) continue;
                in.setValue(count, pi[k]);
                ++count;
            }
            output.add(in);
        }
        return output;
    }

    public static double[][] formPartials(double[] r) {
        int p = r.length;
        double[][] phi = new double[p][p];
        phi[0][0] = r[0];
        for (int k = 1; k < p; ++k) {
            int i;
            double numerator = r[k];
            for (i = 0; i < k; ++i) {
                numerator -= phi[i][k - 1] * r[k - 1 - i];
            }
            double denominator = 1.0;
            for (i = 0; i < k; ++i) {
                denominator -= phi[k - 1 - i][k - 1] * r[k - 1 - i];
            }
            phi[k][k] = numerator / denominator;
            for (i = 0; i < k; ++i) {
                phi[i][k] = phi[i][k - 1] - phi[k][k] * phi[k - 1 - i][k - 1];
            }
        }
        return phi;
    }

    public double[][] getPartials() {
        return this.partials;
    }

    @Override
    public String globalInfo() {
        return null;
    }

    @Override
    protected boolean hasImmediateOutputFormat() {
        return false;
    }

    @Override
    public String getRevision() {
        return null;
    }

    public static void main(String[] args) {
    }
}

