/*
 * Decompiled with CFR 0.152.
 */
package timeseriesweka.filters;

import development.DataSets;
import fileIO.OutFile;
import timeseriesweka.classifiers.FastDTW_1NN;
import timeseriesweka.filters.Hilbert;
import timeseriesweka.filters.Sine;
import utilities.ClassifierTools;
import weka.core.Attribute;
import weka.core.DenseInstance;
import weka.core.FastVector;
import weka.core.Instance;
import weka.core.Instances;
import weka.filters.SimpleBatchFilter;

public class Cosine
extends SimpleBatchFilter {
    @Override
    protected Instances determineOutputFormat(Instances inputFormat) throws Exception {
        FastVector fv = new FastVector();
        FastVector<Attribute> atts = new FastVector<Attribute>();
        for (int i = 0; i < inputFormat.numAttributes() - 1; ++i) {
            String name = "Cosine_" + i;
            atts.addElement(new Attribute(name));
        }
        Attribute target = inputFormat.attribute(inputFormat.classIndex());
        FastVector<String> vals = new FastVector<String>(target.numValues());
        for (int i = 0; i < target.numValues(); ++i) {
            vals.addElement(target.value(i));
        }
        atts.addElement(new Attribute(inputFormat.attribute(inputFormat.classIndex()).name(), vals));
        Instances result = new Instances("COSINE" + inputFormat.relationName(), atts, inputFormat.numInstances());
        if (inputFormat.classIndex() >= 0) {
            result.setClassIndex(result.numAttributes() - 1);
        }
        return result;
    }

    @Override
    public String globalInfo() {
        return null;
    }

    @Override
    public Instances process(Instances instances) throws Exception {
        Instances result = this.determineOutputFormat(instances);
        int n = instances.numAttributes() - 1;
        for (int j = 0; j < instances.numInstances(); ++j) {
            Instance oldInst = instances.instance(j);
            DenseInstance newInst = new DenseInstance(result.numAttributes());
            for (int k = 0; k < n; ++k) {
                double fk = 0.0;
                for (int i = 0; i < n; ++i) {
                    double c = (double)k * ((double)i + 0.5) * (Math.PI / (double)n);
                    fk += oldInst.value(i) * Math.cos(c);
                }
                newInst.setValue(k, fk);
            }
            newInst.setValue(result.classIndex(), instances.instance(j).classValue());
            result.add(newInst);
        }
        return result;
    }

    @Override
    public String getRevision() {
        return null;
    }

    public static void main(String[] args) {
        String s = "Beef";
        OutFile of1 = new OutFile("C:\\Users\\ajb\\Dropbox\\test\\BeefCosine_TRAIN.arff");
        OutFile of2 = new OutFile("C:\\Users\\ajb\\Dropbox\\test\\BeefCosine_TEST.arff");
        Instances test = ClassifierTools.loadData(DataSets.dropboxPath + s + "\\" + s + "_TEST");
        Instances train = ClassifierTools.loadData(DataSets.dropboxPath + s + "\\" + s + "_TRAIN");
        Cosine cosTransform = new Cosine();
        Sine sinTransform = new Sine();
        Hilbert hilbertTransform = new Hilbert();
        System.out.println(" Data set =" + s);
        try {
            Instances cosTrain = cosTransform.process(train);
            Instances cosTest = cosTransform.process(test);
            of1.writeString(cosTrain + "");
            of2.writeString(cosTest + "");
            System.out.println(" Cosine trans complete");
            FastDTW_1NN a = new FastDTW_1NN();
            a.buildClassifier(cosTrain);
            double acc = ClassifierTools.accuracy(cosTest, a);
            System.out.println(" Cosine acc =" + acc);
        }
        catch (Exception ex) {
            System.out.println("ERROR in Cosine");
        }
    }
}

