/*
 * Decompiled with CFR 0.152.
 */
package timeseriesweka.filters;

import java.util.logging.Level;
import java.util.logging.Logger;
import timeseriesweka.filters.ARMA;
import timeseriesweka.filters.PACF;
import utilities.ClassifierTools;
import utilities.InstanceTools;
import weka.classifiers.bayes.NaiveBayes;
import weka.core.Attribute;
import weka.core.DenseInstance;
import weka.core.FastVector;
import weka.core.Instance;
import weka.core.Instances;
import weka.filters.SimpleBatchFilter;

public class ACF
extends SimpleBatchFilter {
    private static final long serialVersionUID = 1L;
    private boolean normalized = false;
    int endTerms = 4;
    int maxLag;
    int seriesLength;
    int lag = this.maxLag = 300;
    int globalSignificantLag = this.maxLag;
    double globalSigThreshold;
    boolean useGlobalSigThreshold = true;
    double[] sigThreshold;
    int[] cutOffs;
    boolean globalTruncate = true;
    double alpha = 0.1;

    public void setMaxLag(int n) {
        this.maxLag = n;
    }

    public void setNormalized(boolean flag) {
        this.normalized = flag;
    }

    public void setGlobalSigThresh(boolean flag) {
        this.useGlobalSigThreshold = flag;
    }

    @Override
    protected Instances determineOutputFormat(Instances inputFormat) throws Exception {
        this.seriesLength = inputFormat.numAttributes();
        if (inputFormat.classIndex() >= 0) {
            --this.seriesLength;
        }
        for (int i = 0; i < inputFormat.numAttributes(); ++i) {
            if (inputFormat.classIndex() == i || inputFormat.attribute(i).isNumeric()) continue;
            throw new Exception("Non numeric attribute not allowed in ACF");
        }
        if (this.maxLag > inputFormat.numAttributes() - this.endTerms) {
            this.maxLag = inputFormat.numAttributes() - this.endTerms;
        }
        if (this.maxLag < 0) {
            this.maxLag = inputFormat.numAttributes() - 1;
        }
        FastVector<Attribute> atts = new FastVector<Attribute>();
        for (int i = 0; i < this.maxLag; ++i) {
            String name = "ACF_" + i;
            atts.addElement(new Attribute(name));
        }
        if (inputFormat.classIndex() >= 0) {
            Attribute target = inputFormat.attribute(inputFormat.classIndex());
            FastVector<String> vals = new FastVector<String>(target.numValues());
            for (int i = 0; i < target.numValues(); ++i) {
                vals.addElement(target.value(i));
            }
            atts.addElement(new Attribute(inputFormat.attribute(inputFormat.classIndex()).name(), vals));
        }
        Instances result = new Instances("ACF" + inputFormat.relationName(), atts, inputFormat.numInstances());
        if (inputFormat.classIndex() >= 0) {
            result.setClassIndex(result.numAttributes() - 1);
        }
        return result;
    }

    @Override
    public String globalInfo() {
        return null;
    }

    @Override
    public Instances process(Instances inst) throws Exception {
        Instances output = this.determineOutputFormat(inst);
        this.seriesLength = inst.numAttributes();
        int acfLength = output.numAttributes();
        if (inst.classIndex() >= 0) {
            --this.seriesLength;
            --acfLength;
        }
        for (int i = 0; i < inst.numInstances(); ++i) {
            double[] d = inst.instance(i).toDoubleArray();
            int c = inst.classIndex();
            if (c >= 0) {
                double[] temp = new double[d.length - 1];
                int count = 0;
                for (int k = 0; k < d.length; ++k) {
                    if (k == c) continue;
                    temp[count] = d[k];
                    ++count;
                }
                d = temp;
            }
            double[] autoCorr = this.fitAutoCorrelations(d);
            DenseInstance newInst = null;
            newInst = inst.classIndex() >= 0 ? new DenseInstance(acfLength + 1) : new DenseInstance(acfLength);
            for (int j = 0; j < acfLength; ++j) {
                if (autoCorr[j] < -1.0 || autoCorr[j] > 1.0 || Double.isNaN(autoCorr[j]) || Double.isInfinite(autoCorr[j])) {
                    newInst.setValue(j, 0.0);
                    continue;
                }
                newInst.setValue(j, autoCorr[j]);
            }
            if (inst.classIndex() >= 0) {
                newInst.setValue(output.classIndex(), inst.instance(i).classValue());
            }
            output.add(newInst);
        }
        return output;
    }

    public double[] fitAutoCorrelations(double[] data) {
        double[] a = new double[this.maxLag];
        if (!this.normalized) {
            for (int i = 1; i <= this.maxLag; ++i) {
                int j;
                a[i - 1] = 0.0;
                double ss2 = 0.0;
                double ss1 = 0.0;
                double s2 = 0.0;
                double s1 = 0.0;
                for (j = 0; j < data.length - i; ++j) {
                    s1 += data[j];
                    ss1 += data[j] * data[j];
                    s2 += data[j + i];
                    ss2 += data[j + i] * data[j + i];
                }
                s1 /= (double)(data.length - i);
                s2 /= (double)(data.length - i);
                for (j = 0; j < data.length - i; ++j) {
                    int n = i - 1;
                    a[n] = a[n] + (data[j] - s1) * (data[j + i] - s2);
                }
                int n = i - 1;
                a[n] = a[n] / (double)(data.length - i);
                double v1 = ss1 / (double)(data.length - i) - s1 * s1;
                double v2 = ss2 / (double)(data.length - i) - s2 * s2;
                int n2 = i - 1;
                a[n2] = a[n2] / (Math.sqrt(v1) * Math.sqrt(v2));
            }
        } else {
            for (int i = 1; i <= this.maxLag; ++i) {
                a[i - 1] = 0.0;
                for (int j = 0; j < data.length - i; ++j) {
                    int n = i - 1;
                    a[n] = a[n] + data[j] * data[j + i];
                }
                int n = i - 1;
                a[n] = a[n] / (double)data.length;
            }
        }
        return a;
    }

    public static double[] fitAutoCorrelations(double[] data, int mLag) {
        double[] a = new double[mLag];
        for (int i = 1; i <= mLag; ++i) {
            int j;
            a[i - 1] = 0.0;
            double ss2 = 0.0;
            double ss1 = 0.0;
            double s2 = 0.0;
            double s1 = 0.0;
            for (j = 0; j < data.length - i; ++j) {
                s1 += data[j];
                ss1 += data[j] * data[j];
                s2 += data[j + i];
                ss2 += data[j + i] * data[j + i];
            }
            s1 /= (double)(data.length - i);
            s2 /= (double)(data.length - i);
            for (j = 0; j < data.length - i; ++j) {
                int n = i - 1;
                a[n] = a[n] + (data[j] - s1) * (data[j + i] - s2);
            }
            int n = i - 1;
            a[n] = a[n] / (double)(data.length - i);
            double v1 = ss1 / (double)(data.length - i) - s1 * s1;
            double v2 = ss2 / (double)(data.length - i) - s2 * s2;
            int n2 = i - 1;
            a[n2] = a[n2] / (Math.sqrt(v1) * Math.sqrt(v2));
        }
        return a;
    }

    @Override
    public String getRevision() {
        return null;
    }

    public int truncate(Instances d, boolean global) {
        this.globalTruncate = global;
        return this.truncate(d);
    }

    public int truncate(Instances d) {
        int largestPos = 0;
        int[] c = this.findAllCutOffs(d);
        if (this.globalTruncate) {
            for (int i = 1; i < c.length; ++i) {
                if (c[largestPos] >= c[i]) continue;
                largestPos = i;
            }
            if (largestPos < d.numAttributes() - 2) {
                ++largestPos;
            }
            this.truncate(d, largestPos);
        } else {
            for (int i = 0; i < d.numInstances(); ++i) {
                this.zeroInstance(d.instance(i), c[i]);
            }
        }
        return largestPos;
    }

    public void truncate(Instances d, int n) {
        int att = n;
        while (att < d.numAttributes()) {
            if (att == d.classIndex()) {
                ++att;
                continue;
            }
            d.deleteAttributeAt(att);
        }
    }

    private void zeroInstance(Instance ins, int p) {
        for (int i = p; i < ins.numAttributes(); ++i) {
            if (i == ins.classIndex()) continue;
            ins.setValue(i, 0.0);
        }
    }

    private int[] findAllCutOffs(Instances inst) {
        this.globalSigThreshold = 2.0 / Math.sqrt(this.seriesLength);
        this.sigThreshold = new double[inst.numAttributes() - 1];
        this.cutOffs = new int[inst.numInstances()];
        for (int i = 0; i < this.cutOffs.length; ++i) {
            this.cutOffs[i] = this.findSingleCutOff(inst.instance(i));
        }
        return this.cutOffs;
    }

    private int findSingleCutOff(Instance inst) {
        int i;
        double[] r = inst.toDoubleArray();
        int count = 0;
        if (this.useGlobalSigThreshold) {
            for (i = 0; i < inst.numAttributes(); ++i) {
                if (i == inst.classIndex()) continue;
                this.sigThreshold[count] = this.globalSigThreshold;
                ++count;
            }
        } else {
            this.sigThreshold[0] = r[0] * r[0];
            count = 1;
            for (i = 1; i < inst.numAttributes(); ++i) {
                if (i == inst.classIndex()) continue;
                this.sigThreshold[count] = this.sigThreshold[count - 1] + r[i] * r[i];
                ++count;
            }
            for (i = 0; i < this.sigThreshold.length; ++i) {
                this.sigThreshold[i] = (1.0 + this.sigThreshold[i]) / (double)this.seriesLength;
                this.sigThreshold[i] = 2.0 / Math.sqrt(this.sigThreshold[i]);
            }
        }
        for (i = 0; i < this.sigThreshold.length; ++i) {
            if (!(Math.abs(r[i]) < this.sigThreshold[i])) continue;
            return i;
        }
        return this.sigThreshold.length - 1;
    }

    public static Instances formChangeCombo(Instances d) {
        int maxLag = (d.numAttributes() - 1) / 4;
        if (maxLag > 100) {
            maxLag = 100;
        }
        if (maxLag < 10) {
            maxLag = d.numAttributes() - 1;
        }
        try {
            ACF acf = new ACF();
            acf.setMaxLag(maxLag);
            acf.setNormalized(false);
            Instances acfData = acf.process(d);
            ARMA arma = new ARMA();
            arma.setMaxLag(maxLag);
            arma.setUseAIC(false);
            Instances arData = arma.process(d);
            PACF pacf = new PACF();
            pacf.setMaxLag(maxLag);
            Instances pacfData = pacf.process(d);
            Instances combo = new Instances(acfData);
            combo.setClassIndex(-1);
            combo.deleteAttributeAt(combo.numAttributes() - 1);
            combo = Instances.mergeInstances(combo, pacfData);
            combo.deleteAttributeAt(combo.numAttributes() - 1);
            combo = Instances.mergeInstances(combo, arData);
            combo.setClassIndex(combo.numAttributes() - 1);
            return combo;
        }
        catch (Exception e) {
            System.out.println(" Exception in Combo=" + e + " max lag =" + maxLag);
            e.printStackTrace();
            System.exit(0);
            return null;
        }
    }

    public static void main(String[] args) {
        Instances train = ClassifierTools.loadData("C:\\Users\\ajb\\Dropbox\\TSC Problems\\ElectricDevices\\ElectricDevices_TRAIN");
        Instances test = ClassifierTools.loadData("C:\\Users\\ajb\\Dropbox\\TSC Problems\\ElectricDevices\\ElectricDevices_TEST");
        ACF acf = new ACF();
        try {
            Instances f = acf.process(train);
            NaiveBayes nb = new NaiveBayes();
            f = InstanceTools.subSample(f, f.numInstances() / 100, 0);
            nb.buildClassifier(f);
        }
        catch (Exception ex) {
            Logger.getLogger(ACF.class.getName()).log(Level.SEVERE, null, ex);
        }
    }
}

