/*
 * Decompiled with CFR 0.152.
 */
package timeseriesweka.examples;

import development.DataSets;
import fileIO.OutFile;
import java.io.File;
import java.text.DecimalFormat;
import timeseriesweka.classifiers.BOSS;
import timeseriesweka.classifiers.BagOfPatterns;
import timeseriesweka.classifiers.DD_DTW;
import timeseriesweka.classifiers.DTD_C;
import timeseriesweka.classifiers.FastShapelets;
import timeseriesweka.classifiers.LPS;
import timeseriesweka.classifiers.LearnShapelets;
import timeseriesweka.classifiers.NN_CID;
import timeseriesweka.classifiers.RISE;
import timeseriesweka.classifiers.SAXVSM;
import timeseriesweka.classifiers.ST_HESCA;
import timeseriesweka.classifiers.TSBF;
import timeseriesweka.classifiers.TSF;
import timeseriesweka.classifiers.ensembles.SaveableEnsemble;
import timeseriesweka.classifiers.ensembles.elastic_ensemble.DTW1NN;
import timeseriesweka.classifiers.ensembles.elastic_ensemble.ED1NN;
import timeseriesweka.classifiers.ensembles.elastic_ensemble.MSM1NN;
import timeseriesweka.classifiers.ensembles.elastic_ensemble.WDTW1NN;
import utilities.ClassifierTools;
import utilities.InstanceTools;
import utilities.SaveParameterInfo;
import vector_classifiers.HESCA;
import weka.classifiers.AbstractClassifier;
import weka.classifiers.Classifier;
import weka.classifiers.bayes.BayesNet;
import weka.classifiers.bayes.NaiveBayes;
import weka.classifiers.functions.Logistic;
import weka.classifiers.functions.MultilayerPerceptron;
import weka.classifiers.functions.SMO;
import weka.classifiers.functions.supportVector.PolyKernel;
import weka.classifiers.meta.RotationForest;
import weka.classifiers.trees.J48;
import weka.classifiers.trees.RandomForest;
import weka.core.Instances;

public class ClassificationExamples {
    static String[] standard = new String[]{"NB", "C45", "SVML", "SVMQ", "Logistic", "BN", "RandF", "RotF", "MLP"};
    static String[] elastic = new String[]{"Euclidean_1NN", "DTW_R1_1NN", "DTW_Rn_1NN", "DDTW_R1_1NN", "DDTW_Rn_1NN", "ERP_1NN", "LCSS_1NN", "MSM_1NN", "TWE_1NN", "WDDTW_1NN", "WDTW_1NN", "DD_DTW", "DTD_C", "DTW_F"};
    static String[] shapelet = new String[]{"ST", "LS", "FS"};
    static String[] dictionary = new String[]{"BoP", "SAXVSM", "BOSS"};
    static String[] interval = new String[]{"TSF", "TSBF", "LPS"};
    static String[] ensemble = new String[]{"ACF", "PS", "EE", "COTE"};
    static String[] complexity = new String[]{"CID_ED", "CID_DTW"};
    static String[][] classifiers = new String[][]{standard, elastic, shapelet, dictionary, interval, ensemble, complexity};
    static final String[] directoryNames = new String[]{"standard", "elastic", "shapelet", "dictionary", "interval", "ensemble", "complexity"};

    public static Classifier setClassifier(String classifier) {
        AbstractClassifier c = null;
        switch (classifier) {
            case "ED": {
                c = new ED1NN();
                break;
            }
            case "C45": {
                c = new J48();
                break;
            }
            case "NB": {
                c = new NaiveBayes();
                break;
            }
            case "SVML": {
                c = new SMO();
                PolyKernel p = new PolyKernel();
                p.setExponent(1.0);
                ((SMO)c).setKernel(p);
                break;
            }
            case "SVMQ": {
                c = new SMO();
                PolyKernel p2 = new PolyKernel();
                p2.setExponent(2.0);
                ((SMO)c).setKernel(p2);
                break;
            }
            case "BN": {
                c = new BayesNet();
                break;
            }
            case "MLP": {
                c = new MultilayerPerceptron();
                break;
            }
            case "RandF": {
                c = new RandomForest();
                ((RandomForest)c).setNumTrees(500);
                break;
            }
            case "RotF": {
                c = new RotationForest();
                ((RotationForest)c).setNumIterations(50);
                break;
            }
            case "Logistic": {
                c = new Logistic();
                break;
            }
            case "HESCA": {
                c = new HESCA();
                break;
            }
            case "DTW": {
                c = new DTW1NN();
                ((DTW1NN)c).setWindow(1.0);
                break;
            }
            case "DTWCV": {
                c = new DTW1NN();
                break;
            }
            case "DD_DTW": {
                c = new DD_DTW();
                break;
            }
            case "DTD_C": {
                c = new DTD_C();
                break;
            }
            case "CID_DTW": {
                c = new NN_CID();
                ((NN_CID)c).useDTW();
                break;
            }
            case "MSM": {
                c = new MSM1NN();
                break;
            }
            case "TWE": {
                c = new MSM1NN();
                break;
            }
            case "WDTW": {
                c = new WDTW1NN();
                break;
            }
            case "LearnShapelets": 
            case "LS": {
                c = new LearnShapelets();
                break;
            }
            case "FastShapelets": 
            case "FS": {
                c = new FastShapelets();
                break;
            }
            case "ShapeletTransform": 
            case "ST": 
            case "ST_Ensemble": {
                c = new ST_HESCA();
                break;
            }
            case "TSF": {
                c = new TSF();
                break;
            }
            case "RISE": {
                c = new RISE();
                break;
            }
            case "TSBF": {
                c = new TSBF();
                break;
            }
            case "BOP": 
            case "BoP": 
            case "BagOfPatterns": {
                c = new BagOfPatterns();
                break;
            }
            case "BOSS": 
            case "BOSSEnsemble": {
                c = new BOSS();
                break;
            }
            case "SAXVSM": 
            case "SAX": {
                c = new SAXVSM();
                break;
            }
            case "LPS": {
                c = new LPS();
                break;
            }
            default: {
                System.out.println("UNKNOWN CLASSIFIER");
                System.exit(0);
            }
        }
        return c;
    }

    public static void singleClassifierAndFold(String[] args) {
        String predictions;
        String classifier = args[0];
        String problem = args[1];
        int fold = Integer.parseInt(args[2]) - 1;
        Classifier c = ClassificationExamples.setClassifier(classifier);
        Instances train = ClassifierTools.loadData(DataSets.problemPath + problem + "/" + problem + "_TRAIN");
        Instances test = ClassifierTools.loadData(DataSets.problemPath + problem + "/" + problem + "_TEST");
        File f = new File(DataSets.resultsPath + classifier);
        if (!f.exists()) {
            f.mkdir();
        }
        if (!(f = new File(predictions = DataSets.resultsPath + classifier + "/Predictions")).exists()) {
            f.mkdir();
        }
        if (!(f = new File(predictions = predictions + "/" + problem)).exists()) {
            f.mkdir();
        }
        if (!(f = new File(predictions + "/fold" + fold + ".csv")).exists() || f.length() == 0L) {
            double acc = 0.0;
            acc = ClassificationExamples.singleClassifierAndFold(train, test, c, fold, predictions);
        }
    }

    public static double singleClassifierAndFold(Instances train, Instances test, Classifier c, int fold, String resultsPath) {
        Instances[] data = InstanceTools.resampleTrainAndTestInstances(train, test, fold);
        double acc = 0.0;
        if (c instanceof SaveableEnsemble) {
            ((SaveableEnsemble)((Object)c)).saveResults(resultsPath + "/internalCV_" + fold + ".csv", resultsPath + "/internalTestPreds_" + fold + ".csv");
        }
        try {
            c.buildClassifier(data[0]);
            StringBuilder str = new StringBuilder();
            DecimalFormat df = new DecimalFormat("##.######");
            for (int j = 0; j < data[1].numInstances(); ++j) {
                int act = (int)data[1].instance(j).classValue();
                double[] probs = c.distributionForInstance(data[1].instance(j));
                int pred = 0;
                for (int i = 1; i < probs.length; ++i) {
                    if (!(probs[i] > probs[pred])) continue;
                    pred = i;
                }
                if (act == pred) {
                    acc += 1.0;
                }
                str.append(act);
                str.append(",");
                str.append(pred);
                str.append(",,");
                for (double d : probs) {
                    str.append(df.format(d));
                    str.append(",");
                }
                str.append("\n");
            }
            acc /= (double)data[1].numInstances();
            OutFile p = new OutFile(resultsPath + "/testFold" + fold + ".csv");
            p.writeLine(train.relationName() + "," + c.getClass().getName() + ",test");
            if (c instanceof SaveParameterInfo) {
                p.writeLine(((SaveParameterInfo)((Object)c)).getParameters());
            } else {
                p.writeLine("No parameter info");
            }
            p.writeLine(acc + "");
            p.writeLine(str.toString());
        }
        catch (Exception e) {
            System.out.println(" Error =" + e + " in method simpleExperiment" + e);
            e.printStackTrace();
            System.out.println(" TRAIN " + train.relationName() + " has " + train.numAttributes() + " attributes and " + train.numInstances() + " instances");
            System.out.println(" TEST " + test.relationName() + " has " + test.numAttributes() + " attributes" + test.numInstances() + " instances");
            System.exit(0);
        }
        return acc;
    }

    public static void main(String[] args) {
        DataSets.problemPath = DataSets.dropboxPath + "TSC Problems/";
        DataSets.resultsPath = "C:/Temp/";
        String[] paras = new String[]{"BOSS", "ItalyPowerDemand", "1"};
        ClassificationExamples.singleClassifierAndFold(paras);
    }
}

