/*
 * Decompiled with CFR 0.152.
 */
package timeseriesweka.elastic_distance_measures;

import weka.core.EuclideanDistance;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.neighboursearch.PerformanceStats;

public class LCSSDistance
extends EuclideanDistance {
    private double epsilon;
    private int delta;

    public LCSSDistance(int delta, double epsilon) {
        this.m_DontNormalize = true;
        this.delta = delta;
        this.epsilon = epsilon;
    }

    @Override
    public double distance(Instance first, Instance second, double cutOffValue, PerformanceStats stats) {
        return this.distance(first, second);
    }

    @Override
    public double distance(Instance first, Instance second, double cutOffValue) {
        double[] arr2;
        int secondClassIndex;
        double[] arr1;
        int firtClassIndex = first.classIndex();
        if (firtClassIndex > 0) {
            arr1 = new double[first.numAttributes() - 1];
            int j = 0;
            for (int i = 0; i < first.numAttributes(); ++i) {
                if (i == firtClassIndex) continue;
                arr1[j] = first.value(i);
                ++j;
            }
        } else {
            arr1 = first.toDoubleArray();
        }
        if ((secondClassIndex = second.classIndex()) > 0) {
            arr2 = new double[second.numAttributes() - 1];
            int j = 0;
            for (int i = 0; i < second.numAttributes(); ++i) {
                if (i == secondClassIndex) continue;
                arr2[j] = second.value(i);
                ++j;
            }
        } else {
            arr2 = second.toDoubleArray();
        }
        return this.distance(arr1, arr2, cutOffValue);
    }

    public double distance(double[] first, double[] second, double cutOffValue) {
        return this.distance(first, second);
    }

    public double distance(double[] first, double[] second) {
        double[] a = first;
        double[] b = second;
        int m = first.length;
        int n = second.length;
        int[][] lcss = new int[m + 1][n + 1];
        int[][] lastX = new int[m + 1][n + 1];
        int[][] lastY = new int[m + 1][n + 1];
        for (int i = 0; i < m; ++i) {
            for (int j = i - this.delta; j <= i + this.delta; ++j) {
                if (j < 0 || j >= n) continue;
                if (b[j] + this.epsilon >= a[i] && b[j] - this.epsilon <= a[i]) {
                    lcss[i + 1][j + 1] = lcss[i][j] + 1;
                    lastX[i + 1][j + 1] = i;
                    lastY[i + 1][j + 1] = j;
                    continue;
                }
                if (lcss[i][j + 1] > lcss[i + 1][j]) {
                    lcss[i + 1][j + 1] = lcss[i][j + 1];
                    lastX[i + 1][j + 1] = i;
                    lastY[i + 1][j + 1] = j + 1;
                    continue;
                }
                lcss[i + 1][j + 1] = lcss[i + 1][j];
                lastX[i + 1][j + 1] = i + 1;
                lastY[i + 1][j + 1] = j;
            }
        }
        int max = -1;
        for (int i = 1; i < lcss[lcss.length - 1].length; ++i) {
            if (lcss[lcss.length - 1][i] <= max) continue;
            max = lcss[lcss.length - 1][i];
        }
        return 1.0 - (double)max / (double)m;
    }

    public static double stdv_s(double[] input) {
        double sumx = 0.0;
        double sumx2 = 0.0;
        for (int j = 0; j < input.length; ++j) {
            sumx += input[j];
            sumx2 += input[j] * input[j];
        }
        int n = input.length;
        double mean = sumx / (double)n;
        double standardDev = Math.sqrt(sumx2 / (double)(n - 1) - mean * mean);
        return standardDev;
    }

    public static double stdv_p(Instances input) {
        double sumx = 0.0;
        double sumx2 = 0.0;
        for (int i = 0; i < input.numInstances(); ++i) {
            double[] ins2array = input.instance(i).toDoubleArray();
            for (int j = 0; j < ins2array.length - 1; ++j) {
                sumx += ins2array[j];
                sumx2 += ins2array[j] * ins2array[j];
            }
        }
        int n = input.numInstances() * (input.numAttributes() - 1);
        double mean = sumx / (double)n;
        return Math.sqrt(sumx2 / (double)n - mean * mean);
    }

    public static int[] getInclusive10(int min, int max) {
        int[] output = new int[10];
        double diff = (double)(max - min) / 9.0;
        double[] doubleOut = new double[10];
        doubleOut[0] = min;
        output[0] = min;
        for (int i = 1; i < 9; ++i) {
            doubleOut[i] = doubleOut[i - 1] + diff;
            output[i] = (int)Math.round(doubleOut[i]);
        }
        output[9] = max;
        return output;
    }

    public static double[] getInclusive10(double min, double max) {
        double[] output = new double[10];
        double diff = (max - min) / 9.0;
        output[0] = min;
        for (int i = 1; i < 9; ++i) {
            output[i] = output[i - 1] + diff;
        }
        output[9] = max;
        return output;
    }
}

