/*
 * Decompiled with CFR 0.152.
 */
package timeseriesweka.elastic_distance_measures;

import weka.core.EuclideanDistance;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.neighboursearch.PerformanceStats;

public class ERPDistance
extends EuclideanDistance {
    private double g;
    private double bandSize;

    public ERPDistance(double g, double bandSize) {
        this.g = g;
        this.bandSize = bandSize;
    }

    @Override
    public double distance(Instance first, Instance second, double cutOffValue, PerformanceStats stats) {
        return this.distance(first, second, cutOffValue);
    }

    @Override
    public double distance(Instance first, Instance second, double cutOffValue) {
        double[] arr2;
        int secondClassIndex;
        double[] arr1;
        int firtClassIndex = first.classIndex();
        if (firtClassIndex > 0) {
            arr1 = new double[first.numAttributes() - 1];
            int j = 0;
            for (int i = 0; i < first.numAttributes(); ++i) {
                if (i == firtClassIndex) continue;
                arr1[j] = first.value(i);
                ++j;
            }
        } else {
            arr1 = first.toDoubleArray();
        }
        if ((secondClassIndex = second.classIndex()) > 0) {
            arr2 = new double[second.numAttributes() - 1];
            int j = 0;
            for (int i = 0; i < second.numAttributes(); ++i) {
                if (i == secondClassIndex) continue;
                arr2[j] = second.value(i);
                ++j;
            }
        } else {
            arr2 = second.toDoubleArray();
        }
        return this.distance(arr1, arr2, cutOffValue);
    }

    public double distance(double[] first, double[] second, double cutOffValue) {
        return this.ERPDistance(new NumberVector(first), new NumberVector(second));
    }

    public double ERPDistance(NumberVector v1, NumberVector v2) {
        double[] curr = new double[v2.getDimensionality()];
        double[] prev = new double[v2.getDimensionality()];
        int band = (int)Math.ceil((double)v2.getDimensionality() * this.bandSize);
        double gValue = this.g;
        for (int i = 0; i < v1.getDimensionality(); ++i) {
            int r;
            double[] temp = prev;
            prev = curr;
            curr = temp;
            int l = i - (band + 1);
            if (l < 0) {
                l = 0;
            }
            if ((r = i + (band + 1)) > v2.getDimensionality() - 1) {
                r = v2.getDimensionality() - 1;
            }
            for (int j = l; j <= r; ++j) {
                if (Math.abs(i - j) <= band) {
                    double val1 = v1.doubleValue(i + 1);
                    double val2 = gValue;
                    double diff = val1 - val2;
                    double d1 = Math.sqrt(diff * diff);
                    val1 = gValue;
                    val2 = v2.doubleValue(j + 1);
                    diff = val1 - val2;
                    double d2 = Math.sqrt(diff * diff);
                    val1 = v1.doubleValue(i + 1);
                    val2 = v2.doubleValue(j + 1);
                    diff = val1 - val2;
                    double d12 = Math.sqrt(diff * diff);
                    double dist1 = d1 * d1;
                    double dist2 = d2 * d2;
                    double dist12 = d12 * d12;
                    double cost = i + j != 0 ? (i == 0 || j != 0 && prev[j - 1] + dist12 > curr[j - 1] + dist2 && curr[j - 1] + dist2 < prev[j] + dist1 ? curr[j - 1] + dist2 : (j == 0 || i != 0 && prev[j - 1] + dist12 > prev[j] + dist1 && prev[j] + dist1 < curr[j - 1] + dist2 ? prev[j] + dist1 : prev[j - 1] + dist12)) : 0.0;
                    curr[j] = cost;
                    continue;
                }
                curr[j] = Double.POSITIVE_INFINITY;
            }
        }
        return Math.sqrt(curr[v2.getDimensionality() - 1]);
    }

    public static double stdv_p(Instances input) {
        double sumx = 0.0;
        double sumx2 = 0.0;
        for (int i = 0; i < input.numInstances(); ++i) {
            double[] ins2array = input.instance(i).toDoubleArray();
            for (int j = 0; j < ins2array.length - 1; ++j) {
                sumx += ins2array[j];
                sumx2 += ins2array[j] * ins2array[j];
            }
        }
        int n = input.numInstances() * (input.numAttributes() - 1);
        double mean = sumx / (double)n;
        return Math.sqrt(sumx2 / (double)n - mean * mean);
    }

    public static int[] getInclusive10(int min, int max) {
        int[] output = new int[10];
        double diff = (double)(max - min) / 9.0;
        double[] doubleOut = new double[10];
        doubleOut[0] = min;
        output[0] = min;
        for (int i = 1; i < 9; ++i) {
            doubleOut[i] = doubleOut[i - 1] + diff;
            output[i] = (int)Math.round(doubleOut[i]);
        }
        output[9] = max;
        return output;
    }

    public static double[] getInclusive10(double min, double max) {
        double[] output = new double[10];
        double diff = (max - min) / 9.0;
        output[0] = min;
        for (int i = 1; i < 9; ++i) {
            output[i] = output[i - 1] + diff;
        }
        output[9] = max;
        return output;
    }

    public static void main(String[] args) {
        ERPDistance erp = new ERPDistance(0.5, 0.5);
        double[] one = new double[]{1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0, 10.0};
        double[] two = new double[]{1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0, 10.0};
        System.out.println(erp.distance(one, two, 0.0));
    }

    private static class NumberVector {
        private double[] values;

        public NumberVector(double[] values) {
            this.values = values;
        }

        public int getDimensionality() {
            return this.values.length;
        }

        public double doubleValue(int dimension) {
            try {
                return this.values[dimension - 1];
            }
            catch (IndexOutOfBoundsException e) {
                throw new IllegalArgumentException("Dimension " + dimension + " out of range.");
            }
        }
    }
}

