/*
 * Decompiled with CFR 0.152.
 */
package timeseriesweka.elastic_distance_measures;

import utilities.ClassifierTools;
import weka.core.EuclideanDistance;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.neighboursearch.PerformanceStats;

public class BasicDTW
extends EuclideanDistance {
    protected double[][] distances;

    public BasicDTW() {
        this.m_DontNormalize = true;
    }

    public BasicDTW(Instances d) {
        super(d);
        this.m_DontNormalize = true;
    }

    @Override
    public double distance(Instance first, Instance second, double cutOffValue, PerformanceStats stats) {
        return this.distance(first, second, cutOffValue);
    }

    @Override
    public double distance(Instance first, Instance second) {
        return this.distance(first, second, Double.POSITIVE_INFINITY);
    }

    @Override
    public double distance(Instance first, Instance second, double cutOffValue) {
        double[] arr2;
        int secondClassIndex;
        double[] arr1;
        int firtClassIndex = first.classIndex();
        if (firtClassIndex > 0) {
            arr1 = new double[first.numAttributes() - 1];
            int j = 0;
            for (int i = 0; i < first.numAttributes(); ++i) {
                if (i == firtClassIndex) continue;
                arr1[j] = first.value(i);
                ++j;
            }
        } else {
            arr1 = first.toDoubleArray();
        }
        if ((secondClassIndex = second.classIndex()) > 0) {
            arr2 = new double[second.numAttributes() - 1];
            int j = 0;
            for (int i = 0; i < second.numAttributes(); ++i) {
                if (i == secondClassIndex) continue;
                arr2[j] = second.value(i);
                ++j;
            }
        } else {
            arr2 = second.toDoubleArray();
        }
        return this.distance(arr1, arr2, cutOffValue);
    }

    public double distance(double[] first, double[] second, double cutOffValue) {
        int i;
        this.distances = new double[first.length][second.length];
        this.distances[0][0] = (first[0] - second[0]) * (first[0] - second[0]);
        for (i = 1; i < second.length; ++i) {
            this.distances[0][i] = this.distances[0][i - 1] + (first[0] - second[i]) * (first[0] - second[i]);
        }
        for (i = 1; i < first.length; ++i) {
            this.distances[i][0] = this.distances[i - 1][0] + (first[i] - second[0]) * (first[i] - second[0]);
        }
        boolean overFlow = true;
        for (int i2 = 1; i2 < first.length; ++i2) {
            overFlow = true;
            for (int j = 1; j < second.length; ++j) {
                double minDistance = Math.min(this.distances[i2][j - 1], Math.min(this.distances[i2 - 1][j], this.distances[i2 - 1][j - 1]));
                this.distances[i2][j] = minDistance + (first[i2] - second[j]) * (first[i2] - second[j]);
                if (!overFlow || !(this.distances[i2][j] < cutOffValue)) continue;
                overFlow = false;
            }
            if (!overFlow) continue;
            return Double.MAX_VALUE;
        }
        return this.distances[first.length - 1][second.length - 1];
    }

    public String printMinCostWarpPath() {
        return this.findPath(this.distances.length - 1, this.distances[0].length - 1);
    }

    protected String findPath(int i, int j) {
        double prevDistance = this.distances[i][j];
        int oldI = i;
        int oldJ = j;
        if (i != 0 || j != 0) {
            if (i > 0 && j > 0) {
                double min = Math.min(this.distances[i - 1][j], Math.min(this.distances[i - 1][j - 1], this.distances[i][j - 1]));
                if (this.distances[i - 1][j - 1] == min) {
                    --i;
                    --j;
                } else if (this.distances[i - 1][j] == min) {
                    --i;
                } else if (this.distances[i][j - 1] == min) {
                    --j;
                }
            } else if (j > 0) {
                --j;
            } else if (i > 0) {
                --i;
            }
            return "(" + oldI + "," + oldJ + ") = " + prevDistance + "\n" + this.findPath(i, j);
        }
        return "(" + oldI + "," + oldJ + ") = " + prevDistance + "\n";
    }

    public double[][] getDistanceArray() {
        return this.distances;
    }

    public void printDiagonalRoute() {
        System.out.println("------------------ Diagonal Route ------------------");
        for (int i = this.distances.length - 1; i >= 0; --i) {
            System.out.print(this.distances[i][i] + " ");
        }
        System.out.println("\n------------------ End ------------------");
    }

    public void printDistances() {
        System.out.println("------------------ Distances Table ------------------");
        for (int i = 0; i < this.distances.length; ++i) {
            System.out.print("Row =" + i + " = ");
            for (int j = 0; j < this.distances[0].length; ++j) {
                System.out.print(" " + this.distances[i][j]);
            }
            System.out.print("\n");
        }
        System.out.println("------------------ End ------------------");
    }

    @Override
    public String toString() {
        return "BasicDTW";
    }

    public static void main(String[] args) {
        Instances test = ClassifierTools.loadData("C:\\Users\\ajb\\Dropbox\\test\\Beef");
        BasicDTW dtw = new BasicDTW(test);
        EuclideanDistance ed = new EuclideanDistance(test);
        ed.setDontNormalize(true);
        System.out.println(" DATA \n" + test.toString());
        System.out.println(" ED =" + ed.distance(test.instance(0), test.instance(1)));
        System.out.println(" ED =" + ed.distance(test.instance(0), test.instance(1), 2.0));
        System.out.println(" DTW =" + dtw.distance(test.instance(0), test.instance(1)));
        System.out.println(" DTW =" + dtw.distance(test.instance(0), test.instance(1), 1.0));
    }
}

