/*
 * Decompiled with CFR 0.152.
 */
package timeseriesweka.classifiers.ensembles.weightings;

import timeseriesweka.classifiers.ensembles.EnsembleModule;
import timeseriesweka.classifiers.ensembles.weightings.MCCWeighting;
import timeseriesweka.classifiers.ensembles.weightings.ModuleWeightingScheme;
import timeseriesweka.classifiers.ensembles.weightings.TrainAcc;

public class TrainAccOrMCC
extends ModuleWeightingScheme {
    protected double unevenProp = 4.0;
    private ModuleWeightingScheme scheme = null;

    public TrainAccOrMCC() {
        this.uniformWeighting = true;
    }

    public TrainAccOrMCC(double minPropToUseMCC) {
        this.uniformWeighting = true;
        this.unevenProp = minPropToUseMCC;
    }

    @Override
    public void defineWeightings(EnsembleModule[] modules, int numClasses) {
        double[] dist = this.classDistribution(modules[0].trainResults.getTrueClassVals(), numClasses);
        double max = dist[0];
        double min = dist[0];
        for (int c = 1; c < dist.length; ++c) {
            if (dist[c] > max) {
                max = dist[c];
                continue;
            }
            if (!(dist[c] < min)) continue;
            min = dist[c];
        }
        this.scheme = max >= min * this.unevenProp ? new MCCWeighting() : new TrainAcc();
        for (EnsembleModule module : modules) {
            module.posteriorWeights = this.defineWeighting(module, numClasses);
        }
    }

    @Override
    protected double[] defineWeighting(EnsembleModule trainPredictions, int numClasses) {
        return this.scheme.defineWeighting(trainPredictions, numClasses);
    }

    protected double[] classDistribution(double[] classVals, int numClasses) {
        double[] dist = new double[numClasses];
        for (double c : classVals) {
            int n = (int)c;
            dist[n] = dist[n] + 1.0;
        }
        int i = 0;
        while (i < numClasses) {
            int n = i++;
            dist[n] = dist[n] / (double)classVals.length;
        }
        return dist;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.unevenProp + ")";
    }
}

