/*
 * Decompiled with CFR 0.152.
 */
package timeseriesweka.classifiers.ensembles.weightings;

import timeseriesweka.classifiers.ensembles.EnsembleModule;
import timeseriesweka.classifiers.ensembles.weightings.ModuleWeightingScheme;

public class ProportionalTrainAcc
extends ModuleWeightingScheme {
    protected double sumOfTrainAccs = 0.0;

    public ProportionalTrainAcc() {
        this.uniformWeighting = true;
        this.needTrainPreds = false;
    }

    @Override
    public void defineWeightings(EnsembleModule[] modules, int numClasses) {
        for (EnsembleModule m : modules) {
            this.sumOfTrainAccs += m.trainResults.acc;
        }
        for (EnsembleModule m : modules) {
            m.posteriorWeights = this.defineWeighting(m, numClasses);
        }
    }

    @Override
    public double[] defineWeighting(EnsembleModule module, int numClasses) {
        return this.makeUniformWeighting(module.trainResults.acc / this.sumOfTrainAccs, numClasses);
    }
}

