/*
 * Decompiled with CFR 0.152.
 */
package timeseriesweka.classifiers.ensembles.weightings;

import timeseriesweka.classifiers.ensembles.EnsembleModule;
import timeseriesweka.classifiers.ensembles.weightings.ModuleWeightingScheme;

public class FScore
extends ModuleWeightingScheme {
    double beta;

    public FScore() {
        this.beta = 1.0;
        this.uniformWeighting = false;
        this.needTrainPreds = true;
    }

    public FScore(double beta) {
        this.beta = beta;
        this.uniformWeighting = false;
        this.needTrainPreds = true;
    }

    @Override
    public double[] defineWeighting(EnsembleModule module, int numClasses) {
        double[] weights = new double[numClasses];
        for (int c = 0; c < numClasses; ++c) {
            weights[c] = this.computeFScore(module.trainResults.confusionMatrix, c);
        }
        return weights;
    }

    protected double computeFScore(double[][] confMat, int c) {
        double tp = confMat[c][c];
        if (tp == 0.0) {
            return 1.0E-7;
        }
        double fp = 0.0;
        double fn = 0.0;
        for (int i = 0; i < confMat.length; ++i) {
            if (i == c) continue;
            fp += confMat[i][c];
            fn += confMat[c][i];
        }
        double precision = tp / (tp + fp);
        double recall = tp / (tp + fn);
        return (1.0 + this.beta * this.beta) * (precision * recall) / (this.beta * this.beta * precision + recall);
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.beta + ")";
    }
}

