/*
 * Decompiled with CFR 0.152.
 */
package timeseriesweka.classifiers.ensembles.elastic_ensemble;

import java.io.File;
import java.io.FileWriter;
import java.util.Scanner;
import timeseriesweka.classifiers.ElasticEnsemble;
import timeseriesweka.classifiers.ensembles.elastic_ensemble.Efficient1NN;
import utilities.ClassifierTools;
import utilities.InstanceTools;
import weka.core.Instances;

public class ElasticEnsembleClusterDistributer {
    public static void scriptMaker_runCv(String datasetName, int resample, ElasticEnsemble.ConstituentClassifiers classifier, StringBuilder instructionBuilder) throws Exception {
        String theWholeMess = "#!/bin/csh\n\n#BSUB -q long-eth\n#BSUB -J runCv_" + datasetName + "_" + resample + "_" + (Object)((Object)classifier) + "[1-100]\n#BSUB -oo output/runCv_" + datasetName + "_" + resample + "_" + (Object)((Object)classifier) + "_%I.out\n#BSUB -eo error/runCv_" + datasetName + "_" + resample + "_" + (Object)((Object)classifier) + "_%I.err\n#BSUB -R \"rusage[mem=4000]\"\n#BSUB -M 4000\n\nmodule add java/jdk1.8.0_51\n\njava -jar -Xmx4000m TimeSeriesClassification.jar runCv " + datasetName + " " + resample + " " + (Object)((Object)classifier) + " $LSB_JOBINDEX";
        File outputDir = new File("scripts_eeCv/");
        outputDir.mkdirs();
        FileWriter out = new FileWriter("scripts_eeCv/" + datasetName + "_" + resample + "_" + (Object)((Object)classifier) + ".bsub");
        out.append(theWholeMess);
        out.close();
        if (instructionBuilder != null) {
            instructionBuilder.append("bsub < scripts_eeCv/").append(datasetName).append("_").append(resample).append("_").append((Object)classifier).append(".bsub\n");
        }
    }

    private static void runCv(Instances train, String dataName, int resampleIdentifier, ElasticEnsemble.ConstituentClassifiers classifier, int paramId) throws Exception {
        String resultsDir = "eeResults/";
        if ((classifier == ElasticEnsemble.ConstituentClassifiers.DDTW_R1_1NN || classifier == ElasticEnsemble.ConstituentClassifiers.DTW_R1_1NN || classifier == ElasticEnsemble.ConstituentClassifiers.Euclidean_1NN) && paramId > 0) {
            return;
        }
        Efficient1NN oneNN = ElasticEnsemble.getClassifier(classifier);
        oneNN.setIndividualCvFileWritingOn(resultsDir, dataName, resampleIdentifier);
        oneNN.loocvAccAndPreds(train, paramId);
    }

    private static void runCv_parseIndividualCvsForBest(String resultsDir, String dataName, int resampleId, ElasticEnsemble.ConstituentClassifiers measureType, boolean tidyUp) throws Exception {
        Scanner scan;
        String cvPath = resultsDir + (Object)((Object)measureType) + "/cv/" + dataName + "/trainFold" + resampleId + "/";
        String parsedPath = resultsDir + (Object)((Object)measureType) + "/Predictions/" + dataName + "/";
        String parsedName = parsedPath + "trainFold" + resampleId + ".csv";
        File existingParsed = new File(parsedName);
        if (existingParsed.exists() && existingParsed.length() > 0L) {
            if (tidyUp) {
                ElasticEnsembleClusterDistributer.deleteDir(new File(resultsDir + (Object)((Object)measureType) + "/cv/"));
            }
            return;
        }
        int expectedParams = measureType.equals((Object)ElasticEnsemble.ConstituentClassifiers.Euclidean_1NN) || measureType.equals((Object)ElasticEnsemble.ConstituentClassifiers.DTW_R1_1NN) || measureType.equals((Object)ElasticEnsemble.ConstituentClassifiers.DDTW_R1_1NN) ? 1 : 100;
        double bsfAcc = -1.0;
        File bsfParsed = null;
        for (int p = 0; p < expectedParams; ++p) {
            File individualCv = new File(cvPath + "pid" + p + ".csv");
            if (!individualCv.exists()) {
                throw new Exception("error: cv file does not exist - " + individualCv.getAbsolutePath());
            }
            scan = new Scanner(individualCv);
            scan.useDelimiter("\n");
            scan.next();
            scan.next();
            double acc = Double.parseDouble(scan.next().trim());
            scan.close();
            if (!(acc > bsfAcc)) continue;
            bsfAcc = acc;
            bsfParsed = new File(cvPath + "pid" + p + ".csv");
        }
        new File(parsedPath).mkdirs();
        scan = new Scanner(bsfParsed);
        scan.useDelimiter("\n");
        FileWriter out = new FileWriter(parsedName);
        while (scan.hasNext()) {
            out.append(scan.next() + "\n");
        }
        out.close();
        if (tidyUp) {
            ElasticEnsembleClusterDistributer.deleteDir(new File(resultsDir + (Object)((Object)measureType) + "/cv/"));
        }
    }

    public static void clusterMaster(String[] args) throws Exception {
        String arffDir = "Problems/";
        if (!args[0].equalsIgnoreCase("makeScripts")) {
            if (args[0].equalsIgnoreCase("runCv")) {
                String datasetName = args[1].trim();
                int resampleId = Integer.parseInt(args[2].trim());
                String classifier = args[3].trim();
                int paramId = Integer.parseInt(args[4].trim()) - 1;
                Instances train = ClassifierTools.loadData(arffDir + datasetName + "_TRAIN");
                ElasticEnsembleClusterDistributer.runCv(train, datasetName, resampleId, ElasticEnsemble.ConstituentClassifiers.valueOf(classifier), paramId);
            } else if (args[0].equalsIgnoreCase("parseCv")) {
                String datasetName = args[1].trim();
                String resultsDirName = args[2].trim();
                int resampleId = Integer.parseInt(args[3].trim());
                for (ElasticEnsemble.ConstituentClassifiers c : ElasticEnsemble.ConstituentClassifiers.values()) {
                    ElasticEnsembleClusterDistributer.runCv_parseIndividualCvsForBest(resultsDirName, datasetName, resampleId, c, true);
                }
            } else if (args[0].equalsIgnoreCase("buildEEandRunTest")) {
                String datasetName = args[1].trim();
                String resultsDirName = args[2].trim();
                String arffPath = args[3].trim();
                int resampleId = 0;
                Instances train = ClassifierTools.loadData(arffPath + datasetName + "/" + datasetName + "_TRAIN");
                Instances test = ClassifierTools.loadData(arffPath + datasetName + "/" + datasetName + "_TEST");
                if (args.length > 4) {
                    resampleId = Integer.parseInt(args[4].trim());
                    Instances[] temp = InstanceTools.resampleTrainAndTestInstances(train, test, resampleId);
                    train = temp[0];
                    test = temp[1];
                }
                ElasticEnsemble ee = new ElasticEnsemble(resultsDirName, datasetName, resampleId);
                ee.buildClassifier(train);
                ee.writeTestResultsToFile(test, datasetName, "EE", ee.getParameters(), resultsDirName + "EE/Predictions/" + datasetName + "/testFold" + resampleId + ".csv");
            } else {
                throw new Exception("Error: Unexpected operation - " + args[0]);
            }
        }
    }

    private static void deleteDir(File dir) {
        if (!dir.exists()) {
            return;
        }
        if (dir.isDirectory()) {
            File[] files;
            for (File file : files = dir.listFiles()) {
                ElasticEnsembleClusterDistributer.deleteDir(file);
            }
        }
        dir.delete();
    }

    public static void main(String[] args) throws Exception {
        if (args.length > 0) {
            ElasticEnsembleClusterDistributer.clusterMaster(args);
            return;
        }
        String problemName = "vowel_raw_sampled_10";
        StringBuilder instructionBuilder = new StringBuilder();
        for (ElasticEnsemble.ConstituentClassifiers c : ElasticEnsemble.ConstituentClassifiers.values()) {
            ElasticEnsembleClusterDistributer.scriptMaker_runCv(problemName, 0, c, instructionBuilder);
        }
        FileWriter out = new FileWriter("instructions_" + problemName + ".txt");
        out.append(instructionBuilder);
        out.close();
    }
}

