/*
 * Decompiled with CFR 0.152.
 */
package timeseriesweka.classifiers.ensembles;

import java.util.ArrayList;
import java.util.Random;
import timeseriesweka.classifiers.FastDTW_1NN;
import timeseriesweka.filters.ACF;
import timeseriesweka.filters.PowerSpectrum;
import weka.attributeSelection.PrincipalComponents;
import weka.classifiers.AbstractClassifier;
import weka.classifiers.Classifier;
import weka.classifiers.Evaluation;
import weka.classifiers.lazy.kNN;
import weka.core.Instance;
import weka.core.Instances;
import weka.filters.NormalizeAttribute;
import weka.filters.SimpleBatchFilter;

public class TransformEnsembles
extends AbstractClassifier {
    SimpleBatchFilter transform;
    Classifier[] classifiers;
    boolean useWeights = false;
    boolean normaliseAtts = false;
    ArrayList<Instances> train = new ArrayList();
    double[] transformWeights;
    double[] cvWeights;
    int numInstances;
    Classifier[] all;
    Classifier base = new kNN(1);
    Classifier baseTime = new FastDTW_1NN();
    PowerSpectrum ps;
    ACF acf;
    PrincipalComponents pca;
    NormalizeAttribute nPs;
    NormalizeAttribute nAcf;
    NormalizeAttribute nPca;
    ArrayList<double[][]> predictions = new ArrayList();
    static double CRITICAL = 2.32;
    int testPos = 0;
    int nosTransforms = 4;
    double weightPower = 1.0;
    boolean rebuild = true;
    private WeightType w = WeightType.EQUAL;
    private static final double THRESHOLD1 = 100.0;
    private static final double THRESHOLD2 = 1000.0;

    public void setWeightPower(double x) {
        this.weightPower = x;
    }

    public void rebuildClassifier(boolean x) {
        this.rebuild = x;
    }

    public void setWeightType(int x) {
        switch (x) {
            case 0: {
                this.w = WeightType.EQUAL;
                break;
            }
            case 1: {
                this.w = WeightType.CV;
                break;
            }
            case 2: {
                this.w = WeightType.BEST;
                break;
            }
            case 3: {
                this.w = WeightType.STEP;
            }
        }
    }

    public void setWeightType(WeightType x) {
        this.w = x;
    }

    public void setBaseClassifier(Classifier c) {
        this.base = c;
    }

    private void init(Instances data) {
        this.numInstances = data.numInstances();
        this.base = new kNN(1);
        this.train = new ArrayList();
        this.ps = new PowerSpectrum();
        this.acf = new ACF();
        this.acf.setMaxLag((int)((double)data.numAttributes() - (double)data.numAttributes() * 0.1));
        this.pca = new PrincipalComponents();
        this.predictions = new ArrayList();
    }

    public void findWeights() throws Exception {
        this.transformWeights = new double[this.nosTransforms];
        this.testPos = 0;
        switch (this.w) {
            case EQUAL: {
                for (int i = 0; i < this.nosTransforms; ++i) {
                    this.transformWeights[i] = 1.0 / (double)this.nosTransforms;
                }
                break;
            }
            case BEST: {
                int i;
                if (this.cvWeights == null) {
                    this.findCVWeights();
                }
                int max = 0;
                for (i = 1; i < this.cvWeights.length; ++i) {
                    if (!(this.cvWeights[i] > this.cvWeights[max])) continue;
                    max = i;
                }
                for (i = 0; i < this.transformWeights.length; ++i) {
                    this.transformWeights[i] = i == max ? 1.0 : 0.0;
                }
                System.out.print("Best Weight is ");
                switch (max) {
                    case 0: {
                        System.out.println("TIME");
                        break;
                    }
                    case 1: {
                        System.out.println("POWERSPECTRUM");
                        break;
                    }
                    case 2: {
                        System.out.println("ACF");
                        break;
                    }
                    case 3: {
                        System.out.println("PCA");
                    }
                }
                break;
            }
            case CV: {
                int i;
                System.out.println("CV Weights");
                if (this.cvWeights == null) {
                    this.findCVWeights();
                }
                double sum = 0.0;
                for (i = 0; i < this.cvWeights.length; ++i) {
                    sum += Math.pow(this.cvWeights[i], this.weightPower);
                }
                for (i = 0; i < this.cvWeights.length; ++i) {
                    this.transformWeights[i] = Math.pow(this.cvWeights[i], this.weightPower) / sum;
                }
                break;
            }
            case STEP: {
                int i;
                System.out.println("STEP Weights");
                if (this.cvWeights == null) {
                    this.findCVWeights();
                }
                int max = 0;
                for (int i2 = 1; i2 < this.cvWeights.length; ++i2) {
                    if (!(this.cvWeights[i2] > this.cvWeights[max])) continue;
                    max = i2;
                }
                int n = this.numInstances;
                double p = this.cvWeights[max];
                double q = 1.0 - p;
                double sd = p * q;
                sd /= (double)n;
                sd = Math.sqrt(sd);
                for (int j = 0; j < this.cvWeights.length; ++j) {
                    if (j == max) {
                        this.transformWeights[j] = Math.pow(this.cvWeights[j], this.weightPower);
                        continue;
                    }
                    double z = (this.cvWeights[max] - this.cvWeights[j]) / sd;
                    System.out.println(" Max trans =" + max + " z value for " + j + " = " + z);
                    this.transformWeights[j] = z < CRITICAL ? Math.pow(this.cvWeights[j], this.weightPower) : 0.0;
                }
                double sum = this.transformWeights[0];
                for (i = 1; i < this.transformWeights.length; ++i) {
                    sum += this.transformWeights[i];
                }
                i = 0;
                while (i < this.transformWeights.length) {
                    int n2 = i++;
                    this.transformWeights[n2] = this.transformWeights[n2] / sum;
                }
                break;
            }
        }
    }

    @Override
    public void buildClassifier(Instances data) throws Exception {
        if (this.rebuild) {
            System.out.println("Build whole ...");
            this.init(data);
            this.train.add(data);
            Instances t1 = this.ps.process(data);
            Instances t2 = this.acf.process(data);
            if (this.normaliseAtts) {
                this.nPs = new NormalizeAttribute(t1);
                t1 = this.nPs.process(t1);
                this.nAcf = new NormalizeAttribute(t2);
                t2 = this.nAcf.process(t2);
            }
            this.pca.buildEvaluator(data);
            Instances t3 = this.pca.transformedData(data);
            this.train.add(t1);
            this.train.add(t2);
            this.train.add(t3);
            this.nosTransforms = this.train.size();
            this.findWeights();
            this.all = AbstractClassifier.makeCopies(this.base, this.train.size());
            this.all[0] = AbstractClassifier.makeCopy(this.baseTime);
            for (int i = 0; i < this.all.length; ++i) {
                this.all[i].buildClassifier(this.train.get(i));
            }
        }
    }

    @Override
    public double[] distributionForInstance(Instance ins) throws Exception {
        Object preds;
        if (this.rebuild) {
            Instances temp2;
            preds = new double[this.nosTransforms][];
            if (this.all[0] != null) {
                preds[0] = this.all[0].distributionForInstance(ins);
            }
            Instances temp = new Instances(this.train.get(0), 0);
            temp.add(ins);
            if (this.all[1] != null) {
                temp2 = this.ps.process(temp);
                if (this.normaliseAtts) {
                    temp2 = this.nPs.process(temp2);
                }
                preds[1] = this.all[1].distributionForInstance(temp2.instance(0));
            }
            if (this.all[2] != null) {
                temp2 = this.acf.process(temp);
                if (this.normaliseAtts) {
                    temp2 = this.nAcf.process(temp2);
                }
                preds[2] = this.all[2].distributionForInstance(temp2.instance(0));
            }
            if (this.all[3] != null) {
                Instance t = this.pca.convertInstance(ins);
                preds[3] = this.all[3].distributionForInstance(t);
            }
            this.predictions.add((double[][])preds);
        } else {
            preds = this.predictions.get(this.testPos);
            ++this.testPos;
        }
        double[] dist = new double[ins.numClasses()];
        for (int i = 0; i < this.nosTransforms; ++i) {
            if (!(this.transformWeights[i] > 0.0)) continue;
            for (int j = 0; j < dist.length; ++j) {
                int n = j;
                dist[n] = dist[n] + this.transformWeights[i] * preds[i][j];
            }
        }
        return dist;
    }

    public void findCVWeights() throws Exception {
        this.cvWeights = new double[this.nosTransforms];
        int folds = this.numInstances;
        if ((double)folds > 100.0) {
            folds = 10;
        }
        System.out.print("\n Finding CV Accuracy: ");
        for (int i = 0; i < this.nosTransforms; ++i) {
            Evaluation evaluation = new Evaluation(this.train.get(i));
            if (i == 0) {
                evaluation.crossValidateModel(AbstractClassifier.makeCopy(this.baseTime), this.train.get(i), folds, new Random(), new Object[0]);
            } else {
                evaluation.crossValidateModel(AbstractClassifier.makeCopy(this.base), this.train.get(i), folds, new Random(), new Object[0]);
            }
            this.cvWeights[i] = 1.0 - evaluation.errorRate();
            System.out.print("," + this.cvWeights[i]);
        }
        System.out.print("\n");
    }

    public String getWeights() {
        String str = "";
        for (int i = 0; i < this.transformWeights.length; ++i) {
            str = str + this.transformWeights[i] + ",";
        }
        return str;
    }

    public String getCV() {
        String str = "";
        for (int i = 0; i < this.cvWeights.length; ++i) {
            str = str + this.cvWeights[i] + ",";
        }
        return str;
    }

    @Override
    public String getRevision() {
        return null;
    }

    public static void main(String[] args) {
    }

    public static enum WeightType {
        EQUAL,
        CV,
        BEST,
        STEP;

    }

    static enum TransformType {
        TIME,
        PS,
        ACF;

    }
}

