/*
 * Decompiled with CFR 0.152.
 */
package timeseriesweka.classifiers.cote;

import java.util.ArrayList;
import timeseriesweka.classifiers.cote.AbstractPostProcessedCote;
import utilities.ClassifierTools;
import weka.core.Instances;

public class HiveCotePostProcessed
extends AbstractPostProcessedCote {
    public HiveCotePostProcessed(String resultsDir, String datasetName, int resampleId, ArrayList<String> classifierNames) {
        CLASSIFIER_NAME = "HIVE-COTE";
        this.resultsDir = resultsDir;
        this.datasetName = datasetName;
        this.resampleId = resampleId;
        this.classifierNames = classifierNames;
    }

    public HiveCotePostProcessed(String resultsDir, String datasetName, ArrayList<String> classifierNames) {
        CLASSIFIER_NAME = "HIVE-COTE";
        this.resultsDir = resultsDir;
        this.datasetName = datasetName;
        this.resampleId = 0;
        this.classifierNames = classifierNames;
    }

    public HiveCotePostProcessed(String resultsDir, String datasetName, int resampleId) {
        CLASSIFIER_NAME = "HIVE-COTE";
        this.resultsDir = resultsDir;
        this.datasetName = datasetName;
        this.resampleId = resampleId;
        this.classifierNames = this.getDefaultClassifierNames();
    }

    public HiveCotePostProcessed(String resultsDir, String datasetName) {
        CLASSIFIER_NAME = "HIVE-COTE";
        this.resultsDir = resultsDir;
        this.datasetName = datasetName;
        this.resampleId = 0;
        this.classifierNames = this.getDefaultClassifierNames();
    }

    private ArrayList<String> getDefaultClassifierNames() {
        ArrayList<String> names = new ArrayList<String>();
        names.add("EE");
        names.add("ST");
        names.add("RISE");
        names.add("BOSS");
        names.add("TSF");
        return names;
    }

    @Override
    public double[] distributionForInstance(int testInstanceId) throws Exception {
        if (this.testDists == null) {
            throw new Exception("Error: classifier not initialised correctly. Load results before classifiying.");
        }
        int numClasses = this.testDists[0][0].length;
        double[] outDist = new double[numClasses];
        double cvAccSum = 0.0;
        for (int classifier = 0; classifier < this.testDists.length; ++classifier) {
            for (int classVal = 0; classVal < numClasses; ++classVal) {
                int n = classVal;
                outDist[n] = outDist[n] + this.testDists[classifier][testInstanceId][classVal] * this.cvAccs[classifier];
            }
            cvAccSum += this.cvAccs[classifier];
        }
        int classVal = 0;
        while (classVal < numClasses) {
            int n = classVal++;
            outDist[n] = outDist[n] / cvAccSum;
        }
        return outDist;
    }

    public static void main(String[] args) throws Exception {
        String datasetName = "ItalyPowerDemand";
        Instances train = ClassifierTools.loadData("C:/users/sjx07ngu/dropbox/tsc problems/" + datasetName + "/" + datasetName + "_TRAIN");
        Instances test = ClassifierTools.loadData("C:/users/sjx07ngu/dropbox/tsc problems/" + datasetName + "/" + datasetName + "_TEST");
        HiveCotePostProcessed hcpp = new HiveCotePostProcessed("hiveWritingProto/", datasetName);
        hcpp.writeTestSheet("hiveWritingProtoRewrite/");
    }
}

