/*
 * Decompiled with CFR 0.152.
 */
package timeseriesweka.classifiers;

import development.DataSets;
import fileIO.OutFile;
import java.io.FileInputStream;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.text.DecimalFormat;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.Random;
import java.util.Vector;
import timeseriesweka.classifiers.AbstractClassifierWithTrainingData;
import timeseriesweka.classifiers.ParameterSplittable;
import utilities.ClassifierTools;
import weka.classifiers.AbstractClassifier;
import weka.classifiers.Classifier;
import weka.classifiers.Evaluation;
import weka.classifiers.rules.ZeroR;
import weka.core.Attribute;
import weka.core.Capabilities;
import weka.core.ContingencyTables;
import weka.core.DenseInstance;
import weka.core.Drawable;
import weka.core.FastVector;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.PartitionGenerator;
import weka.core.Randomizable;
import weka.core.RevisionUtils;
import weka.core.TechnicalInformation;
import weka.core.Utils;
import weka.core.WeightedInstancesHandler;

public class LPS
extends AbstractClassifierWithTrainingData
implements ParameterSplittable {
    RandomRegressionTree[] trees;
    public static final int PARASEARCH_NOS_TREES = 25;
    public static final int DEFAULT_NOS_TREES = 200;
    int nosTrees = 200;
    int nosSegments = 20;
    double[] ratioLevels = new double[]{0.01, 0.1, 0.25, 0.5};
    double[] segmentProps = new double[]{0.05, 0.1, 0.25, 0.5, 0.75, 0.95};
    double segmentProp = this.segmentProps[0];
    double ratioLevel = this.ratioLevels[0];
    int[] treeDepths = new int[]{2, 4, 6};
    int treeDepth = this.treeDepths[2];
    int[] segLengths;
    int[][] segStarts;
    int[][] segDiffStarts;
    Instances sequences;
    int[] nosLeafNodes;
    int[][][] leafNodeCounts;
    double[] trainClassVals;
    int[] classAtt;
    boolean paramSearch = true;
    double acc = 0.0;
    public static String[] problems = new String[]{"Adiac", "ArrowHead", "Beef", "BeetleFly", "BirdChicken", "Car", "CBF", "ChlorineConcentration", "CinCECGtorso", "Coffee", "Computers", "CricketX", "CricketY", "CricketZ", "DiatomSizeReduction", "DistalPhalanxOutlineAgeGroup", "DistalPhalanxOutlineCorrect", "DistalPhalanxTW", "Earthquakes", "ECGFiveDays", "ElectricDevices", "FaceAll", "FaceFour", "FacesUCR", "Fiftywords", "Fish", "FordA", "FordB", "GunPoint", "Haptics", "Herring", "InlineSkate", "ItalyPowerDemand", "LargeKitchenAppliances", "Lightning2", "Lightning7", "Mallat", "MedicalImages", "MiddlePhalanxOutlineAgeGroup", "MiddlePhalanxOutlineCorrect", "MiddlePhalanxTW", "MoteStrain", "NonInvasiveFatalECGThorax1", "NonInvasiveFatalECGThorax2", "OliveOil", "OSULeaf", "PhalangesOutlinesCorrect", "Plane", "ProximalPhalanxOutlineAgeGroup", "ProximalPhalanxOutlineCorrect", "ProximalPhalanxTW", "RefrigerationDevices", "ScreenType", "ShapeletSim", "ShapesAll", "SmallKitchenAppliances", "SonyAIBORobotSurface1", "SonyAIBORobotSurface2", "StarLightCurves", "SwedishLeaf", "Symbols", "SyntheticControl", "ToeSegmentation1", "ToeSegmentation2", "Trace", "TwoLeadECG", "TwoPatterns", "UWaveGestureLibraryX", "UWaveGestureLibraryY", "UWaveGestureLibraryZ", "UWaveGestureLibraryAll", "Wafer", "WordSynonyms", "Yoga"};
    static double[] reportedResults = new double[]{0.211, 0.2, 0.367, 0.15, 0.05, 0.183, 0.002, 0.352, 0.064, 0.071, 0.136, 0.282, 0.208, 0.305, 0.049, 0.237, 0.234, 0.327, 0.331, 0.155, 0.273, 0.242, 0.04, 0.098, 0.213, 0.094, 0.09, 0.223, 0.0, 0.562, 0.398, 0.494, 0.053, 0.157, 0.197, 0.411, 0.093, 0.297, 0.523, 0.208, 0.497, 0.114, 0.183, 0.147, 0.133, 0.134, 0.226, 0.0, 0.112, 0.172, 0.278, 0.329, 0.44, 0.006, 0.218, 0.225, 0.225, 0.123, 0.033, 0.072, 0.03, 0.027, 0.077, 0.1, 0.02, 0.061, 0.014, 0.189, 0.263, 0.253, 0.025, 0.001, 0.27, 0.136};

    public LPS() {
        this.trees = new RandomRegressionTree[this.nosTrees];
    }

    public String globalInfo() {
        return "Blah";
    }

    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation result = new TechnicalInformation(TechnicalInformation.Type.ARTICLE);
        result.setValue(TechnicalInformation.Field.AUTHOR, "M. Baydogan and G. Runger");
        result.setValue(TechnicalInformation.Field.YEAR, "2016");
        result.setValue(TechnicalInformation.Field.TITLE, "Time series representation and similarity based on local\nautopatterns");
        result.setValue(TechnicalInformation.Field.JOURNAL, "Data Mining and Knowledge Discovery");
        result.setValue(TechnicalInformation.Field.VOLUME, "30");
        result.setValue(TechnicalInformation.Field.NUMBER, "2");
        result.setValue(TechnicalInformation.Field.PAGES, "476-509");
        return result;
    }

    public static void compareToPublished() throws Exception {
        DecimalFormat df = new DecimalFormat("###.###");
        OutFile res = new OutFile(DataSets.path + "recreatedLPS.csv");
        int b = 0;
        int t = 0;
        System.out.println("problem,recreated,published");
        for (int i = 0; i < problems.length; ++i) {
            String s = problems[i];
            System.out.print(s + ",");
            Instances train = ClassifierTools.loadData("C:\\Users\\ajb\\Dropbox\\TSC Problems\\" + s + "\\" + s + "_TRAIN.arff");
            Instances test = ClassifierTools.loadData("C:\\Users\\ajb\\Dropbox\\TSC Problems\\" + s + "\\" + s + "_TEST.arff");
            LPS l = new LPS();
            l.setParamSearch(false);
            l.buildClassifier(train);
            double a = ClassifierTools.accuracy(test, l);
            System.out.println(df.format(1.0 - a) + "," + df.format(reportedResults[i]) + "," + df.format(1.0 - a - reportedResults[i]));
            if (1.0 - a < reportedResults[i]) {
                ++b;
            }
            if (1.0 - a == reportedResults[i]) {
                ++t;
            }
            res.writeLine(s + "," + (1.0 - a) + "," + reportedResults[i]);
        }
        System.out.println("Reported better =" + (problems.length - t - b) + " ties =" + t + " ours better = " + b);
    }

    @Override
    public void setParamSearch(boolean b) {
        this.paramSearch = b;
    }

    @Override
    public void setParametersFromIndex(int x) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String getParas() {
        return this.ratioLevel + "," + this.treeDepth;
    }

    @Override
    public double getAcc() {
        return this.acc;
    }

    @Override
    public void buildClassifier(Instances data) throws Exception {
        int j;
        this.trainResults.buildTime = System.currentTimeMillis();
        if (this.paramSearch) {
            double bestErr = 1.0;
            int bestRatio = 0;
            int bestTreeDepth = 0;
            LPS trainer = new LPS();
            trainer.nosTrees = 50;
            trainer.setParamSearch(false);
            int folds = 10;
            for (int i = 0; i < this.ratioLevels.length; ++i) {
                trainer.ratioLevel = this.ratioLevels[i];
                for (j = 0; j < this.treeDepths.length; ++j) {
                    trainer.treeDepth = this.treeDepths[j];
                    Evaluation eval = new Evaluation(data);
                    eval.crossValidateModel(trainer, data, folds, new Random(), new Object[0]);
                    double e = eval.errorRate();
                    if (!(e < bestErr)) continue;
                    bestErr = e;
                    bestTreeDepth = j;
                    bestRatio = i;
                }
            }
            this.ratioLevel = this.ratioLevels[bestRatio];
            this.treeDepth = this.treeDepths[bestTreeDepth];
            System.out.println("Best ratio level =" + this.ratioLevel + " best tree depth =" + this.treeDepth + " with CV error =" + bestErr);
        }
        int seriesLength = data.numAttributes() - 1;
        int minSegment = (int)((double)seriesLength * 0.1);
        int maxSegment = (int)((double)seriesLength * 0.9);
        this.segLengths = new int[this.nosTrees];
        this.nosLeafNodes = new int[this.nosTrees];
        this.segStarts = new int[this.nosTrees][this.nosSegments];
        this.segDiffStarts = new int[this.nosTrees][this.nosSegments];
        this.leafNodeCounts = new int[data.numInstances()][this.nosTrees][];
        this.trainClassVals = new double[data.numInstances()];
        for (int i = 0; i < data.numInstances(); ++i) {
            this.trainClassVals[i] = data.instance(i).classValue();
        }
        this.classAtt = new int[this.nosTrees];
        Random r = new Random();
        for (int i = 0; i < this.nosTrees; ++i) {
            this.segLengths[i] = minSegment + r.nextInt(maxSegment - minSegment);
            for (int j2 = 0; j2 < this.nosSegments; ++j2) {
                this.segStarts[i][j2] = r.nextInt(seriesLength - this.segLengths[i]);
                this.segDiffStarts[i][j2] = r.nextInt(seriesLength - this.segLengths[i] - 1);
            }
            FastVector<Attribute> atts = new FastVector<Attribute>();
            for (j = 0; j < 2 * this.nosSegments; ++j) {
                String name = "SegFeature" + j;
                atts.addElement(new Attribute(name));
            }
            this.sequences = new Instances("SubsequenceIntervals", atts, this.segLengths[i] * data.numInstances());
            for (j = 0; j < data.numInstances(); ++j) {
                Instance series = data.instance(j);
                for (int k = 0; k < this.segLengths[i]; ++k) {
                    int m;
                    DenseInstance in = new DenseInstance(this.sequences.numAttributes());
                    for (m = 0; m < this.nosSegments; ++m) {
                        in.setValue(m, series.value(this.segStarts[i][m] + k));
                    }
                    for (m = 0; m < this.nosSegments; ++m) {
                        in.setValue(this.nosSegments + m, series.value(this.segDiffStarts[i][m] + k) - series.value(this.segDiffStarts[i][m] + k + 1));
                    }
                    this.sequences.add(in);
                }
            }
            this.classAtt[i] = r.nextInt(this.sequences.numAttributes());
            this.sequences.setClassIndex(this.classAtt[i]);
            this.trees[i] = new RandomRegressionTree();
            this.trees[i].setMaxDepth(this.treeDepth);
            this.trees[i].setKValue(1);
            this.trees[i].setMinNum((int)((double)this.sequences.numInstances() * this.ratioLevel));
            this.trees[i].buildClassifier(this.sequences);
            this.nosLeafNodes[i] = this.trees[i].nosLeafNodes;
            for (j = 0; j < data.numInstances(); ++j) {
                this.leafNodeCounts[j][i] = new int[this.trees[i].nosLeafNodes];
                for (int k = 0; k < this.segLengths[i]; ++k) {
                    this.trees[i].distributionForInstance(this.sequences.instance(j * this.segLengths[i] + k));
                    int leafID = RandomRegressionTree.lastNode;
                    int[] nArray = this.leafNodeCounts[j][i];
                    int n = leafID;
                    nArray[n] = nArray[n] + 1;
                }
            }
        }
        this.sequences = null;
        this.trainResults.buildTime = System.currentTimeMillis() - this.trainResults.buildTime;
        System.gc();
    }

    public double distance(int[][] test, int[][] train) {
        double d = 0.0;
        for (int i = 0; i < test.length; ++i) {
            for (int j = 0; j < test[i].length; ++j) {
                double x = test[i][j] - train[i][j];
                if (x > 0.0) {
                    d += x;
                    continue;
                }
                d += -x;
            }
        }
        return d;
    }

    @Override
    public double classifyInstance(Instance ins) throws Exception {
        int[][] testNodeCounts = new int[this.nosTrees][];
        for (int i = 0; i < this.nosTrees; ++i) {
            int k;
            FastVector<Attribute> atts = new FastVector<Attribute>();
            for (int j = 0; j < 2 * this.nosSegments; ++j) {
                String name = "SegFeature" + j;
                atts.addElement(new Attribute(name));
            }
            this.sequences = new Instances("SubsequenceIntervals", atts, this.segLengths[i]);
            for (k = 0; k < this.segLengths[i]; ++k) {
                int m;
                DenseInstance in = new DenseInstance(this.sequences.numAttributes());
                for (m = 0; m < this.nosSegments; ++m) {
                    in.setValue(m, ins.value(this.segStarts[i][m] + k));
                }
                for (m = 0; m < this.nosSegments; ++m) {
                    in.setValue(this.nosSegments + m, ins.value(this.segDiffStarts[i][m] + k) - ins.value(this.segDiffStarts[i][m] + k + 1));
                }
                this.sequences.add(in);
            }
            this.sequences.setClassIndex(this.classAtt[i]);
            testNodeCounts[i] = new int[this.trees[i].nosLeafNodes];
            for (k = 0; k < this.sequences.numInstances(); ++k) {
                this.trees[i].distributionForInstance(this.sequences.instance(k));
                int leafID = RandomRegressionTree.lastNode;
                int[] nArray = testNodeCounts[i];
                int n = leafID;
                nArray[n] = nArray[n] + 1;
            }
        }
        double minDist = Double.MAX_VALUE;
        int closest = 0;
        for (int i = 0; i < this.leafNodeCounts.length; ++i) {
            double d = this.distance(testNodeCounts, this.leafNodeCounts[i]);
            if (!(d < minDist)) continue;
            minDist = d;
            closest = i;
        }
        return this.trainClassVals[closest];
    }

    public static Object readFromFile(String filename) {
        Object obj = null;
        try {
            FileInputStream fis = new FileInputStream(filename);
            ObjectInputStream in = new ObjectInputStream(fis);
            obj = in.readObject();
            in.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return obj;
    }

    public static void main(String[] args) throws Exception {
        LPS l = new LPS();
        l.setParamSearch(false);
        String prob = "ItalyPowerDemand";
        double mean = 0.0;
        Instances train = ClassifierTools.loadData("C:\\Users\\ajb\\Dropbox\\TSC Problems\\" + prob + "\\" + prob + "_TRAIN.arff");
        Instances test = ClassifierTools.loadData("C:\\Users\\ajb\\Dropbox\\TSC Problems\\" + prob + "\\" + prob + "_TEST.arff");
        l.buildClassifier(train);
        double a = ClassifierTools.accuracy(test, l);
        System.out.println("test prob accuracy = " + a);
    }

    public void debugFeatureExtraction() {
        int i;
        FastVector<Attribute> atts2 = new FastVector<Attribute>();
        for (int j = 0; j < 9; ++j) {
            atts2.addElement(new Attribute("SegFeature" + j));
        }
        double[] t1 = new double[]{1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0};
        double[] t2 = new double[]{8.0, 7.0, 6.0, 5.0, 4.0, 3.0, 2.0, 1.0};
        Instances data = new Instances("SubsequenceIntervals", atts2, 2);
        DenseInstance ins = new DenseInstance(data.numAttributes());
        for (i = 0; i < t1.length; ++i) {
            ins.setValue(i, t1[i]);
        }
        data.add(ins);
        ins = new DenseInstance(data.numAttributes());
        for (i = 0; i < t2.length; ++i) {
            ins.setValue(i, t2[i]);
        }
        data.add(ins);
        System.out.println("TEST DATA =" + data);
        this.nosSegments = 2;
        this.nosTrees = 1;
        int seriesLength = data.numAttributes() - 1;
        int minSegment = (int)((double)seriesLength * 0.1);
        int maxSegment = (int)((double)seriesLength * 0.9);
        this.segLengths = new int[this.nosTrees];
        this.segStarts = new int[this.nosTrees][this.nosSegments];
        this.segDiffStarts = new int[this.nosTrees][this.nosSegments];
        Random r = new Random();
        for (int i2 = 0; i2 < this.nosTrees; ++i2) {
            this.segLengths[i2] = minSegment + r.nextInt(maxSegment - minSegment);
            this.segLengths[i2] = 3;
            System.out.println("SEG LENGTH =" + this.segLengths[i2]);
            int target = r.nextInt(2 * this.nosSegments);
            for (int j = 0; j < this.nosSegments; ++j) {
                this.segStarts[i2][j] = r.nextInt(seriesLength - this.segLengths[i2]);
                this.segDiffStarts[i2][j] = r.nextInt(seriesLength - this.segLengths[i2] - 1);
                System.out.println("SEG START =" + this.segStarts[i2][j]);
                System.out.println("SEG DIFF START =" + this.segDiffStarts[i2][j]);
            }
            Object tr = null;
            FastVector<Attribute> atts = new FastVector<Attribute>();
            for (int j = 0; j < 2 * this.nosSegments; ++j) {
                String name = "SegFeature" + j;
                atts.addElement(new Attribute(name));
            }
            Instances result = new Instances("SubsequenceIntervals", atts, this.segLengths[i2] * data.numInstances());
            for (int j = 0; j < data.numInstances(); ++j) {
                Instance series = data.instance(j);
                for (int k = 0; k < this.segLengths[i2]; ++k) {
                    int m;
                    DenseInstance in = new DenseInstance(result.numAttributes());
                    for (m = 0; m < this.nosSegments; ++m) {
                        in.setValue(m, series.value(this.segStarts[i2][m] + k));
                    }
                    for (m = 0; m < this.nosSegments; ++m) {
                        in.setValue(this.nosSegments + m, series.value(this.segDiffStarts[i2][m] + k) - series.value(this.segDiffStarts[i2][m] + k + 1));
                    }
                    result.add(in);
                }
            }
            System.out.println("DESIRED OUTPUT : ");
            System.out.println("2,4\n3,5\n4,6\n7,5\n6,4\n5,3");
            System.out.println("TRANSFORMED INSTANCES =" + result);
        }
    }

    public static class RandomRegressionTree
    extends AbstractClassifier
    implements OptionHandler,
    WeightedInstancesHandler,
    Randomizable,
    Drawable,
    PartitionGenerator {
        private static final long serialVersionUID = -9051119597407396024L;
        protected Tree m_Tree = null;
        protected Instances m_Info = null;
        protected double m_MinNum = 1.0;
        protected int m_KValue = 0;
        protected int m_randomSeed = 1;
        protected int m_MaxDepth = 0;
        protected int m_NumFolds = 0;
        protected boolean m_AllowUnclassifiedInstances = false;
        protected boolean m_BreakTiesRandomly = false;
        protected Classifier m_zeroR;
        protected double m_MinVarianceProp = 0.001;
        public int nosLeafNodes = 0;
        public static int nodeCount = 0;
        public static int lastNode = 0;

        public String globalInfo() {
            return "Class for constructing a tree that considers K randomly  chosen attributes at each node. Performs no pruning. Also has an option to allow estimation of class probabilities (or target mean in the regression case) based on a hold-out set (backfitting).";
        }

        public String minNumTipText() {
            return "The minimum total weight of the instances in a leaf.";
        }

        public double getMinNum() {
            return this.m_MinNum;
        }

        public void setMinNum(double newMinNum) {
            this.m_MinNum = newMinNum;
        }

        public String minVariancePropTipText() {
            return "The minimum proportion of the variance on all the data that needs to be present at a node in order for splitting to be performed in regression trees.";
        }

        public double getMinVarianceProp() {
            return this.m_MinVarianceProp;
        }

        public void setMinVarianceProp(double newMinVarianceProp) {
            this.m_MinVarianceProp = newMinVarianceProp;
        }

        public String KValueTipText() {
            return "Sets the number of randomly chosen attributes. If 0, int(log_2(#predictors) + 1) is used.";
        }

        public int getKValue() {
            return this.m_KValue;
        }

        public void setKValue(int k) {
            this.m_KValue = k;
        }

        public String seedTipText() {
            return "The random number seed used for selecting attributes.";
        }

        @Override
        public void setSeed(int seed) {
            this.m_randomSeed = seed;
        }

        @Override
        public int getSeed() {
            return this.m_randomSeed;
        }

        public String maxDepthTipText() {
            return "The maximum depth of the tree, 0 for unlimited.";
        }

        public int getMaxDepth() {
            return this.m_MaxDepth;
        }

        public void setMaxDepth(int value) {
            this.m_MaxDepth = value;
        }

        public String numFoldsTipText() {
            return "Determines the amount of data used for backfitting. One fold is used for backfitting, the rest for growing the tree. (Default: 0, no backfitting)";
        }

        public int getNumFolds() {
            return this.m_NumFolds;
        }

        public void setNumFolds(int newNumFolds) {
            this.m_NumFolds = newNumFolds;
        }

        public String allowUnclassifiedInstancesTipText() {
            return "Whether to allow unclassified instances.";
        }

        public boolean getAllowUnclassifiedInstances() {
            return this.m_AllowUnclassifiedInstances;
        }

        public void setAllowUnclassifiedInstances(boolean newAllowUnclassifiedInstances) {
            this.m_AllowUnclassifiedInstances = newAllowUnclassifiedInstances;
        }

        public String breakTiesRandomlyTipText() {
            return "Break ties randomly when several attributes look equally good.";
        }

        public boolean getBreakTiesRandomly() {
            return this.m_BreakTiesRandomly;
        }

        public void setBreakTiesRandomly(boolean newBreakTiesRandomly) {
            this.m_BreakTiesRandomly = newBreakTiesRandomly;
        }

        @Override
        public Enumeration<Option> listOptions() {
            Vector<Option> newVector = new Vector<Option>();
            newVector.addElement(new Option("\tNumber of attributes to randomly investigate.\t(default 0)\n\t(<0 = int(log_2(#predictors)+1)).", "K", 1, "-K <number of attributes>"));
            newVector.addElement(new Option("\tSet minimum number of instances per leaf.\n\t(default 1)", "M", 1, "-M <minimum number of instances>"));
            newVector.addElement(new Option("\tSet minimum numeric class variance proportion\n\tof train variance for split (default 1e-3).", "V", 1, "-V <minimum variance for split>"));
            newVector.addElement(new Option("\tSeed for random number generator.\n\t(default 1)", "S", 1, "-S <num>"));
            newVector.addElement(new Option("\tThe maximum depth of the tree, 0 for unlimited.\n\t(default 0)", "depth", 1, "-depth <num>"));
            newVector.addElement(new Option("\tNumber of folds for backfitting (default 0, no backfitting).", "N", 1, "-N <num>"));
            newVector.addElement(new Option("\tAllow unclassified instances.", "U", 0, "-U"));
            newVector.addElement(new Option("\t" + this.breakTiesRandomlyTipText(), "B", 0, "-B"));
            newVector.addAll(Collections.list(super.listOptions()));
            return newVector.elements();
        }

        @Override
        public String[] getOptions() {
            Vector<String> result = new Vector<String>();
            result.add("-K");
            result.add("" + this.getKValue());
            result.add("-M");
            result.add("" + this.getMinNum());
            result.add("-V");
            result.add("" + this.getMinVarianceProp());
            result.add("-S");
            result.add("" + this.getSeed());
            if (this.getMaxDepth() > 0) {
                result.add("-depth");
                result.add("" + this.getMaxDepth());
            }
            if (this.getNumFolds() > 0) {
                result.add("-N");
                result.add("" + this.getNumFolds());
            }
            if (this.getAllowUnclassifiedInstances()) {
                result.add("-U");
            }
            if (this.getBreakTiesRandomly()) {
                result.add("-B");
            }
            Collections.addAll(result, super.getOptions());
            return result.toArray(new String[result.size()]);
        }

        @Override
        public void setOptions(String[] options) throws Exception {
            String tmpStr = Utils.getOption('K', options);
            this.m_KValue = tmpStr.length() != 0 ? Integer.parseInt(tmpStr) : 0;
            tmpStr = Utils.getOption('M', options);
            this.m_MinNum = tmpStr.length() != 0 ? Double.parseDouble(tmpStr) : 1.0;
            String minVarString = Utils.getOption('V', options);
            this.m_MinVarianceProp = minVarString.length() != 0 ? Double.parseDouble(minVarString) : 0.001;
            tmpStr = Utils.getOption('S', options);
            if (tmpStr.length() != 0) {
                this.setSeed(Integer.parseInt(tmpStr));
            } else {
                this.setSeed(1);
            }
            tmpStr = Utils.getOption("depth", options);
            if (tmpStr.length() != 0) {
                this.setMaxDepth(Integer.parseInt(tmpStr));
            } else {
                this.setMaxDepth(0);
            }
            String numFoldsString = Utils.getOption('N', options);
            this.m_NumFolds = numFoldsString.length() != 0 ? Integer.parseInt(numFoldsString) : 0;
            this.setAllowUnclassifiedInstances(Utils.getFlag('U', options));
            this.setBreakTiesRandomly(Utils.getFlag('B', options));
            super.setOptions(options);
            Utils.checkForRemainingOptions(options);
        }

        @Override
        public Capabilities getCapabilities() {
            Capabilities result = super.getCapabilities();
            result.disableAll();
            result.enable(Capabilities.Capability.NOMINAL_ATTRIBUTES);
            result.enable(Capabilities.Capability.NUMERIC_ATTRIBUTES);
            result.enable(Capabilities.Capability.DATE_ATTRIBUTES);
            result.enable(Capabilities.Capability.MISSING_VALUES);
            result.enable(Capabilities.Capability.NOMINAL_CLASS);
            result.enable(Capabilities.Capability.NUMERIC_CLASS);
            result.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
            return result;
        }

        @Override
        public void buildClassifier(Instances data) throws Exception {
            nodeCount = 0;
            this.nosLeafNodes = 0;
            if (this.m_KValue > data.numAttributes() - 1) {
                this.m_KValue = data.numAttributes() - 1;
            }
            if (this.m_KValue < 1) {
                this.m_KValue = (int)Utils.log2(data.numAttributes() - 1) + 1;
            }
            this.getCapabilities().testWithFail(data);
            data = new Instances(data);
            data.deleteWithMissingClass();
            if (data.numAttributes() == 1) {
                System.err.println("Cannot build model (only class attribute present in data!), using ZeroR model instead!");
                this.m_zeroR = new ZeroR();
                this.m_zeroR.buildClassifier(data);
                return;
            }
            this.m_zeroR = null;
            Instances train = null;
            Instances backfit = null;
            Random rand = data.getRandomNumberGenerator(this.m_randomSeed);
            if (this.m_NumFolds <= 0) {
                train = data;
            } else {
                data.randomize(rand);
                data.stratify(this.m_NumFolds);
                train = data.trainCV(this.m_NumFolds, 1, rand);
                backfit = data.testCV(this.m_NumFolds, 1);
            }
            int[] attIndicesWindow = new int[data.numAttributes() - 1];
            int j = 0;
            for (int i = 0; i < attIndicesWindow.length; ++i) {
                if (j == data.classIndex()) {
                    // empty if block
                }
                int n = ++j;
                ++j;
                attIndicesWindow[i] = n;
            }
            double totalWeight = 0.0;
            double totalSumSquared = 0.0;
            double[] classProbs = new double[train.numClasses()];
            for (int i = 0; i < train.numInstances(); ++i) {
                Instance inst = train.instance(i);
                if (data.classAttribute().isNominal()) {
                    int n = (int)inst.classValue();
                    classProbs[n] = classProbs[n] + inst.weight();
                    totalWeight += inst.weight();
                    continue;
                }
                classProbs[0] = classProbs[0] + inst.classValue() * inst.weight();
                totalSumSquared += inst.classValue() * inst.classValue() * inst.weight();
                totalWeight += inst.weight();
            }
            double trainVariance = 0.0;
            if (data.classAttribute().isNumeric()) {
                trainVariance = RandomRegressionTree.singleVariance(classProbs[0], totalSumSquared, totalWeight) / totalWeight;
                classProbs[0] = classProbs[0] / totalWeight;
            }
            this.m_Tree = new Tree();
            this.m_Info = new Instances(data, 0);
            this.m_Tree.buildTree(train, classProbs, attIndicesWindow, totalWeight, rand, 0, this.m_MinVarianceProp * trainVariance);
            if (backfit != null) {
                this.m_Tree.backfitData(backfit);
            }
        }

        @Override
        public double[] distributionForInstance(Instance instance) throws Exception {
            if (this.m_zeroR != null) {
                return this.m_zeroR.distributionForInstance(instance);
            }
            return this.m_Tree.distributionForInstance(instance);
        }

        public String toString() {
            if (this.m_zeroR != null) {
                StringBuffer buf = new StringBuffer();
                buf.append(this.getClass().getName().replaceAll(".*\\.", "") + "\n");
                buf.append(this.getClass().getName().replaceAll(".*\\.", "").replaceAll(".", "=") + "\n\n");
                buf.append("Warning: No model could be built, hence ZeroR model is used:\n\n");
                buf.append(this.m_zeroR.toString());
                return buf.toString();
            }
            if (this.m_Tree == null) {
                return "RandomTree: no model has been built yet.";
            }
            return "\nRandomTree\n==========\n" + this.m_Tree.toString(0) + "\n\nSize of the tree : " + this.m_Tree.numNodes() + (this.getMaxDepth() > 0 ? "\nMax depth of tree: " + this.getMaxDepth() : "");
        }

        @Override
        public String graph() throws Exception {
            if (this.m_Tree == null) {
                throw new Exception("RandomTree: No model built yet.");
            }
            StringBuffer resultBuff = new StringBuffer();
            this.m_Tree.toGraph(resultBuff, 0, null);
            String result = "digraph RandomTree {\nedge [style=bold]\n" + resultBuff.toString() + "\n}\n";
            return result;
        }

        @Override
        public int graphType() {
            return 1;
        }

        @Override
        public void generatePartition(Instances data) throws Exception {
            this.buildClassifier(data);
        }

        @Override
        public double[] getMembershipValues(Instance instance) throws Exception {
            if (this.m_zeroR != null) {
                double[] m = new double[]{instance.weight()};
                return m;
            }
            double[] a = new double[this.numElements()];
            LinkedList<Double> queueOfWeights = new LinkedList<Double>();
            LinkedList<Tree> queueOfNodes = new LinkedList<Tree>();
            queueOfWeights.add(instance.weight());
            queueOfNodes.add(this.m_Tree);
            int index = 0;
            while (!queueOfNodes.isEmpty()) {
                a[index++] = (Double)queueOfWeights.poll();
                Tree node = (Tree)queueOfNodes.poll();
                if (node.m_Attribute <= -1) continue;
                double[] weights = new double[node.m_Successors.length];
                if (instance.isMissing(node.m_Attribute)) {
                    System.arraycopy(node.m_Prop, 0, weights, 0, node.m_Prop.length);
                } else if (this.m_Info.attribute(node.m_Attribute).isNominal()) {
                    weights[(int)instance.value((int)node.m_Attribute)] = 1.0;
                } else if (instance.value(node.m_Attribute) < node.m_SplitPoint) {
                    weights[0] = 1.0;
                } else {
                    weights[1] = 1.0;
                }
                for (int i = 0; i < node.m_Successors.length; ++i) {
                    queueOfNodes.add(node.m_Successors[i]);
                    queueOfWeights.add(a[index - 1] * weights[i]);
                }
            }
            return a;
        }

        @Override
        public int numElements() throws Exception {
            if (this.m_zeroR != null) {
                return 1;
            }
            return this.m_Tree.numNodes();
        }

        protected static double variance(double[] s, double[] sS, double[] sumOfWeights) {
            double var = 0.0;
            for (int i = 0; i < s.length; ++i) {
                if (!(sumOfWeights[i] > 0.0)) continue;
                var += RandomRegressionTree.singleVariance(s[i], sS[i], sumOfWeights[i]);
            }
            return var;
        }

        protected static double singleVariance(double s, double sS, double weight) {
            return sS - s * s / weight;
        }

        public static void main(String[] argv) {
            RandomRegressionTree.runClassifier(new RandomRegressionTree(), argv);
        }

        protected class Tree
        implements Serializable {
            public int leafNodeID;
            private static final long serialVersionUID = 3549573538656522569L;
            protected Tree[] m_Successors;
            protected int m_Attribute = -1;
            protected double m_SplitPoint = Double.NaN;
            protected double[] m_Prop = null;
            protected double[] m_ClassDistribution = null;
            protected double[] m_Distribution = null;

            protected Tree() {
            }

            public void backfitData(Instances data) throws Exception {
                double totalWeight = 0.0;
                double totalSumSquared = 0.0;
                double[] classProbs = new double[data.numClasses()];
                for (int i = 0; i < data.numInstances(); ++i) {
                    Instance inst = data.instance(i);
                    if (data.classAttribute().isNominal()) {
                        int n = (int)inst.classValue();
                        classProbs[n] = classProbs[n] + inst.weight();
                        totalWeight += inst.weight();
                        continue;
                    }
                    classProbs[0] = classProbs[0] + inst.classValue() * inst.weight();
                    totalSumSquared += inst.classValue() * inst.classValue() * inst.weight();
                    totalWeight += inst.weight();
                }
                double trainVariance = 0.0;
                if (data.classAttribute().isNumeric()) {
                    trainVariance = RandomRegressionTree.singleVariance(classProbs[0], totalSumSquared, totalWeight) / totalWeight;
                    classProbs[0] = classProbs[0] / totalWeight;
                }
                this.backfitData(data, classProbs, totalWeight);
            }

            public double[] distributionForInstance(Instance instance) throws Exception {
                double[] returnedDist = null;
                if (this.m_Attribute > -1) {
                    if (instance.isMissing(this.m_Attribute)) {
                        returnedDist = new double[RandomRegressionTree.this.m_Info.numClasses()];
                        for (int i = 0; i < this.m_Successors.length; ++i) {
                            double[] help = this.m_Successors[i].distributionForInstance(instance);
                            if (help == null) continue;
                            for (int j = 0; j < help.length; ++j) {
                                int n = j;
                                returnedDist[n] = returnedDist[n] + this.m_Prop[i] * help[j];
                            }
                        }
                    } else {
                        returnedDist = RandomRegressionTree.this.m_Info.attribute(this.m_Attribute).isNominal() ? this.m_Successors[(int)instance.value(this.m_Attribute)].distributionForInstance(instance) : (instance.value(this.m_Attribute) < this.m_SplitPoint ? this.m_Successors[0].distributionForInstance(instance) : this.m_Successors[1].distributionForInstance(instance));
                    }
                }
                if (this.m_Attribute == -1 || returnedDist == null) {
                    lastNode = this.leafNodeID;
                    if (this.m_ClassDistribution == null) {
                        if (RandomRegressionTree.this.getAllowUnclassifiedInstances()) {
                            double[] result = new double[RandomRegressionTree.this.m_Info.numClasses()];
                            if (RandomRegressionTree.this.m_Info.classAttribute().isNumeric()) {
                                result[0] = Utils.missingValue();
                            }
                            return result;
                        }
                        return null;
                    }
                    double[] normalizedDistribution = (double[])this.m_ClassDistribution.clone();
                    if (RandomRegressionTree.this.m_Info.classAttribute().isNominal()) {
                        Utils.normalize(normalizedDistribution);
                    }
                    return normalizedDistribution;
                }
                return returnedDist;
            }

            public int toGraph(StringBuffer text, int num) throws Exception {
                int maxIndex = Utils.maxIndex(this.m_ClassDistribution);
                String classValue = RandomRegressionTree.this.m_Info.classAttribute().isNominal() ? RandomRegressionTree.this.m_Info.classAttribute().value(maxIndex) : Utils.doubleToString(this.m_ClassDistribution[0], 2);
                ++num;
                if (this.m_Attribute == -1) {
                    text.append("N" + Integer.toHexString(this.hashCode()) + " [label=\"" + num + ": " + classValue + "\"shape=box]\n");
                } else {
                    text.append("N" + Integer.toHexString(this.hashCode()) + " [label=\"" + num + ": " + classValue + "\"]\n");
                    for (int i = 0; i < this.m_Successors.length; ++i) {
                        text.append("N" + Integer.toHexString(this.hashCode()) + "->N" + Integer.toHexString(this.m_Successors[i].hashCode()) + " [label=\"" + RandomRegressionTree.this.m_Info.attribute(this.m_Attribute).name());
                        if (RandomRegressionTree.this.m_Info.attribute(this.m_Attribute).isNumeric()) {
                            if (i == 0) {
                                text.append(" < " + Utils.doubleToString(this.m_SplitPoint, 2));
                            } else {
                                text.append(" >= " + Utils.doubleToString(this.m_SplitPoint, 2));
                            }
                        } else {
                            text.append(" = " + RandomRegressionTree.this.m_Info.attribute(this.m_Attribute).value(i));
                        }
                        text.append("\"]\n");
                        num = this.m_Successors[i].toGraph(text, num);
                    }
                }
                return num;
            }

            protected String leafString() throws Exception {
                double sum = 0.0;
                double maxCount = 0.0;
                int maxIndex = 0;
                double classMean = 0.0;
                double avgError = 0.0;
                if (this.m_ClassDistribution != null) {
                    if (RandomRegressionTree.this.m_Info.classAttribute().isNominal()) {
                        sum = Utils.sum(this.m_ClassDistribution);
                        maxIndex = Utils.maxIndex(this.m_ClassDistribution);
                        maxCount = this.m_ClassDistribution[maxIndex];
                    } else {
                        classMean = this.m_ClassDistribution[0];
                        if (this.m_Distribution[1] > 0.0) {
                            avgError = this.m_Distribution[0] / this.m_Distribution[1];
                        }
                    }
                }
                if (RandomRegressionTree.this.m_Info.classAttribute().isNumeric()) {
                    return " : " + Utils.doubleToString(classMean, 2) + " (" + Utils.doubleToString(this.m_Distribution[1], 2) + "/" + Utils.doubleToString(avgError, 2) + ")";
                }
                return " : " + RandomRegressionTree.this.m_Info.classAttribute().value(maxIndex) + " (" + Utils.doubleToString(sum, 2) + "/" + Utils.doubleToString(sum - maxCount, 2) + ")";
            }

            protected String toString(int level) {
                try {
                    StringBuffer text = new StringBuffer();
                    if (this.m_Attribute == -1) {
                        return this.leafString();
                    }
                    if (RandomRegressionTree.this.m_Info.attribute(this.m_Attribute).isNominal()) {
                        for (int i = 0; i < this.m_Successors.length; ++i) {
                            text.append("\n");
                            for (int j = 0; j < level; ++j) {
                                text.append("|   ");
                            }
                            text.append(RandomRegressionTree.this.m_Info.attribute(this.m_Attribute).name() + " = " + RandomRegressionTree.this.m_Info.attribute(this.m_Attribute).value(i));
                            text.append(this.m_Successors[i].toString(level + 1));
                        }
                    } else {
                        int j;
                        text.append("\n");
                        for (j = 0; j < level; ++j) {
                            text.append("|   ");
                        }
                        text.append(RandomRegressionTree.this.m_Info.attribute(this.m_Attribute).name() + " < " + Utils.doubleToString(this.m_SplitPoint, 2));
                        text.append(this.m_Successors[0].toString(level + 1));
                        text.append("\n");
                        for (j = 0; j < level; ++j) {
                            text.append("|   ");
                        }
                        text.append(RandomRegressionTree.this.m_Info.attribute(this.m_Attribute).name() + " >= " + Utils.doubleToString(this.m_SplitPoint, 2));
                        text.append(this.m_Successors[1].toString(level + 1));
                    }
                    return text.toString();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return "RandomTree: tree can't be printed";
                }
            }

            protected void backfitData(Instances data, double[] classProbs, double totalWeight) throws Exception {
                if (data.numInstances() == 0) {
                    this.m_Attribute = -1;
                    this.m_ClassDistribution = null;
                    if (data.classAttribute().isNumeric()) {
                        this.m_Distribution = new double[2];
                    }
                    this.m_Prop = null;
                    return;
                }
                double priorVar = 0.0;
                if (data.classAttribute().isNumeric()) {
                    double totalSum = 0.0;
                    double totalSumSquared = 0.0;
                    double totalSumOfWeights = 0.0;
                    for (int i = 0; i < data.numInstances(); ++i) {
                        Instance inst = data.instance(i);
                        totalSum += inst.classValue() * inst.weight();
                        totalSumSquared += inst.classValue() * inst.classValue() * inst.weight();
                        totalSumOfWeights += inst.weight();
                    }
                    priorVar = RandomRegressionTree.singleVariance(totalSum, totalSumSquared, totalSumOfWeights);
                }
                this.m_ClassDistribution = (double[])classProbs.clone();
                if (this.m_Attribute > -1) {
                    int i;
                    this.m_Prop = new double[this.m_Successors.length];
                    for (int i2 = 0; i2 < data.numInstances(); ++i2) {
                        Instance inst = data.instance(i2);
                        if (inst.isMissing(this.m_Attribute)) continue;
                        if (data.attribute(this.m_Attribute).isNominal()) {
                            int n = (int)inst.value(this.m_Attribute);
                            this.m_Prop[n] = this.m_Prop[n] + inst.weight();
                            continue;
                        }
                        int n = inst.value(this.m_Attribute) < this.m_SplitPoint ? 0 : 1;
                        this.m_Prop[n] = this.m_Prop[n] + inst.weight();
                    }
                    if (Utils.sum(this.m_Prop) <= 0.0) {
                        this.m_Attribute = -1;
                        this.m_Prop = null;
                        if (data.classAttribute().isNumeric()) {
                            this.m_Distribution = new double[2];
                            this.m_Distribution[0] = priorVar;
                            this.m_Distribution[1] = totalWeight;
                        }
                        return;
                    }
                    Utils.normalize(this.m_Prop);
                    Instances[] subsets = this.splitData(data);
                    for (i = 0; i < subsets.length; ++i) {
                        double[] dist = new double[data.numClasses()];
                        double sumOfWeights = 0.0;
                        for (int j = 0; j < subsets[i].numInstances(); ++j) {
                            if (data.classAttribute().isNominal()) {
                                int n = (int)subsets[i].instance(j).classValue();
                                dist[n] = dist[n] + subsets[i].instance(j).weight();
                                continue;
                            }
                            dist[0] = dist[0] + subsets[i].instance(j).classValue() * subsets[i].instance(j).weight();
                            sumOfWeights += subsets[i].instance(j).weight();
                        }
                        if (sumOfWeights > 0.0) {
                            dist[0] = dist[0] / sumOfWeights;
                        }
                        this.m_Successors[i].backfitData(subsets[i], dist, totalWeight);
                    }
                    if (RandomRegressionTree.this.getAllowUnclassifiedInstances()) {
                        this.m_ClassDistribution = null;
                        return;
                    }
                    for (i = 0; i < subsets.length; ++i) {
                        if (this.m_Successors[i].m_ClassDistribution != null) continue;
                        return;
                    }
                    this.m_ClassDistribution = null;
                }
            }

            protected void buildTree(Instances data, double[] classProbs, int[] attIndicesWindow, double totalWeight, Random random, int depth, double minVariance) throws Exception {
                if (data.numInstances() == 0) {
                    this.m_Attribute = -1;
                    this.m_ClassDistribution = null;
                    this.m_Prop = null;
                    if (data.classAttribute().isNumeric()) {
                        this.m_Distribution = new double[2];
                    }
                    this.leafNodeID = RandomRegressionTree.this.nosLeafNodes++;
                    return;
                }
                double priorVar = 0.0;
                if (data.classAttribute().isNumeric()) {
                    double totalSum = 0.0;
                    double totalSumSquared = 0.0;
                    double totalSumOfWeights = 0.0;
                    for (int i = 0; i < data.numInstances(); ++i) {
                        Instance inst = data.instance(i);
                        totalSum += inst.classValue() * inst.weight();
                        totalSumSquared += inst.classValue() * inst.classValue() * inst.weight();
                        totalSumOfWeights += inst.weight();
                    }
                    priorVar = RandomRegressionTree.singleVariance(totalSum, totalSumSquared, totalSumOfWeights);
                }
                if (data.classAttribute().isNominal()) {
                    totalWeight = Utils.sum(classProbs);
                }
                if (totalWeight < 2.0 * RandomRegressionTree.this.m_MinNum || data.classAttribute().isNominal() && Utils.eq(classProbs[Utils.maxIndex(classProbs)], Utils.sum(classProbs)) || data.classAttribute().isNumeric() && priorVar / totalWeight < minVariance || RandomRegressionTree.this.getMaxDepth() > 0 && depth >= RandomRegressionTree.this.getMaxDepth()) {
                    this.m_Attribute = -1;
                    this.m_ClassDistribution = (double[])classProbs.clone();
                    if (data.classAttribute().isNumeric()) {
                        this.m_Distribution = new double[2];
                        this.m_Distribution[0] = priorVar;
                        this.m_Distribution[1] = totalWeight;
                    }
                    this.leafNodeID = RandomRegressionTree.this.nosLeafNodes++;
                    this.m_Prop = null;
                    return;
                }
                double val = -1.7976931348623157E308;
                double split = -1.7976931348623157E308;
                double[][] bestDists = null;
                double[] bestProps = null;
                int bestIndex = 0;
                double[][] props = new double[1][0];
                double[][][] dists = new double[1][0][0];
                double[][] totalSubsetWeights = new double[data.numAttributes()][0];
                int attIndex = 0;
                int windowSize = attIndicesWindow.length;
                int k = RandomRegressionTree.this.m_KValue;
                boolean gainFound = false;
                double[] tempNumericVals = new double[data.numAttributes()];
                while (!(windowSize <= 0 || k-- <= 0 && gainFound)) {
                    double currVal;
                    int chosenIndex = random.nextInt(windowSize);
                    attIndex = attIndicesWindow[chosenIndex];
                    attIndicesWindow[chosenIndex] = attIndicesWindow[windowSize - 1];
                    attIndicesWindow[windowSize - 1] = attIndex;
                    --windowSize;
                    double currSplit = data.classAttribute().isNominal() ? this.distribution(props, dists, attIndex, data) : this.numericDistribution(props, dists, attIndex, totalSubsetWeights, data, tempNumericVals);
                    double d = currVal = data.classAttribute().isNominal() ? this.gain(dists[0], this.priorVal(dists[0])) : tempNumericVals[attIndex];
                    if (Utils.gr(currVal, 0.0)) {
                        gainFound = true;
                    }
                    if (!(currVal > val) && (RandomRegressionTree.this.getBreakTiesRandomly() || currVal != val || attIndex >= bestIndex)) continue;
                    val = currVal;
                    bestIndex = attIndex;
                    split = currSplit;
                    bestProps = props[0];
                    bestDists = dists[0];
                }
                this.m_Attribute = bestIndex;
                if (Utils.gr(val, 0.0)) {
                    this.m_SplitPoint = split;
                    this.m_Prop = bestProps;
                    Instances[] subsets = this.splitData(data);
                    this.m_Successors = new Tree[bestDists.length];
                    double[] attTotalSubsetWeights = totalSubsetWeights[bestIndex];
                    for (int i = 0; i < bestDists.length; ++i) {
                        this.m_Successors[i] = new Tree();
                        this.m_Successors[i].buildTree(subsets[i], bestDists[i], attIndicesWindow, data.classAttribute().isNominal() ? 0.0 : attTotalSubsetWeights[i], random, depth + 1, minVariance);
                    }
                    boolean emptySuccessor = false;
                    for (int i = 0; i < subsets.length; ++i) {
                        if (this.m_Successors[i].m_ClassDistribution != null) continue;
                        emptySuccessor = true;
                        break;
                    }
                    if (emptySuccessor) {
                        this.m_ClassDistribution = (double[])classProbs.clone();
                    }
                } else {
                    this.m_Attribute = -1;
                    this.m_ClassDistribution = (double[])classProbs.clone();
                    if (data.classAttribute().isNumeric()) {
                        this.m_Distribution = new double[2];
                        this.m_Distribution[0] = priorVar;
                        this.m_Distribution[1] = totalWeight;
                    }
                }
            }

            public int numNodes() {
                if (this.m_Attribute == -1) {
                    return 1;
                }
                int size = 1;
                for (Tree m_Successor : this.m_Successors) {
                    size += m_Successor.numNodes();
                }
                return size;
            }

            protected Instances[] splitData(Instances data) throws Exception {
                int i;
                Instances[] subsets = new Instances[this.m_Prop.length];
                for (i = 0; i < this.m_Prop.length; ++i) {
                    subsets[i] = new Instances(data, data.numInstances());
                }
                for (i = 0; i < data.numInstances(); ++i) {
                    Instance inst = data.instance(i);
                    if (inst.isMissing(this.m_Attribute)) {
                        for (int k = 0; k < this.m_Prop.length; ++k) {
                            if (!(this.m_Prop[k] > 0.0)) continue;
                            Instance copy = (Instance)inst.copy();
                            copy.setWeight(this.m_Prop[k] * inst.weight());
                            subsets[k].add(copy);
                        }
                        continue;
                    }
                    if (data.attribute(this.m_Attribute).isNominal()) {
                        subsets[(int)inst.value(this.m_Attribute)].add(inst);
                        continue;
                    }
                    if (data.attribute(this.m_Attribute).isNumeric()) {
                        subsets[inst.value(this.m_Attribute) < this.m_SplitPoint ? 0 : 1].add(inst);
                        continue;
                    }
                    throw new IllegalArgumentException("Unknown attribute type");
                }
                for (i = 0; i < this.m_Prop.length; ++i) {
                    subsets[i].compactify();
                }
                return subsets;
            }

            protected double numericDistribution(double[][] props, double[][][] dists, int att, double[][] subsetWeights, Instances data, double[] vals) throws Exception {
                int k;
                double splitPoint = Double.NaN;
                Attribute attribute = data.attribute(att);
                double[][] dist = null;
                double[] sums = null;
                double[] sumSquared = null;
                double[] sumOfWeights = null;
                double totalSum = 0.0;
                double totalSumSquared = 0.0;
                double totalSumOfWeights = 0.0;
                int indexOfFirstMissingValue = data.numInstances();
                if (attribute.isNominal()) {
                    sums = new double[attribute.numValues()];
                    sumSquared = new double[attribute.numValues()];
                    sumOfWeights = new double[attribute.numValues()];
                    for (int i = 0; i < data.numInstances(); ++i) {
                        int attVal;
                        Instance inst = data.instance(i);
                        if (inst.isMissing(att)) {
                            if (indexOfFirstMissingValue != data.numInstances()) continue;
                            indexOfFirstMissingValue = i;
                            continue;
                        }
                        int n = attVal = (int)inst.value(att);
                        sums[n] = sums[n] + inst.classValue() * inst.weight();
                        int n2 = attVal;
                        sumSquared[n2] = sumSquared[n2] + inst.classValue() * inst.classValue() * inst.weight();
                        int n3 = attVal;
                        sumOfWeights[n3] = sumOfWeights[n3] + inst.weight();
                    }
                    totalSum = Utils.sum(sums);
                    totalSumSquared = Utils.sum(sumSquared);
                    totalSumOfWeights = Utils.sum(sumOfWeights);
                } else {
                    sums = new double[2];
                    sumSquared = new double[2];
                    sumOfWeights = new double[2];
                    double[] currSums = new double[2];
                    double[] currSumSquared = new double[2];
                    double[] currSumOfWeights = new double[2];
                    data.sort(att);
                    for (int j = 0; j < data.numInstances(); ++j) {
                        Instance inst = data.instance(j);
                        if (inst.isMissing(att)) {
                            indexOfFirstMissingValue = j;
                            break;
                        }
                        currSums[1] = currSums[1] + inst.classValue() * inst.weight();
                        currSumSquared[1] = currSumSquared[1] + inst.classValue() * inst.classValue() * inst.weight();
                        currSumOfWeights[1] = currSumOfWeights[1] + inst.weight();
                    }
                    totalSum = currSums[1];
                    totalSumSquared = currSumSquared[1];
                    totalSumOfWeights = currSumOfWeights[1];
                    sums[1] = currSums[1];
                    sumSquared[1] = currSumSquared[1];
                    sumOfWeights[1] = currSumOfWeights[1];
                    double currSplit = data.instance(0).value(att);
                    double bestVal = Double.MAX_VALUE;
                    for (int i = 0; i < indexOfFirstMissingValue; ++i) {
                        double currVal;
                        Instance inst = data.instance(i);
                        if (inst.value(att) > currSplit && (currVal = RandomRegressionTree.variance(currSums, currSumSquared, currSumOfWeights)) < bestVal) {
                            bestVal = currVal;
                            splitPoint = (inst.value(att) + currSplit) / 2.0;
                            if (splitPoint <= currSplit) {
                                splitPoint = inst.value(att);
                            }
                            for (int j = 0; j < 2; ++j) {
                                sums[j] = currSums[j];
                                sumSquared[j] = currSumSquared[j];
                                sumOfWeights[j] = currSumOfWeights[j];
                            }
                        }
                        currSplit = inst.value(att);
                        double classVal = inst.classValue() * inst.weight();
                        double classValSquared = inst.classValue() * classVal;
                        currSums[0] = currSums[0] + classVal;
                        currSumSquared[0] = currSumSquared[0] + classValSquared;
                        currSumOfWeights[0] = currSumOfWeights[0] + inst.weight();
                        currSums[1] = currSums[1] - classVal;
                        currSumSquared[1] = currSumSquared[1] - classValSquared;
                        currSumOfWeights[1] = currSumOfWeights[1] - inst.weight();
                    }
                }
                props[0] = new double[sums.length];
                for (k = 0; k < props[0].length; ++k) {
                    props[0][k] = sumOfWeights[k];
                }
                if (!(Utils.sum(props[0]) > 0.0)) {
                    for (k = 0; k < props[0].length; ++k) {
                        props[0][k] = 1.0 / (double)props[0].length;
                    }
                } else {
                    Utils.normalize(props[0]);
                }
                for (int i = indexOfFirstMissingValue; i < data.numInstances(); ++i) {
                    Instance inst = data.instance(i);
                    for (int j = 0; j < sums.length; ++j) {
                        int n = j;
                        sums[n] = sums[n] + props[0][j] * inst.classValue() * inst.weight();
                        int n4 = j;
                        sumSquared[n4] = sumSquared[n4] + props[0][j] * inst.classValue() * inst.classValue() * inst.weight();
                        int n5 = j;
                        sumOfWeights[n5] = sumOfWeights[n5] + props[0][j] * inst.weight();
                    }
                    totalSum += inst.classValue() * inst.weight();
                    totalSumSquared += inst.classValue() * inst.classValue() * inst.weight();
                    totalSumOfWeights += inst.weight();
                }
                dist = new double[sums.length][data.numClasses()];
                for (int j = 0; j < sums.length; ++j) {
                    dist[j][0] = sumOfWeights[j] > 0.0 ? sums[j] / sumOfWeights[j] : totalSum / totalSumOfWeights;
                }
                double priorVar = RandomRegressionTree.singleVariance(totalSum, totalSumSquared, totalSumOfWeights);
                double var = RandomRegressionTree.variance(sums, sumSquared, sumOfWeights);
                double gain = priorVar - var;
                subsetWeights[att] = sumOfWeights;
                dists[0] = dist;
                vals[att] = gain;
                return splitPoint;
            }

            protected double distribution(double[][] props, double[][][] dists, int att, Instances data) throws Exception {
                int k;
                int i;
                double splitPoint = Double.NaN;
                Attribute attribute = data.attribute(att);
                double[][] dist = null;
                int indexOfFirstMissingValue = data.numInstances();
                if (attribute.isNominal()) {
                    dist = new double[attribute.numValues()][data.numClasses()];
                    for (i = 0; i < data.numInstances(); ++i) {
                        Instance inst = data.instance(i);
                        if (inst.isMissing(att)) {
                            if (indexOfFirstMissingValue != data.numInstances()) continue;
                            indexOfFirstMissingValue = i;
                            continue;
                        }
                        double[] dArray = dist[(int)inst.value(att)];
                        int n = (int)inst.classValue();
                        dArray[n] = dArray[n] + inst.weight();
                    }
                } else {
                    double[][] currDist = new double[2][data.numClasses()];
                    dist = new double[2][data.numClasses()];
                    data.sort(att);
                    for (int j = 0; j < data.numInstances(); ++j) {
                        Instance inst = data.instance(j);
                        if (inst.isMissing(att)) {
                            indexOfFirstMissingValue = j;
                            break;
                        }
                        double[] dArray = currDist[1];
                        int n = (int)inst.classValue();
                        dArray[n] = dArray[n] + inst.weight();
                    }
                    double priorVal = this.priorVal(currDist);
                    for (int j = 0; j < currDist.length; ++j) {
                        System.arraycopy(currDist[j], 0, dist[j], 0, dist[j].length);
                    }
                    double currSplit = data.instance(0).value(att);
                    double bestVal = -1.7976931348623157E308;
                    for (int i2 = 0; i2 < indexOfFirstMissingValue; ++i2) {
                        Instance inst = data.instance(i2);
                        double attVal = inst.value(att);
                        if (attVal > currSplit) {
                            double currVal = this.gain(currDist, priorVal);
                            if (currVal > bestVal) {
                                bestVal = currVal;
                                splitPoint = (attVal + currSplit) / 2.0;
                                if (splitPoint <= currSplit) {
                                    splitPoint = attVal;
                                }
                                for (int j = 0; j < currDist.length; ++j) {
                                    System.arraycopy(currDist[j], 0, dist[j], 0, dist[j].length);
                                }
                            }
                            currSplit = attVal;
                        }
                        int classVal = (int)inst.classValue();
                        double[] dArray = currDist[0];
                        int n = classVal;
                        dArray[n] = dArray[n] + inst.weight();
                        double[] dArray2 = currDist[1];
                        int n2 = classVal;
                        dArray2[n2] = dArray2[n2] - inst.weight();
                    }
                }
                props[0] = new double[dist.length];
                for (k = 0; k < props[0].length; ++k) {
                    props[0][k] = Utils.sum(dist[k]);
                }
                if (Utils.eq(Utils.sum(props[0]), 0.0)) {
                    for (k = 0; k < props[0].length; ++k) {
                        props[0][k] = 1.0 / (double)props[0].length;
                    }
                } else {
                    Utils.normalize(props[0]);
                }
                for (i = indexOfFirstMissingValue; i < data.numInstances(); ++i) {
                    Instance inst = data.instance(i);
                    if (attribute.isNominal()) {
                        if (!inst.isMissing(att)) continue;
                        for (int j = 0; j < dist.length; ++j) {
                            double[] dArray = dist[j];
                            int n = (int)inst.classValue();
                            dArray[n] = dArray[n] + props[0][j] * inst.weight();
                        }
                        continue;
                    }
                    for (int j = 0; j < dist.length; ++j) {
                        double[] dArray = dist[j];
                        int n = (int)inst.classValue();
                        dArray[n] = dArray[n] + props[0][j] * inst.weight();
                    }
                }
                dists[0] = dist;
                return splitPoint;
            }

            protected double priorVal(double[][] dist) {
                return ContingencyTables.entropyOverColumns(dist);
            }

            protected double gain(double[][] dist, double priorVal) {
                return priorVal - ContingencyTables.entropyConditionedOnRows(dist);
            }

            public String getRevision() {
                return RevisionUtils.extract("$Revision: 11907 $");
            }

            protected int toGraph(StringBuffer text, int num, Tree parent) throws Exception {
                ++num;
                if (this.m_Attribute == -1) {
                    text.append("N" + Integer.toHexString(this.hashCode()) + " [label=\"" + num + Utils.backQuoteChars(this.leafString()) + "\" shape=box]\n");
                } else {
                    text.append("N" + Integer.toHexString(this.hashCode()) + " [label=\"" + num + ": " + Utils.backQuoteChars(RandomRegressionTree.this.m_Info.attribute(this.m_Attribute).name()) + "\"]\n");
                    for (int i = 0; i < this.m_Successors.length; ++i) {
                        text.append("N" + Integer.toHexString(this.hashCode()) + "->N" + Integer.toHexString(this.m_Successors[i].hashCode()) + " [label=\"");
                        if (RandomRegressionTree.this.m_Info.attribute(this.m_Attribute).isNumeric()) {
                            if (i == 0) {
                                text.append(" < " + Utils.doubleToString(this.m_SplitPoint, 2));
                            } else {
                                text.append(" >= " + Utils.doubleToString(this.m_SplitPoint, 2));
                            }
                        } else {
                            text.append(" = " + Utils.backQuoteChars(RandomRegressionTree.this.m_Info.attribute(this.m_Attribute).value(i)));
                        }
                        text.append("\"]\n");
                        num = this.m_Successors[i].toGraph(text, num, this);
                    }
                }
                return num;
            }
        }
    }
}

