/*
 * Decompiled with CFR 0.152.
 */
package statistics.tests;

import statistics.tests.TestResults;
import statistics.tests.Tests;

public class ManySampleTests
extends Tests {
    public static void kruskalWallace(TestResults T) {
        double H_prime;
        int i;
        if (!loaded) {
            System.out.println("ERROR: Data not loaded, cannot perform testg");
            return;
        }
        T.testName = "Kruskal Wallace";
        double[] rankSums = new double[k];
        for (i = 0; i < k; ++i) {
            rankSums[i] = 0.0;
            for (int j = 0; j < n[i]; ++j) {
                int n = i;
                rankSums[n] = rankSums[n] + ManySampleTests.dataByLevel[i][j].rank;
            }
        }
        double H = 0.0;
        for (i = 0; i < k; ++i) {
            H += rankSums[i] * rankSums[i] / (double)n[i];
        }
        H = H * 12.0 / (double)(N * (N + 1));
        System.out.println("\n\n H stat = " + (H -= (double)(3 * (N + 1))));
        i = 0;
        int nextPos = 0;
        int t = 0;
        int tSum = 0;
        int t3Sum = 0;
        while (i < N) {
            if (ManySampleTests.rankedData[i].rank != (double)(i + 1)) {
                t = (int)(2.0 * ManySampleTests.rankedData[i].rank) - i;
                nextPos = t - 1;
                t = t - i - 1;
                tSum += t;
                t3Sum += t * t * t;
                i = nextPos;
                continue;
            }
            ++i;
        }
        System.out.println("\n\n t sum = " + tSum + "\t t^3 sum = " + t3Sum);
        double C = 1.0 - ((double)t3Sum - (double)tSum) / (double)(N * (N * N - 1));
        T.testStat = H_prime = H / C;
    }

    public static void main(String[] args) {
        String fileName = "C:/JavaSource/Clustering/Clustering_Data/Java_Application_Release/Experiment3/Exp3NoRandomShocks.txt";
        ManySampleTests.loadData(fileName);
        TestResults t = new TestResults("Blank");
        t.h0 = 0.0;
        t.type = 0;
        ManySampleTests.kruskalWallace(t);
        System.out.println(" H prime = " + t.testStat);
    }
}

