/*
 * Decompiled with CFR 0.152.
 */
package statistics.simulators;

import java.util.ArrayList;
import statistics.simulators.Model;
import weka.core.Attribute;
import weka.core.DenseInstance;
import weka.core.FastVector;
import weka.core.Instance;
import weka.core.Instances;
import weka.filters.NormalizeCase;

public class DataSimulator {
    int nosClasses = 2;
    ArrayList<Model> models;
    int seriesLength = 100;
    int nosPerClass = 50;
    int[] casesPerClass;

    public void setSeriesLength(int s) {
        this.seriesLength = s;
    }

    public void setCasesPerClass(int[] c) {
        this.casesPerClass = c;
        this.nosPerClass = c[0];
    }

    protected DataSimulator() {
        this.models = new ArrayList();
    }

    protected DataSimulator(double[][] paras) {
        this.nosClasses = paras.length;
        this.models = new ArrayList(this.nosClasses);
    }

    public DataSimulator(ArrayList<Model> m) {
        this.models = new ArrayList();
        this.nosClasses = m.size();
        this.models.addAll(m);
    }

    public DataSimulator(Model[] m) {
        this.nosClasses = m.length;
        this.models = new ArrayList(this.nosClasses);
        for (int i = 0; i < m.length; ++i) {
            this.models.add(m[i]);
        }
    }

    public void setModel(ArrayList<Model> m) {
        this.nosClasses = m.size();
        this.models.addAll(m);
    }

    public ArrayList<Model> getModels() {
        return this.models;
    }

    public void setModel(Model[] m) {
        this.nosClasses = m.length;
        for (int i = 0; i < m.length; ++i) {
            this.models.add(m[i]);
        }
    }

    public Instances generateDataSet() {
        int i;
        if (this.casesPerClass == null) {
            this.casesPerClass = new int[this.nosClasses];
            for (int i2 = 0; i2 < this.casesPerClass.length; ++i2) {
                this.casesPerClass[i2] = this.nosPerClass;
            }
        }
        FastVector<Attribute> atts = new FastVector<Attribute>();
        this.nosClasses = this.casesPerClass.length;
        int totalCases = this.casesPerClass[0];
        for (i = 1; i < this.casesPerClass.length; ++i) {
            totalCases += this.casesPerClass[i];
        }
        for (i = 1; i <= this.seriesLength; ++i) {
            atts.addElement(new Attribute(this.models.get(0).getAttributeName() + i));
        }
        FastVector<String> fv = new FastVector<String>();
        for (int i3 = 0; i3 < this.nosClasses; ++i3) {
            fv.addElement("" + i3);
        }
        atts.addElement(new Attribute("Target", fv));
        Instances data = new Instances(this.models.get(0).getModelType(), atts, totalCases);
        for (int i4 = 0; i4 < this.nosClasses; ++i4) {
            for (int j = 0; j < this.casesPerClass[i4]; ++j) {
                this.initialise();
                double[] d = this.generate(this.seriesLength, i4);
                Instance in = new DenseInstance(data.numAttributes());
                for (int k = 0; k < d.length; ++k) {
                    in.setValue(k, d[k]);
                }
                data.add(in);
                in = data.lastInstance();
                in.setValue(d.length, "" + i4);
            }
        }
        data.setClassIndex(this.seriesLength);
        return data;
    }

    public String generateHeader() {
        String header = "%  " + this.models.get(0).getModelType() + "\n";
        for (int i = 0; i < this.models.size(); ++i) {
            header = header + "%Class " + i;
            header = header + "\n" + this.models.get(i).getHeader() + "\n";
        }
        return header;
    }

    public Instances[] generateTrainTest() throws Exception {
        Instances[] data = new Instances[]{this.generateDataSet(), this.generateDataSet()};
        NormalizeCase nc = new NormalizeCase();
        data[0] = nc.process(data[0]);
        data[1] = nc.process(data[1]);
        return data;
    }

    public double[] generate(int length, int modelNos) {
        double[] d = new double[length];
        Model a = this.models.get(modelNos);
        d = a.generateSeries(length);
        return d;
    }

    public void initialise() {
        for (Model a : this.models) {
            a.reset();
        }
    }

    public void setNosPerClass(int x) {
        this.nosPerClass = x;
    }

    public void setLength(int l) {
        this.seriesLength = l;
    }

    public String getParameters() {
        String str = this.nosClasses + "\n";
        for (Model m : this.models) {
            str = str + m.toString() + "\n";
        }
        return str;
    }
}

