/*
 * Decompiled with CFR 0.152.
 */
package statistics.distributions;

import statistics.distributions.Distribution;

public class WalkMaxDistribution
extends Distribution {
    private int steps;

    public WalkMaxDistribution(int n) {
        this.setSteps(n);
    }

    public WalkMaxDistribution() {
        this(10);
    }

    public void setSteps(int n) {
        if (n < 1) {
            n = 1;
        }
        this.steps = n;
        super.setParameters(0.0, this.steps, 1.0, 0);
    }

    @Override
    public double getDensity(double x) {
        int k = (int)Math.rint(x);
        int m = (k + this.steps) % 2 == 0 ? (k + this.steps) / 2 : (k + this.steps + 1) / 2;
        return WalkMaxDistribution.comb(this.steps, m) / Math.pow(2.0, this.steps);
    }

    @Override
    public double getMaxDensity() {
        return this.getDensity(0.0);
    }

    public double getSteps() {
        return this.steps;
    }

    @Override
    public double simulate() {
        int max = 0;
        int position = 0;
        for (int i = 1; i <= this.steps; ++i) {
            int step = Math.random() < 0.5 ? 1 : -1;
            if ((position += step) <= max) continue;
            max = position;
        }
        return max;
    }
}

