/*
 * Decompiled with CFR 0.152.
 */
package statistics.distributions;

import statistics.distributions.Distribution;

public class TriangleDistribution
extends Distribution {
    private int orientation;
    private double c;
    private double minValue;
    private double maxValue;
    public static final int UP = 0;
    public static final int DOWN = 1;

    public TriangleDistribution(double a, double b, int i) {
        this.setParameters(a, b, i);
    }

    public TriangleDistribution() {
        this(0.0, 1.0, 0);
    }

    public void setParameters(double a, double b, int i) {
        this.minValue = a;
        this.maxValue = b;
        this.orientation = i;
        double stepSize = (this.maxValue - this.minValue) / 100.0;
        super.setParameters(this.minValue, this.maxValue, stepSize, 1);
        this.c = (this.maxValue - this.minValue) * (this.maxValue - this.minValue);
    }

    @Override
    public double getDensity(double x) {
        if (this.minValue <= x & x <= this.maxValue) {
            if (this.orientation == 0) {
                return 2.0 * (x - this.minValue) / this.c;
            }
            return 2.0 * (this.maxValue - x) / this.c;
        }
        return 0.0;
    }

    @Override
    public double getMaxDensity() {
        double mode = this.orientation == 0 ? this.maxValue : this.minValue;
        return this.getDensity(mode);
    }

    @Override
    public double getMean() {
        if (this.orientation == 0) {
            return this.minValue / 3.0 + 2.0 * this.maxValue / 3.0;
        }
        return 2.0 * this.minValue / 3.0 + this.maxValue / 3.0;
    }

    @Override
    public double getVariance() {
        return (this.maxValue - this.minValue) * (this.maxValue - this.minValue) / 18.0;
    }

    public double getMinValue() {
        return this.minValue;
    }

    public double getMaxValue() {
        return this.maxValue;
    }

    public int getOrientation() {
        return this.orientation;
    }

    @Override
    public double simulate() {
        double u = this.minValue + (this.maxValue - this.minValue) * Math.random();
        double v = this.minValue + (this.maxValue - this.minValue) * Math.random();
        if (this.orientation == 0) {
            return Math.max(u, v);
        }
        return Math.min(u, v);
    }

    @Override
    public double getCDF(double x) {
        if (this.orientation == 0) {
            return (x - this.minValue) * (x - this.minValue) / this.c;
        }
        return 1.0 - (this.maxValue - x) * (this.maxValue - x) / this.c;
    }
}

