/*
 * Decompiled with CFR 0.152.
 */
package statistics.distributions;

import statistics.distributions.Distribution;

public class PoissonDistribution
extends Distribution {
    double parameter;

    public PoissonDistribution(double r) {
        this.setParameter(r);
    }

    public PoissonDistribution() {
        this(1.0);
    }

    public void setParameter(double r) {
        if (r < 0.0) {
            r = 1.0;
        }
        this.parameter = r;
        double a = Math.ceil(this.getMean() - 4.0 * this.getSD());
        double b = Math.ceil(this.getMean() + 4.0 * this.getSD());
        if (a < 0.0) {
            a = 0.0;
        }
        super.setParameters(a, b, 1.0, 0);
    }

    public double getParameter() {
        return this.parameter;
    }

    @Override
    public double getDensity(double x) {
        int k = (int)Math.rint(x);
        if (k < 0) {
            return 0.0;
        }
        return Math.exp(-this.parameter) * (Math.pow(this.parameter, k) / PoissonDistribution.factorial(k));
    }

    @Override
    public double getMaxDensity() {
        double mode = Math.floor(this.parameter);
        return this.getDensity(mode);
    }

    @Override
    public double getCDF(double x) {
        return 1.0 - PoissonDistribution.gammaCDF(this.parameter, x + 1.0);
    }

    @Override
    public double getMean() {
        return this.parameter;
    }

    @Override
    public double getVariance() {
        return this.parameter;
    }

    @Override
    public double simulate() {
        int arrivals = 0;
        for (double sum = -Math.log(1.0 - Math.random()); sum <= this.parameter; sum -= Math.log(1.0 - Math.random())) {
            ++arrivals;
        }
        return arrivals;
    }
}

