/*
 * Decompiled with CFR 0.152.
 */
package statistics.distributions;

import statistics.distributions.Distribution;

public class PointMassDistribution
extends Distribution {
    double x0;

    public PointMassDistribution(double x0) {
        this.setParameters(x0);
    }

    public PointMassDistribution() {
        this(0.0);
    }

    public void setParameters(double x0) {
        this.x0 = x0;
        super.setParameters(x0, x0, 1.0, 0);
    }

    @Override
    public double getDensity(double x) {
        if (x == this.x0) {
            return 1.0;
        }
        return 0.0;
    }

    @Override
    public double getMaxDensity() {
        return 1.0;
    }

    @Override
    public double getMean() {
        return this.x0;
    }

    @Override
    public double getVariance() {
        return 0.0;
    }

    public double getParameter(int i) {
        return this.x0;
    }

    @Override
    public double simulate() {
        return this.x0;
    }

    @Override
    public double getQuantile(double p) {
        return this.x0;
    }

    public double CDF(double x) {
        if (x < this.x0) {
            return 0.0;
        }
        return 1.0;
    }

    public String name() {
        return "Point Mass Distribution";
    }
}

