/*
 * Decompiled with CFR 0.152.
 */
package statistics.distributions;

import statistics.distributions.Distribution;

public class ParetoDistribution
extends Distribution {
    private double parameter;

    public ParetoDistribution(double a) {
        this.setParameter(a);
    }

    public ParetoDistribution() {
        this(1.0);
    }

    public void setParameter(double a) {
        if (a <= 0.0) {
            a = 1.0;
        }
        this.parameter = a;
        double upper = 20.0 / this.parameter;
        double width = (upper - 1.0) / 100.0;
        super.setParameters(1.0, upper, width, 1);
    }

    public double getParameter() {
        return this.parameter;
    }

    @Override
    public double getDensity(double x) {
        if (x < 1.0) {
            return 0.0;
        }
        return this.parameter / Math.pow(x, this.parameter + 1.0);
    }

    @Override
    public double getMaxDensity() {
        return this.parameter;
    }

    @Override
    public double getMean() {
        if (this.parameter > 1.0) {
            return this.parameter / (this.parameter - 1.0);
        }
        return Double.POSITIVE_INFINITY;
    }

    @Override
    public double getVariance() {
        if (this.parameter > 2.0) {
            return this.parameter / ((this.parameter - 1.0) * (this.parameter - 1.0) * (this.parameter - 2.0));
        }
        if (this.parameter > 1.0) {
            return Double.POSITIVE_INFINITY;
        }
        return Double.NaN;
    }

    @Override
    public double getCDF(double x) {
        return 1.0 - Math.pow(1.0 / x, this.parameter);
    }

    @Override
    public double getQuantile(double p) {
        return 1.0 / Math.pow(1.0 - p, 1.0 / this.parameter);
    }
}

