/*
 * Decompiled with CFR 0.152.
 */
package statistics.distributions;

import statistics.distributions.Distribution;

public class MixtureDistribution
extends Distribution {
    Distribution[] dist;
    int n;
    int type;
    double minValue;
    double maxValue;
    double lowerValue;
    double upperValue;
    double stepSize;
    double[] prob;

    public MixtureDistribution(Distribution[] d, double[] p) {
        this.setParameters(d, p);
    }

    public MixtureDistribution(Distribution d0, Distribution d1, double a) {
        this.setParameters(d0, d1, a);
    }

    public void setParameters(Distribution[] d, double[] p) {
        int t;
        double minLower = Double.POSITIVE_INFINITY;
        double maxUpper = Double.NEGATIVE_INFINITY;
        double minWidth = Double.POSITIVE_INFINITY;
        this.dist = d;
        this.prob = p;
        int t0 = this.dist[0].getType();
        this.n = this.dist.length;
        boolean mixed = false;
        for (int i = 0; i < this.n; ++i) {
            double w;
            double b;
            t = this.dist[i].getType();
            double a = t == 0 ? this.dist[i].getDomain().getLowerValue() : this.dist[i].getDomain().getLowerBound();
            if (a < minLower) {
                minLower = a;
            }
            if ((b = t == 0 ? this.dist[i].getDomain().getUpperValue() : this.dist[i].getDomain().getUpperBound()) > maxUpper) {
                maxUpper = b;
            }
            if ((w = this.dist[i].getDomain().getWidth()) < minWidth) {
                minWidth = w;
            }
            if (t == t0) continue;
            mixed = true;
        }
        t = mixed ? 2 : t0;
        super.setParameters(minLower, maxUpper, minWidth, t);
    }

    public void setParameters(Distribution d0, Distribution d1, double a) {
        this.setParameters(new Distribution[]{d0, d1}, new double[]{1.0 - a, a});
    }

    @Override
    public double getDensity(double x) {
        double d = 0.0;
        for (int i = 0; i < this.n; ++i) {
            d += this.prob[i] * this.dist[i].getDensity(x);
        }
        return d;
    }

    @Override
    public double getMean() {
        double sum = 0.0;
        for (int i = 0; i < this.n; ++i) {
            sum += this.prob[i] * this.dist[i].getMean();
        }
        return sum;
    }

    @Override
    public double getVariance() {
        double sum = 0.0;
        double mu = this.getMean();
        for (int i = 0; i < this.n; ++i) {
            double m = this.dist[i].getMean();
            sum += this.prob[i] * (this.dist[i].getVariance() + m * m);
        }
        return sum - mu * mu;
    }

    @Override
    public double simulate() {
        double sum = 0.0;
        double p = Math.random();
        int i = -1;
        while (sum < p & i < this.n) {
            sum += this.prob[i];
            ++i;
        }
        return this.dist[i].simulate();
    }
}

