/*
 * Decompiled with CFR 0.152.
 */
package statistics.distributions;

import statistics.distributions.Distribution;

public class MatchDistribution
extends Distribution {
    int parameter;
    int[] b;

    public MatchDistribution(int n) {
        this.setParameter(n);
    }

    public MatchDistribution() {
        this(5);
    }

    public void setParameter(int n) {
        if (n < 1) {
            n = 1;
        }
        this.parameter = n;
        super.setParameters(0.0, this.parameter, 1.0, 0);
        this.b = new int[n];
    }

    @Override
    public double getDensity(double x) {
        int k = (int)Math.rint(x);
        double sum = 0.0;
        int sign = -1;
        for (int j = 0; j <= this.parameter - k; ++j) {
            sign = -sign;
            sum += (double)sign / MatchDistribution.factorial(j);
        }
        return sum / MatchDistribution.factorial(k);
    }

    @Override
    public double getMaxDensity() {
        if (this.parameter == 2) {
            return this.getDensity(0.0);
        }
        return this.getDensity(1.0);
    }

    @Override
    public double getMean() {
        return 1.0;
    }

    @Override
    public double getVariance() {
        return 1.0;
    }

    public int getParameter() {
        return this.parameter;
    }

    @Override
    public double simulate() {
        int i;
        double matches = 0.0;
        for (i = 0; i < this.parameter; ++i) {
            this.b[i] = i + 1;
        }
        for (i = 0; i < this.parameter; ++i) {
            int j = this.parameter - i;
            int u = (int)((double)j * Math.random());
            if (this.b[u] == i + 1) {
                matches += 1.0;
            }
            int k = this.b[j - 1];
            this.b[j - 1] = this.b[u];
            this.b[u] = k;
        }
        return matches;
    }
}

