/*
 * Decompiled with CFR 0.152.
 */
package statistics.distributions;

public class Domain {
    private double lowerBound;
    private double upperBound;
    private double width;
    private double lowerValue;
    private double upperValue;
    private int size;

    public Domain(double a, double b, double w) {
        if (w <= 0.0) {
            w = 1.0;
        }
        this.width = w;
        if (b < a + w) {
            b = a + w;
        }
        this.lowerBound = a;
        this.upperBound = b;
        this.lowerValue = this.lowerBound + 0.5 * this.width;
        this.upperValue = this.upperBound - 0.5 * this.width;
        this.size = (int)Math.rint((b - a) / w);
    }

    public Domain(double b) {
        this(0.0, b, 0.1 * b);
    }

    public Domain() {
        this(1.0);
    }

    public int getIndex(double x) {
        if (x < this.lowerBound) {
            return -1;
        }
        if (x > this.upperBound) {
            return this.size;
        }
        return (int)Math.rint((x - this.lowerValue) / this.width);
    }

    public double getBound(int i) {
        return this.lowerBound + (double)i * this.width;
    }

    public double getValue(int i) {
        return this.lowerValue + (double)i * this.width;
    }

    public double getLowerBound() {
        return this.lowerBound;
    }

    public double getUpperBound() {
        return this.upperBound;
    }

    public double getLowerValue() {
        return this.lowerValue;
    }

    public double getUpperValue() {
        return this.upperValue;
    }

    public double getWidth() {
        return this.width;
    }

    public int getSize() {
        return this.size;
    }
}

