/*
 * Decompiled with CFR 0.152.
 */
package statistics.distributions;

import statistics.distributions.Distribution;

public class BirthdayDistribution
extends Distribution {
    private int popSize;
    private int sampleSize;
    private double[][] prob;

    public BirthdayDistribution(int n, int k) {
        this.setParameters(n, k);
    }

    public BirthdayDistribution() {
        this(365, 20);
    }

    public void setParameters(int n, int k) {
        if (n < 1) {
            n = 1;
        }
        if (k < 1) {
            k = 1;
        }
        this.popSize = n;
        this.sampleSize = k;
        super.setParameters(1.0, Math.min(this.popSize, this.sampleSize), 1.0, 0);
        this.prob = new double[this.sampleSize + 1][this.popSize + 1];
        this.prob[0][0] = 1.0;
        this.prob[1][1] = 1.0;
        for (int j = 1; j < this.sampleSize; ++j) {
            int upperIndex = j < this.popSize ? j + 1 : this.popSize;
            for (int m = 1; m <= upperIndex; ++m) {
                this.prob[j + 1][m] = this.prob[j][m] * ((double)m / (double)this.popSize) + this.prob[j][m - 1] * ((double)(this.popSize - m + 1) / (double)this.popSize);
            }
        }
    }

    @Override
    public double getDensity(double x) {
        int m = (int)Math.rint(x);
        return this.prob[this.sampleSize][m];
    }

    @Override
    public double getMean() {
        return (double)this.popSize * (1.0 - Math.pow(1.0 - 1.0 / (double)this.popSize, this.sampleSize));
    }

    @Override
    public double getVariance() {
        return (double)(this.popSize * (this.popSize - 1)) * Math.pow(1.0 - 2.0 / (double)this.popSize, this.sampleSize) + (double)this.popSize * Math.pow(1.0 - 1.0 / (double)this.popSize, this.sampleSize) - (double)(this.popSize * this.popSize) * Math.pow(1.0 - 1.0 / (double)this.popSize, 2 * this.sampleSize);
    }

    public double getPopSize() {
        return this.popSize;
    }

    public void setPopSize(int n) {
        this.setParameters(n, this.sampleSize);
    }

    public double getSampleSize() {
        return this.sampleSize;
    }

    public void setSampleSize(int k) {
        this.setParameters(this.popSize, k);
    }

    @Override
    public double simulate() {
        int[] count = new int[this.popSize];
        double distinct = 0.0;
        for (int i = 1; i <= this.sampleSize; ++i) {
            int j = (int)((double)this.popSize * Math.random());
            if (count[j] == 0) {
                distinct += 1.0;
            }
            int n = j;
            count[n] = count[n] + 1;
        }
        return distinct;
    }
}

