/*
 * Decompiled with CFR 0.152.
 */
package statistics.distributions;

import statistics.distributions.Distribution;

public class BetaDistribution
extends Distribution {
    private double left;
    private double right;
    private double c;

    public BetaDistribution(double a, double b) {
        this.setParameters(a, b);
    }

    public BetaDistribution() {
        this(1.0, 1.0);
    }

    public void setParameters(double a, double b) {
        if (a <= 0.0) {
            a = 1.0;
        }
        if (b <= 0.0) {
            b = 1.0;
        }
        this.left = a;
        this.right = b;
        this.c = BetaDistribution.logGamma(this.left + this.right) - BetaDistribution.logGamma(this.left) - BetaDistribution.logGamma(this.right);
        super.setParameters(0.0, 1.0, 0.001, 1);
    }

    public void setLeft(double a) {
        this.setParameters(a, this.right);
    }

    public void setRight(double b) {
        this.setParameters(this.left, b);
    }

    public double getLeft() {
        return this.left;
    }

    public double getRight() {
        return this.right;
    }

    @Override
    public double getDensity(double x) {
        if (x < 0.0 | x > 1.0) {
            return 0.0;
        }
        if (x == 0.0 & this.left == 1.0) {
            return this.right;
        }
        if (x == 0.0 & this.left < 1.0) {
            return Double.POSITIVE_INFINITY;
        }
        if (x == 0.0 & this.left > 1.0) {
            return 0.0;
        }
        if (x == 1.0 & this.right == 1.0) {
            return this.left;
        }
        if (x == 1.0 & this.right < 1.0) {
            return Double.POSITIVE_INFINITY;
        }
        if (x == 1.0 & this.right > 1.0) {
            return 0.0;
        }
        return Math.exp(this.c + (this.left - 1.0) * Math.log(x) + (this.right - 1.0) * Math.log(1.0 - x));
    }

    @Override
    public double getMaxDensity() {
        double mode = this.left < 1.0 ? 0.01 : (this.right <= 1.0 ? 0.99 : (this.left - 1.0) / (this.left + this.right - 2.0));
        return this.getDensity(mode);
    }

    @Override
    public double getMean() {
        return this.left / (this.left + this.right);
    }

    @Override
    public double getVariance() {
        return this.left * this.right / ((this.left + this.right) * (this.left + this.right) * (this.left + this.right + 1.0));
    }

    @Override
    public double getCDF(double x) {
        return BetaDistribution.betaCDF(x, this.left, this.right);
    }
}

