/*
 * Decompiled with CFR 0.152.
 */
package multivariate_timeseriesweka.measures;

import timeseriesweka.elastic_distance_measures.DTW_DistanceBasic;
import utilities.MultivariateInstanceTools;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.neighboursearch.PerformanceStats;

public class DTW_D
extends DTW_DistanceBasic {
    public DTW_D() {
    }

    public DTW_D(Instances train) {
        super(train);
        this.m_Data = null;
        this.m_Validated = true;
    }

    @Override
    protected void validate() {
    }

    @Override
    public void update(Instance ins) {
    }

    @Override
    public double distance(Instance first, Instance second, double cutOffValue, PerformanceStats stats) {
        return this.distance(first, second, cutOffValue);
    }

    @Override
    public double distance(Instance first, Instance second) {
        return this.distance(first, second, Double.POSITIVE_INFINITY);
    }

    @Override
    public double distance(Instance multiSeries1, Instance multiseries2, double cutoff) {
        Instance[] multi1 = MultivariateInstanceTools.splitMultivariateInstance(multiSeries1);
        Instance[] multi2 = MultivariateInstanceTools.splitMultivariateInstance(multiseries2);
        double[][] data1 = MultivariateInstanceTools.convertMultiInstanceToTransposedArrays(multi1);
        double[][] data2 = MultivariateInstanceTools.convertMultiInstanceToTransposedArrays(multi2);
        return Math.sqrt(this.distance(data1, data2, cutoff));
    }

    public double distance(double[][] a, double[][] b, double cutoff) {
        int j;
        int i;
        boolean tooBig = true;
        if (a.length < b.length) {
            double[][] temp = a;
            a = b;
            b = temp;
        }
        int n = a.length;
        int m = b.length;
        this.matrixD = new double[n][n];
        this.windowSize = this.getWindowSize(n);
        for (i = 0; i < n; ++i) {
            for (j = 0; j < m; ++j) {
                this.matrixD[i][j] = Double.MAX_VALUE;
            }
        }
        this.matrixD[0][0] = this.sqMultiDist(a[0], b[0]);
        for (int j2 = 1; j2 < this.windowSize && j2 < n; ++j2) {
            this.matrixD[0][j2] = this.matrixD[0][j2 - 1] + this.sqMultiDist(a[0], b[j2]);
        }
        for (i = 1; i < this.windowSize && i < n; ++i) {
            this.matrixD[i][0] = this.matrixD[i - 1][0] + this.sqMultiDist(a[i], b[0]);
        }
        for (i = 1; i < n; ++i) {
            tooBig = true;
            for (j = 1; j < m; ++j) {
                if (i >= j + this.windowSize || j >= i + this.windowSize) continue;
                double minDist = this.matrixD[i][j - 1];
                if (this.matrixD[i - 1][j] < minDist) {
                    minDist = this.matrixD[i - 1][j];
                }
                if (this.matrixD[i - 1][j - 1] < minDist) {
                    minDist = this.matrixD[i - 1][j - 1];
                }
                this.matrixD[i][j] = minDist + this.sqMultiDist(a[i], b[j]);
                if (!tooBig || !(this.matrixD[i][j] < cutoff)) continue;
                tooBig = false;
            }
            if (!tooBig) continue;
            return Double.MAX_VALUE;
        }
        return this.matrixD[n - 1][m - 1];
    }

    double sqDist(double a, double b) {
        return (a - b) * (a - b);
    }

    double sqMultiDist(double[] a, double[] b) {
        double sum = 0.0;
        for (int i = 0; i < a.length; ++i) {
            sum += this.sqDist(a[i], b[i]);
        }
        return sum;
    }

    public static void main(String[] args) {
    }
}

