/*
 * Decompiled with CFR 0.152.
 */
package multivariate_timeseriesweka.classifiers;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import multivariate_timeseriesweka.measures.DTW_D;
import multivariate_timeseriesweka.measures.DTW_I;
import timeseriesweka.elastic_distance_measures.DTW_DistanceBasic;
import utilities.InstanceTools;
import utilities.generic_storage.Pair;
import weka.classifiers.AbstractClassifier;
import weka.core.Capabilities;
import weka.core.Instance;
import weka.core.Instances;

public class NN_DTW_A
extends AbstractClassifier {
    Instances train;
    public double threshold;
    DTW_DistanceBasic I = new DTW_I();
    DTW_DistanceBasic D = new DTW_D();
    double R;

    public void setR(double r) {
        this.R = r;
        this.I.setR(this.R);
        this.D.setR(this.R);
    }

    @Override
    public Capabilities getCapabilities() {
        Capabilities result = super.getCapabilities();
        result.enable(Capabilities.Capability.RELATIONAL_ATTRIBUTES);
        return result;
    }

    @Override
    public void buildClassifier(Instances data) throws Exception {
        this.train = data;
        this.threshold = this.learnThreshold(this.train);
        System.out.println("threshold = " + this.threshold);
    }

    @Override
    public double classifyInstance(Instance instance) throws Exception {
        Pair<Instance, Double> minD = InstanceTools.findMinDistance(this.train, instance, this.D);
        Pair<Instance, Double> minI = InstanceTools.findMinDistance(this.train, instance, this.I);
        double S = (Double)minD.var2 / ((Double)minI.var2 + 1.0E-9);
        double out = S > this.threshold ? ((Instance)minI.var1).classValue() : ((Instance)minD.var1).classValue();
        return out;
    }

    public double learnThreshold(Instances data) {
        Pair<List<Double>, List<Double>> scores = this.findScores(data);
        List S_dSuccess = (List)scores.var1;
        List S_iSuccess = (List)scores.var2;
        double output = S_iSuccess.isEmpty() && S_dSuccess.isEmpty() ? 1.0 : (!S_iSuccess.isEmpty() && S_dSuccess.isEmpty() ? (Double)Collections.min(S_iSuccess) - 0.1 : (S_iSuccess.isEmpty() && !S_dSuccess.isEmpty() ? (Double)Collections.max(S_dSuccess) + 0.1 : this.calculateThreshold(S_dSuccess, S_iSuccess)));
        return output;
    }

    double calculateThreshold(List<Double> dSuccess, List<Double> iSuccess) {
        int i;
        int dp;
        int in;
        int j;
        double output = 0.0;
        int common = iSuccess.size() + dSuccess.size();
        for (j = 0; j < dSuccess.size(); ++j) {
            in = 0;
            dp = 0;
            for (i = 0; i < dSuccess.size(); ++i) {
                if (!(dSuccess.get(i) >= dSuccess.get(j))) continue;
                ++dp;
            }
            for (i = 0; i < iSuccess.size(); ++i) {
                if (!(iSuccess.get(i) < dSuccess.get(j))) continue;
                ++in;
            }
            if (in + dp >= common) continue;
            common = in + dp;
            output = dSuccess.get(j);
        }
        for (j = 0; j < iSuccess.size(); ++j) {
            in = 0;
            dp = 0;
            for (i = 0; i < dSuccess.size(); ++i) {
                if (!(dSuccess.get(i) >= iSuccess.get(j))) continue;
                ++dp;
            }
            for (i = 0; i < iSuccess.size(); ++i) {
                if (!(iSuccess.get(i) < iSuccess.get(j))) continue;
                ++in;
            }
            if (in + dp >= common) continue;
            common = in + dp;
            output = iSuccess.get(j);
        }
        return output;
    }

    Pair<List<Double>, List<Double>> findScores(Instances data) {
        ArrayList<Double> S_dSuccess = new ArrayList<Double>();
        ArrayList<Double> S_iSuccess = new ArrayList<Double>();
        for (int i = 0; i < data.numInstances(); ++i) {
            try {
                Instances cv_train = data.trainCV(data.numInstances(), i);
                Instances cv_test = data.testCV(data.numInstances(), i);
                Instance test = cv_test.firstInstance();
                Pair<Instance, Double> pair_D = InstanceTools.findMinDistance(cv_train, test, this.D);
                Pair<Instance, Double> pair_I = InstanceTools.findMinDistance(cv_train, test, this.I);
                double pred_d = ((Instance)pair_D.var1).classValue();
                double pred_i = ((Instance)pair_I.var1).classValue();
                double dist_d = (Double)pair_D.var2;
                double dist_i = (Double)pair_I.var2;
                double S = dist_d / (dist_i + 1.0E-9);
                if (test.classValue() == pred_d && test.classValue() != pred_i) {
                    S_dSuccess.add(S);
                }
                if (test.classValue() == pred_d || test.classValue() != pred_i) continue;
                S_iSuccess.add(S);
                continue;
            }
            catch (Exception ex) {
                System.out.println(ex);
            }
        }
        return new Pair<List<Double>, List<Double>>(S_dSuccess, S_iSuccess);
    }

    public String toString() {
        return "threshold=" + this.threshold;
    }
}

