/*
 * Decompiled with CFR 0.152.
 */
package fileIO;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.StreamTokenizer;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.Vector;

public class InFile {
    private String fileName;
    private FileReader fr;
    private BufferedReader in;
    private StreamTokenizer token;
    private StreamTokenizer markerToken;
    private static int MAXBUFFERSIZE = 1000000;

    public InFile(String name) {
        try {
            this.fileName = name;
            this.fr = new FileReader(name);
            this.in = new BufferedReader(this.fr, MAXBUFFERSIZE);
            this.token = new StreamTokenizer(this.in);
            this.markerToken = new StreamTokenizer(this.in);
            this.token.wordChars(32, 32);
            this.token.wordChars(95, 95);
            this.token.whitespaceChars(44, 44);
            this.token.slashStarComments(true);
            this.markPoint();
        }
        catch (Exception ex) {
            throw new RuntimeException("File " + name + " not found Exception in InFile constructor :" + ex.toString() + "   Current token is >" + this.token.sval);
        }
    }

    public InFile(String name, char sep) {
        try {
            this.fileName = name;
            this.fr = new FileReader(name);
            this.in = new BufferedReader(this.fr, MAXBUFFERSIZE);
            this.token = new StreamTokenizer(this.in);
            this.token.whitespaceChars(sep, sep);
            this.token.ordinaryChar(95);
            this.token.slashStarComments(true);
            this.markPoint();
        }
        catch (Exception ex) {
            throw new RuntimeException("File " + name + " with Separator " + sep + " not found Exception in InFile constructor :" + ex.toString() + "   Current token is >" + this.token.sval);
        }
    }

    public void reopen() {
        try {
            this.fr = new FileReader(this.fileName);
            this.in = new BufferedReader(this.fr, MAXBUFFERSIZE);
            this.token = new StreamTokenizer(this.in);
            this.markerToken = new StreamTokenizer(this.in);
            this.token.wordChars(32, 32);
            this.token.wordChars(95, 95);
            this.token.whitespaceChars(44, 44);
            this.token.slashStarComments(true);
            this.markPoint();
        }
        catch (Exception ex) {
            throw new RuntimeException("File " + this.fileName + "  not found on call to reopen() in InFile :" + ex.toString() + "   Current token is >" + this.token.sval);
        }
    }

    public String getName() {
        return this.fileName;
    }

    public void openFile(String name) {
        try {
            this.fileName = name;
            this.fr = new FileReader(name);
            this.in = new BufferedReader(this.fr, MAXBUFFERSIZE);
            this.token = new StreamTokenizer(this.in);
            this.markerToken = new StreamTokenizer(this.in);
            this.token.wordChars(32, 32);
            this.token.wordChars(95, 95);
            this.token.whitespaceChars(44, 44);
            this.token.slashStarComments(true);
        }
        catch (Exception ex) {
            throw new RuntimeException("File " + name + "  not found on call to openFile() in InFile :" + ex.toString() + "   Current token is >" + this.token.sval);
        }
    }

    public void closeFile() {
        try {
            this.in.close();
            this.fr.close();
        }
        catch (IOException ex) {
            throw new RuntimeException("Failed to close  " + this.fileName + "  not found on call to closeFile() in InFile :" + ex.toString() + "   Current token is >" + this.token.sval);
        }
    }

    public char readChar() {
        char c;
        try {
            c = (char)this.in.read();
        }
        catch (Exception ex) {
            throw new RuntimeException("Failed to read a character from  " + this.fileName + "  readChar() in InFile :" + ex.toString() + "Current token is >" + this.token.sval);
        }
        return c;
    }

    public String readLine() {
        String v = null;
        try {
            v = this.in.readLine();
        }
        catch (Exception ex) {
            throw new RuntimeException("Failed to read a line from  " + this.fileName + "  readLine() in InFile :" + ex.toString() + "Current token is >" + this.token.sval);
        }
        return v;
    }

    public Object read() {
        boolean v = false;
        Object o = null;
        try {
            int t = this.token.nextToken();
            o = t == -2 ? new Double(this.token.nval) : this.token.sval;
        }
        catch (IOException ex) {
            throw new RuntimeException("Failed to read a line from  " + this.fileName + "  read() in InFile :" + ex.toString() + "Current token is >" + this.token.sval);
        }
        return o;
    }

    public int readInt() {
        int v = 0;
        try {
            int t = this.token.nextToken();
            if (t != -2) {
                System.out.println("ERROR: Attempting to read a non integer");
                System.out.println("Current token is >" + this.token.sval);
                System.out.println("File name =" + this.fileName);
                throw new RuntimeException("Failed to read an integer from  " + this.fileName + "  readInt() in InFile Current token is >" + this.token.sval);
            }
            v = (int)this.token.nval;
        }
        catch (Exception ex) {
            throw new RuntimeException("Failed to read an integer from  " + this.fileName + "  readInt() in InFile Current token is >" + this.token.sval);
        }
        return v;
    }

    public double readDouble() {
        double v = 0.0;
        try {
            int t = this.token.nextToken();
            if (t != -2) {
                System.out.println("ERROR: Attempting to read a non double");
                System.out.println("Current token is >" + this.token.sval);
                System.out.println("File name =" + this.fileName);
                throw new RuntimeException("Failed to read a double from  " + this.fileName + "  readDouble() in InFile Current token is >" + this.token.sval);
            }
            v = this.token.nval;
        }
        catch (Exception ex) {
            throw new RuntimeException("Failed to read a double from  " + this.fileName + "  readDouble() in InFile Current token is >" + this.token.sval + " exception =" + ex);
        }
        return v;
    }

    public float readFloat() {
        double v = 0.0;
        try {
            int t = this.token.nextToken();
            if (t != -2) {
                System.out.println("ERROR: Attempting to read a non double");
                System.out.println("Current token is >" + this.token.sval);
                System.out.println("File name =" + this.fileName);
                throw new RuntimeException("Failed to read a float from  " + this.fileName + "  readFloat() in InFile Current token is >" + this.token.sval);
            }
            v = this.token.nval;
        }
        catch (Exception ex) {
            System.out.println("ERROR: wrong Format");
            System.out.println("File name =" + this.fileName);
            throw new RuntimeException("Failed to read a float from  " + this.fileName + "  readFloat() in InFile Current token is >" + this.token.sval + " exception =" + ex);
        }
        return (float)v;
    }

    public String readStringToChar(char delimit) {
        String v = "";
        char[] name = new char[1];
        try {
            name[0] = this.readChar();
            while (name[0] == ' ' || name[0] == '\n' || name[0] == '\t') {
                name[0] = this.readChar();
            }
            while (name[0] != ' ' && name[0] != '\n' && name[0] != '\t' && name[0] != delimit) {
                v = v + new String(name);
                name[0] = this.readChar();
            }
            while (name[0] != delimit) {
                name[0] = this.readChar();
            }
        }
        catch (Exception ex) {
            throw new RuntimeException("Failed to read a straing from chars from  " + this.fileName + "  readStringToChar() in InFile Current token is >" + this.token.sval + " exception =" + ex);
        }
        return v;
    }

    public String readStringIgnoreWhite() {
        String v = "";
        char[] name = new char[1];
        try {
            name[0] = this.readChar();
            while (name[0] == ' ' || name[0] == '\n' || name[0] == '\t') {
                name[0] = this.readChar();
            }
            while (name[0] != ' ' && name[0] != '\n' && name[0] != '\t') {
                v = v + new String(name);
                name[0] = this.readChar();
            }
        }
        catch (NoSuchElementException ex) {
            throw new RuntimeException("Failed to read a string from chars from  " + this.fileName + "  readStringIgnoreWhite() in InFile Current token is >" + this.token.sval + " exception =" + ex);
        }
        return v;
    }

    public String readString() {
        String v;
        try {
            int t = this.token.nextToken();
            if (t != -3) {
                System.out.println("ERROR: Attempting to read a non string");
                System.out.println("Current token is >" + this.token.sval + "\t t =" + this.token.nval + "\t" + this.token.toString());
                System.out.println("File name =" + this.fileName);
                System.exit(0);
            }
            v = this.token.sval;
        }
        catch (IOException ex) {
            throw new RuntimeException("Failed to read a string from  " + this.fileName + "  readString() in InFile Current token is >" + this.token.sval + " exception =" + ex);
        }
        return v;
    }

    public Vector readStringLine(String delimit) {
        Vector<String> headers = new Vector<String>();
        try {
            String line = this.readLine();
            StringTokenizer sToke = new StringTokenizer(line, delimit);
            while (sToke.hasMoreTokens()) {
                String name = sToke.nextToken();
                headers.addElement(name);
            }
        }
        catch (NoSuchElementException ex) {
            throw new RuntimeException("Failed to read a string from  " + this.fileName + "  readStringLine(String delimit) in InFile Current token is >" + this.token.sval + " exception =" + ex);
        }
        return headers;
    }

    public Vector readStringLine() {
        Vector<String> headers = new Vector<String>();
        try {
            String line = this.readLine();
            StringTokenizer sToke = new StringTokenizer(line);
            while (sToke.hasMoreTokens()) {
                String name = sToke.nextToken();
                headers.addElement(name);
            }
        }
        catch (NoSuchElementException ex) {
            throw new RuntimeException("Failed to read a string from  " + this.fileName + "  readStringLine() in InFile Current token is >" + this.token.sval + " exception =" + ex);
        }
        return headers;
    }

    public double[] readDoubleLine(int size) {
        double d = this.readDouble();
        if (this.token.ttype == -1) {
            return null;
        }
        double[] data = new double[size];
        data[0] = d;
        for (int i = 1; i < size; ++i) {
            data[i] = this.readDouble();
        }
        return data;
    }

    public boolean readDoubleLine(double[] data) {
        data[0] = this.readDouble();
        if (this.token.ttype == -1) {
            return false;
        }
        for (int i = 1; i < data.length; ++i) {
            data[i] = this.readDouble();
        }
        return true;
    }

    public String readStringUpTo(char delimit) {
        char[] name = new char[1];
        String header = "";
        try {
            name[0] = this.readChar();
            while (name[0] != delimit) {
                header = header + new String(name);
                name[0] = this.readChar();
            }
        }
        catch (NoSuchElementException ex) {
            System.out.println("IO Exception caught in readStringUpTo");
            throw new RuntimeException("Failed to read a string from  " + this.fileName + "  readStringUpTo() in InFile Current token is >" + this.token.sval + " exception =" + ex);
        }
        return header;
    }

    public void markPoint() {
        try {
            this.in.mark(MAXBUFFERSIZE - 1);
        }
        catch (IOException ex) {
            throw new RuntimeException("Failed to mark a point  from  " + this.fileName + "  markPoint() in InFile Current token is >" + this.token.sval + " exception =" + ex);
        }
    }

    public void rewind() {
        try {
            this.in.reset();
        }
        catch (IOException ex) {
            throw new RuntimeException("Failed to mark a point  from  " + this.fileName + "  rewind() in InFile Current token is >" + this.token.sval + " exception =" + ex);
        }
    }

    public int countLines() {
        int count = 0;
        String str = this.readLine();
        while (str != null) {
            str = this.readLine();
            ++count;
        }
        return count;
    }

    public static void main(String[] args) {
        InFile t = new InFile("C:/JavaSource/FileIO/test.csv");
        int a = t.readInt();
        double x = t.readDouble();
        String s = t.readStringUpTo(',');
        System.out.println(s + "\tEND");
        StringTokenizer st = new StringTokenizer(s);
        String s2 = st.nextToken("-");
        System.out.println(s2 + "STRING");
        a = Integer.parseInt(s2);
        System.out.println(a + "INTEGER");
    }

    public static boolean directoryExists(String s) {
        File f = new File(s);
        return f.exists() && f.isDirectory();
    }

    public static boolean fileExists(String s) {
        File f = new File(s);
        return f.exists() && !f.isDirectory();
    }

    public static boolean deleteFile(String s) {
        File f = new File(s);
        if (f.exists() && !f.isDirectory()) {
            f.delete();
            return true;
        }
        return false;
    }
}

