/*
 * Decompiled with CFR 0.152.
 */
package development;

import development.DataSets;
import fileIO.OutFile;
import java.io.File;
import timeseriesweka.classifiers.BOSS;
import timeseriesweka.classifiers.BagOfPatterns;
import timeseriesweka.classifiers.DD_DTW;
import timeseriesweka.classifiers.DTD_C;
import timeseriesweka.classifiers.ElasticEnsemble;
import timeseriesweka.classifiers.FastDTW_1NN;
import timeseriesweka.classifiers.FastShapelets;
import timeseriesweka.classifiers.FlatCote;
import timeseriesweka.classifiers.HiveCote;
import timeseriesweka.classifiers.LPS;
import timeseriesweka.classifiers.LearnShapelets;
import timeseriesweka.classifiers.NN_CID;
import timeseriesweka.classifiers.ParameterSplittable;
import timeseriesweka.classifiers.RISE;
import timeseriesweka.classifiers.SAXVSM;
import timeseriesweka.classifiers.ST_HESCA;
import timeseriesweka.classifiers.TSBF;
import timeseriesweka.classifiers.TSF;
import timeseriesweka.classifiers.ensembles.SaveableEnsemble;
import timeseriesweka.classifiers.ensembles.elastic_ensemble.DTW1NN;
import timeseriesweka.classifiers.ensembles.elastic_ensemble.DTWKNN;
import timeseriesweka.classifiers.ensembles.elastic_ensemble.ED1NN;
import timeseriesweka.classifiers.ensembles.elastic_ensemble.MSM1NN;
import timeseriesweka.classifiers.ensembles.elastic_ensemble.WDTW1NN;
import utilities.ClassifierResults;
import utilities.ClassifierTools;
import utilities.CrossValidator;
import utilities.SaveParameterInfo;
import utilities.TrainAccuracyEstimate;
import vector_classifiers.HESCA;
import vector_classifiers.PLSNominalClassifier;
import vector_classifiers.RotationForestLimitedAttributes;
import vector_classifiers.ST_HESCAlog;
import vector_classifiers.SaveEachParameter;
import vector_classifiers.TunedRandomForest;
import vector_classifiers.TunedRotationForest;
import vector_classifiers.TunedSVM;
import weka.classifiers.Classifier;
import weka.classifiers.bayes.BayesNet;
import weka.classifiers.bayes.NaiveBayes;
import weka.classifiers.functions.Logistic;
import weka.classifiers.functions.MultilayerPerceptron;
import weka.classifiers.functions.SMO;
import weka.classifiers.functions.VotedPerceptron;
import weka.classifiers.functions.supportVector.PolyKernel;
import weka.classifiers.functions.supportVector.RBFKernel;
import weka.classifiers.lazy.kNN;
import weka.classifiers.meta.AdaBoostM1;
import weka.classifiers.meta.Bagging;
import weka.classifiers.meta.Dagging;
import weka.classifiers.meta.Decorate;
import weka.classifiers.meta.END;
import weka.classifiers.meta.LogitBoost;
import weka.classifiers.meta.MultiBoostAB;
import weka.classifiers.meta.RandomCommittee;
import weka.classifiers.meta.RandomSubSpace;
import weka.classifiers.meta.RotationForest;
import weka.classifiers.meta.Stacking;
import weka.classifiers.meta.StackingC;
import weka.classifiers.rules.DecisionTable;
import weka.classifiers.rules.ZeroR;
import weka.classifiers.trees.FT;
import weka.classifiers.trees.J48;
import weka.classifiers.trees.REPTree;
import weka.classifiers.trees.RandomForest;
import weka.core.EuclideanDistance;
import weka.core.Instances;

public class SpectralExperiments {
    public static int folds = 30;
    static int numCVFolds = 10;
    static boolean debug = true;
    static boolean checkpoint = false;
    static boolean generateTrainFiles = true;
    static Integer parameterNum = 0;
    static String loboFolder = "LOBO/";
    static String randBottleFolder = "RandomBottles/";
    static String randForgeryFolder = "RandomForgery/";

    public static int calcCvFolds(int numTrainInstances) {
        if (numTrainInstances < 3) {
            return 10;
        }
        return Math.min(numTrainInstances - 1, 10);
    }

    public static Classifier jameslSetClassifier(String classifier, int fold, int numTrainInstances) {
        int cvFolds = SpectralExperiments.calcCvFolds(numTrainInstances);
        double[] minTunedSVMparaSpace = new double[]{Math.pow(2.0, -8.0), Math.pow(2.0, -4.0), Math.pow(2.0, 0.0), Math.pow(2.0, 4.0), Math.pow(2.0, 8.0)};
        switch (classifier) {
            case "ZeroR": {
                return new ZeroR();
            }
            case "NN": {
                kNN k = new kNN(100);
                k.setCrossValidate(true);
                k.normalise(false);
                k.setDistanceFunction(new EuclideanDistance());
                return k;
            }
            case "NB": {
                return new NaiveBayes();
            }
            case "C4.5": {
                return new J48();
            }
            case "RandF": {
                RandomForest r = new RandomForest();
                r.setNumTrees(500);
                r.setSeed(fold);
                return r;
            }
            case "RotF": {
                RotationForest rf = new RotationForest();
                rf.setNumIterations(50);
                rf.setSeed(fold);
                return rf;
            }
            case "bayesNet": {
                return new BayesNet();
            }
            case "DecorateDefault": {
                Decorate dec = new Decorate();
                dec.setDesiredSize(cvFolds);
                return dec;
            }
            case "ENDDefault": {
                END end = new END();
                return end;
            }
            case "RandomSubSpaceDefault": {
                RandomSubSpace rss = new RandomSubSpace();
                return rss;
            }
            case "StackingLogisticBasicComps": {
                Stacking stacklog = new Stacking();
                try {
                    stacklog.setNumFolds(cvFolds);
                }
                catch (Exception e) {
                    System.out.println("only throws if numTrainInstances < 0, cba to handle properly ");
                    System.exit(0);
                }
                Classifier[] HESCABasicClassifierList = new Classifier[]{SpectralExperiments.jameslSetClassifier("Logistic", fold, cvFolds), SpectralExperiments.jameslSetClassifier("C4.5", fold, cvFolds), SpectralExperiments.jameslSetClassifier("NN", fold, cvFolds), SpectralExperiments.jameslSetClassifier("MLP", fold, cvFolds), SpectralExperiments.jameslSetClassifier("SVML", fold, cvFolds)};
                stacklog.setClassifiers(HESCABasicClassifierList);
                stacklog.setMetaClassifier(new Logistic());
                return stacklog;
            }
            case "StackingJ48BasicComps": {
                Stacking stackj48 = new Stacking();
                try {
                    stackj48.setNumFolds(cvFolds);
                }
                catch (Exception e) {
                    System.out.println("only throws if numTrainInstances < 0, cba to handle properly ");
                    System.exit(0);
                }
                Classifier[] HESCABasicClassifierList = new Classifier[]{SpectralExperiments.jameslSetClassifier("Logistic", fold, cvFolds), SpectralExperiments.jameslSetClassifier("C4.5", fold, cvFolds), SpectralExperiments.jameslSetClassifier("NN", fold, cvFolds), SpectralExperiments.jameslSetClassifier("MLP", fold, cvFolds), SpectralExperiments.jameslSetClassifier("SVML", fold, cvFolds)};
                stackj48.setClassifiers(HESCABasicClassifierList);
                stackj48.setMetaClassifier(new J48());
                return stackj48;
            }
            case "StackingDefaultBasicComps": {
                Stacking stack = new Stacking();
                try {
                    stack.setNumFolds(cvFolds);
                }
                catch (Exception e) {
                    System.out.println("only throws if numTrainInstances < 0, cba to handle properly ");
                    System.exit(0);
                }
                Classifier[] HESCABasicClassifierList = new Classifier[]{SpectralExperiments.jameslSetClassifier("Logistic", fold, cvFolds), SpectralExperiments.jameslSetClassifier("C4.5", fold, cvFolds), SpectralExperiments.jameslSetClassifier("NN", fold, cvFolds), SpectralExperiments.jameslSetClassifier("MLP", fold, cvFolds), SpectralExperiments.jameslSetClassifier("SVML", fold, cvFolds)};
                stack.setClassifiers(HESCABasicClassifierList);
                return stack;
            }
            case "StackingCJ48BasicComps": {
                StackingC stackcj48 = new StackingC();
                try {
                    stackcj48.setNumFolds(cvFolds);
                }
                catch (Exception e) {
                    System.out.println("only throws if numTrainInstances < 0, cba to handle properly ");
                    System.exit(0);
                }
                Classifier[] HESCABasicClassifierList = new Classifier[]{SpectralExperiments.jameslSetClassifier("Logistic", fold, cvFolds), SpectralExperiments.jameslSetClassifier("C4.5", fold, cvFolds), SpectralExperiments.jameslSetClassifier("NN", fold, cvFolds), SpectralExperiments.jameslSetClassifier("MLP", fold, cvFolds), SpectralExperiments.jameslSetClassifier("SVML", fold, cvFolds)};
                stackcj48.setClassifiers(HESCABasicClassifierList);
                return stackcj48;
            }
            case "StackingCDefaultBasicComps": {
                StackingC stackc = new StackingC();
                try {
                    stackc.setNumFolds(cvFolds);
                }
                catch (Exception e) {
                    System.out.println("only throws if numTrainInstances < 0, cba to handle properly ");
                    System.exit(0);
                }
                Classifier[] HESCABasicClassifierList = new Classifier[]{SpectralExperiments.jameslSetClassifier("Logistic", fold, cvFolds), SpectralExperiments.jameslSetClassifier("C4.5", fold, cvFolds), SpectralExperiments.jameslSetClassifier("NN", fold, cvFolds), SpectralExperiments.jameslSetClassifier("MLP", fold, cvFolds), SpectralExperiments.jameslSetClassifier("SVML", fold, cvFolds)};
                stackc.setClassifiers(HESCABasicClassifierList);
                return stackc;
            }
            case "RandomCommitteeDefault": {
                RandomCommittee randCom = new RandomCommittee();
                return randCom;
            }
            case "DaggingDefault": {
                Dagging dag = new Dagging();
                dag.setNumFolds(cvFolds);
                dag.setSeed(fold);
                return dag;
            }
            case "MultiBoostABDefault": {
                MultiBoostAB mb = new MultiBoostAB();
                mb.setSeed(fold);
                return mb;
            }
            case "AdaBoostM1Default": {
                AdaBoostM1 adad = new AdaBoostM1();
                adad.setSeed(fold);
                return adad;
            }
            case "BaggingDefault": {
                Bagging bagd = new Bagging();
                bagd.setSeed(fold);
                return bagd;
            }
            case "LogitBoostDefault": {
                LogitBoost logd = new LogitBoost();
                logd.setNumFolds(cvFolds);
                logd.setSeed(fold);
                return logd;
            }
            case "SVML": {
                SMO smo = new SMO();
                smo.turnChecksOff();
                smo.setBuildLogisticModels(true);
                PolyKernel kl = new PolyKernel();
                kl.setExponent(1.0);
                smo.setKernel(kl);
                smo.setRandomSeed(fold);
                return smo;
            }
            case "SVMQ": {
                SMO smo = new SMO();
                smo.turnChecksOff();
                smo.setBuildLogisticModels(true);
                PolyKernel kq = new PolyKernel();
                kq.setExponent(2.0);
                smo.setKernel(kq);
                smo.setRandomSeed(fold);
                return smo;
            }
            case "SVMRBF": {
                SMO smo = new SMO();
                smo.turnChecksOff();
                smo.setBuildLogisticModels(true);
                RBFKernel rbf = new RBFKernel();
                smo.setKernel(rbf);
                smo.setRandomSeed(fold);
                return smo;
            }
            case "PLSNominalClassifier": {
                return new PLSNominalClassifier();
            }
            case "RotFDefault": {
                RotationForest drotf = new RotationForest();
                drotf.setSeed(fold);
                return drotf;
            }
            case "1NN": {
                return new kNN();
            }
            case "Logistic": {
                return new Logistic();
            }
            case "VotedPerceptron": {
                return new VotedPerceptron();
            }
            case "DecisionTable": {
                return new DecisionTable();
            }
            case "REPTree": {
                return new REPTree();
            }
            case "BaggingJ48": {
                J48 c = new J48();
                Bagging bag = new Bagging();
                bag.setClassifier(c);
                bag.setNumIterations(500);
                bag.setBagSizePercent(70);
                return bag;
            }
            case "DTWFullWindow": {
                return new DTW1NN();
            }
            case "DTWFullWindow5NN": {
                DTWKNN dtw = new DTWKNN(5);
                return dtw;
            }
            case "DTWFullWindow11NN": {
                DTWKNN dtw = new DTWKNN(11);
                return dtw;
            }
            case "BaggingREP": {
                REPTree c = new REPTree();
                Bagging bag = new Bagging();
                bag.setClassifier(c);
                bag.setNumIterations(500);
                bag.setBagSizePercent(70);
                return bag;
            }
            case "BaggingFT": {
                FT c = new FT();
                Bagging bag = new Bagging();
                bag.setClassifier(c);
                bag.setNumIterations(500);
                bag.setBagSizePercent(70);
                return bag;
            }
            case "LogitBoost": {
                LogitBoost lb = new LogitBoost();
                lb.setNumFolds(cvFolds);
                lb.setNumIterations(500);
                return lb;
            }
            case "MultiBoostABJ48": {
                MultiBoostAB mb = new MultiBoostAB();
                mb.setClassifier(new J48());
                mb.setNumIterations(100);
                mb.setNumSubCmtys(10);
                mb.setSeed(fold);
                return mb;
            }
            case "AdaBoostM1DS": {
                AdaBoostM1 ada = new AdaBoostM1();
                ada.setNumIterations(500);
                return ada;
            }
            case "AdaBoostM1Log": {
                AdaBoostM1 ada = new AdaBoostM1();
                ada.setClassifier(new Logistic());
                ada.setNumIterations(500);
                return ada;
            }
            case "AdaBoostM1J48": {
                AdaBoostM1 ada = new AdaBoostM1();
                ada.setClassifier(new J48());
                ada.setNumIterations(500);
                return ada;
            }
            case "MLP": {
                MultilayerPerceptron mlp = new MultilayerPerceptron();
                return mlp;
            }
            case "mTSVM_RBF": {
                TunedSVM svm = new TunedSVM();
                svm.setParaSpace(minTunedSVMparaSpace);
                svm.setSeed(fold);
                svm.setKernelType(TunedSVM.KernelType.RBF);
                return svm;
            }
            case "mTSVM_L": {
                TunedSVM svm = new TunedSVM();
                svm.setParaSpace(minTunedSVMparaSpace);
                svm.setSeed(fold);
                svm.setKernelType(TunedSVM.KernelType.LINEAR);
                return svm;
            }
            case "mTSVM_Q": {
                TunedSVM svm = new TunedSVM();
                svm.setParaSpace(minTunedSVMparaSpace);
                svm.setSeed(fold);
                svm.setKernelType(TunedSVM.KernelType.QUADRATIC);
                return svm;
            }
            case "TSVM_RBF": {
                TunedSVM svm = new TunedSVM();
                svm.setSeed(fold);
                svm.setKernelType(TunedSVM.KernelType.RBF);
                return svm;
            }
            case "TSVM_L": {
                TunedSVM svm = new TunedSVM();
                svm.setSeed(fold);
                svm.setKernelType(TunedSVM.KernelType.LINEAR);
                return svm;
            }
            case "TSVM_Q": {
                TunedSVM svm = new TunedSVM();
                svm.optimiseParas(true);
                svm.optimiseKernel(false);
                svm.setBuildLogisticModels(true);
                svm.setSeed(fold);
                svm.setKernelType(TunedSVM.KernelType.QUADRATIC);
                return svm;
            }
            case "SVM": {
                TunedSVM svm = new TunedSVM();
                svm.setKernelType(TunedSVM.KernelType.RBF);
                svm.optimiseParas(true);
                svm.optimiseKernel(false);
                return svm;
            }
            case "RandRotF1": {
                RotationForestLimitedAttributes r3 = new RotationForestLimitedAttributes();
                r3.setNumIterations(200);
                r3.setMaxNumAttributes(100);
                r3.justBuildTheClassifier();
                return r3;
            }
        }
        throw new RuntimeException("Unknown classifier = " + classifier + " in SpectralExperiments");
    }

    public static Classifier setClassifier(String classifier, int fold) {
        Classifier c = null;
        TunedSVM svm = null;
        switch (classifier) {
            case "ED": {
                c = new ED1NN();
                break;
            }
            case "C45": {
                c = new J48();
                break;
            }
            case "NB": {
                c = new NaiveBayes();
                break;
            }
            case "SVML": {
                c = new SMO();
                PolyKernel p = new PolyKernel();
                p.setExponent(1.0);
                ((SMO)c).setKernel(p);
                ((SMO)c).setRandomSeed(fold);
                ((SMO)c).setBuildLogisticModels(true);
                break;
            }
            case "SVMQ": 
            case "SVMQuad": {
                c = new SMO();
                PolyKernel p2 = new PolyKernel();
                p2.setExponent(2.0);
                ((SMO)c).setKernel(p2);
                ((SMO)c).setRandomSeed(fold);
                ((SMO)c).setBuildLogisticModels(true);
                break;
            }
            case "BN": {
                c = new BayesNet();
                break;
            }
            case "MLP": {
                c = new MultilayerPerceptron();
                break;
            }
            case "RandFOOB": {
                c = new TunedRandomForest();
                ((RandomForest)c).setNumTrees(500);
                ((TunedRandomForest)c).tuneParameters(false);
                ((TunedRandomForest)c).setCrossValidate(false);
                ((TunedRandomForest)c).setSeed(fold);
                break;
            }
            case "TunedRandF": {
                c = new TunedRandomForest();
                ((TunedRandomForest)c).tuneParameters(true);
                ((TunedRandomForest)c).setCrossValidate(true);
                ((TunedRandomForest)c).setSeed(fold);
                break;
            }
            case "TunedRandFOOB": {
                c = new TunedRandomForest();
                ((TunedRandomForest)c).tuneParameters(true);
                ((TunedRandomForest)c).setCrossValidate(false);
                ((TunedRotationForest)c).setSeed(fold);
                break;
            }
            case "TunedRotF": {
                c = new TunedRotationForest();
                ((TunedRotationForest)c).tuneParameters(true);
                ((TunedRotationForest)c).setSeed(fold);
                break;
            }
            case "TunedSVMRBF": {
                svm = new TunedSVM();
                svm.setKernelType(TunedSVM.KernelType.RBF);
                svm.optimiseParas(true);
                svm.optimiseKernel(false);
                svm.setBuildLogisticModels(true);
                svm.setSeed(fold);
                c = svm;
                break;
            }
            case "TunedSVMQuad": {
                svm = new TunedSVM();
                svm.setKernelType(TunedSVM.KernelType.QUADRATIC);
                svm.optimiseParas(true);
                svm.optimiseKernel(false);
                svm.setBuildLogisticModels(true);
                svm.setSeed(fold);
                svm.setLargePolynomialParameterSpace(1089);
                c = svm;
                break;
            }
            case "TunedSVMLinear": {
                svm = new TunedSVM();
                svm.setKernelType(TunedSVM.KernelType.LINEAR);
                svm.optimiseParas(true);
                svm.optimiseKernel(false);
                svm.setBuildLogisticModels(true);
                svm.setSeed(fold);
                svm.setLargePolynomialParameterSpace(1089);
                c = svm;
                break;
            }
            case "TunedSVMPolynomial": {
                svm = new TunedSVM();
                svm.setKernelType(TunedSVM.KernelType.POLYNOMIAL);
                svm.optimiseParas(true);
                svm.optimiseKernel(false);
                svm.setBuildLogisticModels(true);
                svm.setSeed(fold);
                c = svm;
                break;
            }
            case "TunedSVMKernel": {
                svm = new TunedSVM();
                svm.optimiseParas(true);
                svm.optimiseKernel(true);
                svm.setBuildLogisticModels(true);
                svm.setSeed(fold);
                c = svm;
                break;
            }
            case "RandomRotationForest1": {
                c = new RotationForestLimitedAttributes();
                ((RotationForestLimitedAttributes)c).setNumIterations(200);
                ((RotationForestLimitedAttributes)c).setMaxNumAttributes(100);
                break;
            }
            case "Logistic": {
                c = new Logistic();
                break;
            }
            case "HESCA": {
                c = new HESCA();
                ((HESCA)c).setRandSeed(fold);
                break;
            }
            case "EE": 
            case "ElasticEnsemble": {
                c = new ElasticEnsemble();
                break;
            }
            case "DTW": {
                c = new DTW1NN();
                ((DTW1NN)c).setWindow(1.0);
                break;
            }
            case "DTWCV": {
                c = new FastDTW_1NN();
                ((FastDTW_1NN)c).optimiseWindow(true);
                break;
            }
            case "DD_DTW": {
                c = new DD_DTW();
                break;
            }
            case "DTD_C": {
                c = new DTD_C();
                break;
            }
            case "CID_DTW": {
                c = new NN_CID();
                ((NN_CID)c).useDTW();
                break;
            }
            case "MSM": {
                c = new MSM1NN();
                break;
            }
            case "TWE": {
                c = new MSM1NN();
                break;
            }
            case "WDTW": {
                c = new WDTW1NN();
                break;
            }
            case "LearnShapelets": 
            case "LS": {
                c = new LearnShapelets();
                break;
            }
            case "FastShapelets": 
            case "FS": {
                c = new FastShapelets();
                break;
            }
            case "ShapeletTransform": 
            case "ST": 
            case "ST_Ensemble": {
                c = new ST_HESCA();
                ((ST_HESCA)c).setOneDayLimit();
                break;
            }
            case "ST_HESCA-log": {
                c = new ST_HESCAlog();
                ((ST_HESCAlog)c).setSeed(fold);
                ((ST_HESCAlog)c).setOneDayLimit();
                break;
            }
            case "TSF": {
                c = new TSF();
                break;
            }
            case "RISE": {
                c = new RISE();
                break;
            }
            case "TSBF": {
                c = new TSBF();
                break;
            }
            case "BOP": 
            case "BoP": 
            case "BagOfPatterns": {
                c = new BagOfPatterns();
                break;
            }
            case "BOSS": 
            case "BOSSEnsemble": {
                c = new BOSS();
                break;
            }
            case "SAXVSM": 
            case "SAX": {
                c = new SAXVSM();
                break;
            }
            case "LPS": {
                c = new LPS();
                break;
            }
            case "FlatCOTE": {
                c = new FlatCote();
                break;
            }
            case "HiveCOTE": {
                c = new HiveCote();
                break;
            }
            default: {
                c = SpectralExperiments.jameslSetClassifier(classifier, fold, -1);
            }
        }
        return c;
    }

    public static void main(String[] args) throws Exception {
        File f;
        for (String str : args) {
            System.out.println(str);
        }
        if (args.length < 6) {
            System.out.println("Num args passed =" + args.length);
            for (String str : args) {
                System.out.println(str);
            }
            DataSets.problemPath = "Z:/Data/AlcoholForgeryFolds/RandomForgery/";
            DataSets.resultsPath = "C:/Temp/hwutpls2/";
            f = new File(DataSets.resultsPath);
            if (!f.isDirectory()) {
                f.mkdirs();
            }
            generateTrainFiles = false;
            checkpoint = true;
            parameterNum = 0;
            String[] newArgs = new String[]{"ST", "AlcoholForgeryEthanol", "1"};
            SpectralExperiments.singleClassifierAndFoldTrainTestSplit(newArgs);
            System.exit(0);
        } else {
            String s;
            DataSets.problemPath = args[0];
            DataSets.resultsPath = args[1];
            generateTrainFiles = Boolean.parseBoolean(args[2]);
            f = new File(DataSets.resultsPath);
            if (!f.isDirectory()) {
                f.mkdirs();
            }
            String[] newArgs = new String[3];
            for (int i = 0; i < 3; ++i) {
                newArgs[i] = args[i + 3];
            }
            checkpoint = false;
            if (args.length >= 7 && (s = args[args.length - 1].toLowerCase()).equals("true")) {
                checkpoint = true;
            }
            parameterNum = 0;
            if (args.length >= 8) {
                parameterNum = Integer.parseInt(args[7]);
            }
            System.out.println("Checkpoint =" + checkpoint + " param number =" + parameterNum);
            SpectralExperiments.singleClassifierAndFoldTrainTestSplit(newArgs);
        }
    }

    public static Instances[] sample(String problem, int fold) {
        Instances train = ClassifierTools.loadData(problem + fold + "_TRAIN");
        Instances test = ClassifierTools.loadData(problem + fold + "_TEST");
        return new Instances[]{train, test};
    }

    public static void singleClassifierAndFoldTrainTestSplit(String[] args) throws Exception {
        String classifier = args[0];
        String problem = args[1];
        int fold = Integer.parseInt(args[2]) - 1;
        String predictions = DataSets.resultsPath + classifier + "/Predictions/" + problem;
        File f = new File(predictions);
        if (!f.exists()) {
            f.mkdirs();
        }
        if (!(f = new File(predictions + "/testFold" + fold + ".csv")).exists() || f.length() == 0L) {
            Classifier c = SpectralExperiments.setClassifier(classifier, fold);
            Instances[] data = SpectralExperiments.sample(DataSets.problemPath + problem + "/" + problem, fold);
            if (c instanceof PLSNominalClassifier && data[0].numAttributes() < ((PLSNominalClassifier)c).getNumComponents()) {
                ((PLSNominalClassifier)c).setNumComponents(data[0].numAttributes() - 1);
            }
            if (parameterNum > 0 && c instanceof ParameterSplittable) {
                checkpoint = false;
                f = new File(predictions + "/fold" + fold + "_" + parameterNum + ".csv");
                if (f.exists() && f.length() > 0L) {
                    System.out.println("Fold " + predictions + "/fold" + fold + "_" + parameterNum + ".csv  already exists");
                    return;
                }
            }
            double acc = SpectralExperiments.singleClassifierAndFoldTrainTestSplit(data[0], data[1], c, fold, predictions);
            System.out.println(classifier + "," + problem + "," + fold + "," + acc);
        }
    }

    public static double singleClassifierAndFoldTrainTestSplit(Instances train, Instances test, Classifier c, int fold, String resultsPath) {
        String testFoldPath = "/testFold" + fold + ".csv";
        String trainFoldPath = "/trainFold" + fold + ".csv";
        ClassifierResults trainResults = null;
        ClassifierResults testResults = null;
        if (parameterNum > 0 && c instanceof ParameterSplittable) {
            checkpoint = false;
            ((ParameterSplittable)((Object)c)).setParametersFromIndex(parameterNum);
            testFoldPath = "/fold" + fold + "_" + parameterNum + ".csv";
            generateTrainFiles = false;
        } else {
            if (c instanceof SaveableEnsemble) {
                ((SaveableEnsemble)((Object)c)).saveResults(resultsPath + "/internalCV_" + fold + ".csv", resultsPath + "/internalTestPreds_" + fold + ".csv");
            }
            if (checkpoint && c instanceof SaveEachParameter) {
                ((SaveEachParameter)((Object)c)).setPathToSaveParameters(resultsPath + "/fold" + fold + "_");
            }
        }
        try {
            if (generateTrainFiles) {
                if (c instanceof TrainAccuracyEstimate) {
                    ((TrainAccuracyEstimate)((Object)c)).writeCVTrainToFile(resultsPath + trainFoldPath);
                } else {
                    int numFolds = Math.min(train.numInstances(), numCVFolds);
                    CrossValidator cv = new CrossValidator();
                    cv.setSeed(fold);
                    cv.setNumFolds(numFolds);
                    trainResults = cv.crossValidateWithStats(c, train);
                }
            }
            long buildTime = System.currentTimeMillis();
            c.buildClassifier(train);
            buildTime = System.currentTimeMillis() - buildTime;
            if (generateTrainFiles && !(c instanceof TrainAccuracyEstimate)) {
                OutFile trainOut = new OutFile(resultsPath + trainFoldPath);
                trainOut.writeLine(train.relationName() + "," + c.getClass().getName() + ",train");
                if (c instanceof SaveParameterInfo) {
                    trainOut.writeLine(((SaveParameterInfo)((Object)c)).getParameters());
                } else {
                    trainOut.writeLine("BuildTime," + buildTime + ",No Parameter Info");
                }
                trainOut.writeLine(trainResults.acc + "");
                trainOut.writeLine(trainResults.writeInstancePredictions());
                trainOut.closeFile();
            }
            int numInsts = test.numInstances();
            testResults = new ClassifierResults(test.numClasses());
            double[] trueClassValues = test.attributeToDoubleArray(test.classIndex());
            for (int testInstIndex = 0; testInstIndex < numInsts; ++testInstIndex) {
                test.instance(testInstIndex).setClassMissing();
                double[] probs = c.distributionForInstance(test.instance(testInstIndex));
                testResults.storeSingleResult(probs);
            }
            testResults.finaliseResults(trueClassValues);
            OutFile testOut = new OutFile(resultsPath + testFoldPath);
            testOut.writeLine(test.relationName() + "," + c.getClass().getName() + ",test");
            if (c instanceof SaveParameterInfo) {
                testOut.writeLine(((SaveParameterInfo)((Object)c)).getParameters());
            } else {
                testOut.writeLine("No parameter info");
            }
            testOut.writeLine(testResults.acc + "");
            testOut.writeString(testResults.writeInstancePredictions());
            testOut.closeFile();
            return testResults.acc;
        }
        catch (Exception e) {
            System.out.println(" Error =" + e + " in method simpleExperiment" + e);
            e.printStackTrace();
            System.out.println(" TRAIN " + train.relationName() + " has " + train.numAttributes() + " attributes and " + train.numInstances() + " instances");
            System.out.println(" TEST " + test.relationName() + " has " + test.numAttributes() + " attributes" + test.numInstances() + " instances");
            return Double.NaN;
        }
    }
}

